/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.annotation.DeprecatedClass;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.AbstractField;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.RemoveOverlappingImageObjects;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;

@DeprecatedClass(useInstead={RemoveOverlappingImageObjects.class})
public class DeleteOverlappingImageObjects
extends AbstractTransformer {
    private static final long serialVersionUID = 3254930183559428182L;
    protected ObjectFinder m_Finder;
    protected double m_MinOverlapRatio;
    protected RemovalStrategy m_RemovalStrategy;
    protected boolean m_DuplicateIndices;

    public String globalInfo() {
        return "Cleans up overlapping objects, e.g., multiple predicted bounding boxes per object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("min-overlap-ratio", "minOverlapRatio", (Object)0.0, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("removal-strategy", "removalStrategy", (Object)RemovalStrategy.REMOVE_SMALLER_OBJECT);
        this.m_OptionManager.add("duplicate-indices", "duplicateIndices", (Object)false);
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder for locating the objects of interest.";
    }

    public void setMinOverlapRatio(double value) {
        if (this.getOptionManager().isValid("minOverlapRatio", (Number)value)) {
            this.m_MinOverlapRatio = value;
            this.reset();
        }
    }

    public double getMinOverlapRatio() {
        return this.m_MinOverlapRatio;
    }

    public String minOverlapRatioTipText() {
        return "The minimum ratio that an overlap must have before being considered an actual overlap.";
    }

    public void setRemovalStrategy(RemovalStrategy value) {
        this.m_RemovalStrategy = value;
        this.reset();
    }

    public RemovalStrategy getRemovalStrategy() {
        return this.m_RemovalStrategy;
    }

    public String removalStrategyTipText() {
        return "The strategy for removing overlapping objects.";
    }

    public void setDuplicateIndices(boolean value) {
        this.m_DuplicateIndices = value;
        this.reset();
    }

    public boolean getDuplicateIndices() {
        return this.m_DuplicateIndices;
    }

    public String duplicateIndicesTipText() {
        return "Whether to check for duplicate indices among objects to be deleted (same object).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"minOverlapRatio", (Object)this.m_MinOverlapRatio, (String)", overlap ratio: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"removalStrategy", (Object)((Object)this.m_RemovalStrategy), (String)", strategy: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"duplicateIndices", (boolean)this.m_DuplicateIndices, (String)", duplicate indices: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    protected String doExecute() {
        Object output;
        String result;
        block32: {
            result = null;
            Report report = null;
            output = null;
            if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
                report = ((AbstractImageContainer)this.m_InputToken.getPayload()).getReport();
            } else if (this.m_InputToken.getPayload() instanceof Report) {
                report = (Report)this.m_InputToken.getPayload();
            } else if (this.m_InputToken.getPayload() instanceof ReportHandler) {
                report = ((ReportHandler)this.m_InputToken.getPayload()).getReport();
            } else {
                result = "Unsupported input class: " + Utils.classToString((Object)this.m_InputToken.getPayload());
            }
            if (report != null) {
                LocatedObject obj2;
                int n;
                LocatedObject obj1;
                int i;
                LocatedObjects objects = this.m_Finder.findObjects(LocatedObjects.fromReport(report, this.m_Finder.getPrefix()));
                TIntHashSet delete = new TIntHashSet();
                if (this.m_DuplicateIndices) {
                    TIntHashSet allIndices = new TIntHashSet();
                    for (i = 0; i < objects.size(); ++i) {
                        obj1 = (LocatedObject)objects.get(i);
                        allIndices.add(obj1.getIndex());
                    }
                    for (int r = 0; r < 2; ++r) {
                        for (i = 0; i < objects.size() - 1; ++i) {
                            obj1 = (LocatedObject)objects.get(i);
                            for (n = i + 1; n < objects.size(); ++n) {
                                obj2 = (LocatedObject)objects.get(n);
                                if (obj1.getIndex() != obj2.getIndex()) continue;
                                int o = obj2.getIndex();
                                while (allIndices.contains(++o)) {
                                }
                                allIndices.add(o);
                                String newIndex = "" + o;
                                obj2.getMetaData().put("index", newIndex);
                            }
                        }
                    }
                }
                for (i = 0; i < objects.size() - 2; ++i) {
                    obj1 = (LocatedObject)objects.get(i);
                    block13: for (n = i + 1; n < objects.size() - 1; ++n) {
                        obj2 = (LocatedObject)objects.get(n);
                        if (!(obj1.overlapRatio(obj2) >= this.m_MinOverlapRatio) && !(obj2.overlapRatio(obj1) >= this.m_MinOverlapRatio)) continue;
                        int area1 = obj1.getWidth() * obj1.getHeight();
                        int area2 = obj2.getWidth() * obj2.getHeight();
                        switch (this.m_RemovalStrategy) {
                            case REMOVE_LARGER_OBJECT: {
                                if (area1 > area2) {
                                    delete.add(obj1.getIndex());
                                    continue block13;
                                }
                                delete.add(obj2.getIndex());
                                continue block13;
                            }
                            case REMOVE_SMALLER_OBJECT: {
                                if (area1 < area2) {
                                    delete.add(obj1.getIndex());
                                    continue block13;
                                }
                                delete.add(obj2.getIndex());
                                continue block13;
                            }
                            case REMOVE_BOTH: {
                                delete.add(obj1.getIndex());
                                delete.add(obj2.getIndex());
                                continue block13;
                            }
                            default: {
                                throw new IllegalStateException("Unhandled removal strategy: " + (Object)((Object)this.m_RemovalStrategy));
                            }
                        }
                    }
                }
                if (delete.size() > 0) {
                    int[] deleteIndices = delete.toArray();
                    Arrays.sort(deleteIndices);
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Object indices to remove: " + Utils.arrayToString((Object)deleteIndices));
                    }
                    objects.remove(deleteIndices);
                    try {
                        Report newReport = (Report)report.getClass().newInstance();
                        for (AbstractField field : report.getFields()) {
                            if (field.getName().startsWith(this.m_Finder.getPrefix())) continue;
                            newReport.addField(field);
                            newReport.setValue(field, report.getValue(field));
                        }
                        newReport.mergeWith(objects.toReport(this.m_Finder.getPrefix()));
                        if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
                            output = this.m_InputToken.getPayload();
                            ((AbstractImageContainer)output).setReport(newReport);
                            break block32;
                        }
                        if (this.m_InputToken.getPayload() instanceof MutableReportHandler) {
                            output = this.m_InputToken.getPayload();
                            ((MutableReportHandler)output).setReport(newReport);
                            break block32;
                        }
                        output = newReport;
                    }
                    catch (Exception e) {
                        result = this.handleException("Failed to create new report with updated objects!", e);
                        output = null;
                    }
                } else {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("No overlapping objects removed!");
                    }
                    output = this.m_InputToken.getPayload();
                }
            }
        }
        if (output != null) {
            this.m_OutputToken = new Token(output);
        }
        return result;
    }

    public static enum RemovalStrategy {
        REMOVE_SMALLER_OBJECT,
        REMOVE_LARGER_OBJECT,
        REMOVE_BOTH;

    }
}

