/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.objectoverlap.AreaRatio;
import adams.data.objectoverlap.ObjectOverlap;
import adams.data.report.AbstractField;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.util.HashSet;

public class DetermineOverlappingObjects
extends AbstractTransformer {
    private static final long serialVersionUID = 8175397929496972306L;
    protected StorageName m_StorageName;
    protected boolean m_CompareWithItself;
    protected ObjectFinder m_Finder;
    protected ObjectOverlap m_Algorithm;

    public String globalInfo() {
        return "Computes the overlap of objects with the specified report from storage (or itself) using the specified algorithm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
        this.m_OptionManager.add("compare-with-itself", "compareWithItself", (Object)false);
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new AreaRatio());
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage item to merge with (Report or ReportHandler).";
    }

    public void setCompareWithItself(boolean value) {
        this.m_CompareWithItself = value;
        this.reset();
    }

    public boolean getCompareWithItself() {
        return this.m_CompareWithItself;
    }

    public String compareWithItselfTipText() {
        return "If enabled, compares the incoming report with itself rather than the one from storage.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder for locating the objects of interest.";
    }

    public void setAlgorithm(ObjectOverlap value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public ObjectOverlap getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The algorithm to use for determining the overlapping objects.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)this.m_Algorithm, (String)", algorithm: ");
        result = this.m_CompareWithItself ? result + ", with itself" : result + QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)", storage: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    protected String doExecute() {
        String result = null;
        Object output = null;
        Report thisReport = null;
        Report otherReport = null;
        LocatedObjects newObjs = null;
        if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
            thisReport = ((AbstractImageContainer)this.m_InputToken.getPayload()).getReport();
        } else if (this.m_InputToken.getPayload() instanceof Report) {
            thisReport = (Report)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof ReportHandler) {
            thisReport = ((ReportHandler)this.m_InputToken.getPayload()).getReport();
        } else {
            result = "Unsupported input class: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (thisReport != null) {
            LocatedObjects otherObjs;
            LocatedObjects thisObjs;
            if (this.m_CompareWithItself) {
                LocatedObjects allObjs = this.m_Finder.findObjects(LocatedObjects.fromReport(thisReport, this.m_Finder.getPrefix()));
                newObjs = new LocatedObjects();
                HashSet<LocatedObject> overlaps = new HashSet<LocatedObject>();
                for (int i = 0; i < allObjs.size() - 1; ++i) {
                    thisObjs = new LocatedObjects((LocatedObject)allObjs.get(i));
                    otherObjs = new LocatedObjects(allObjs.subList(i + 1, i + 2));
                    overlaps.addAll(this.m_Algorithm.calculate(thisObjs, otherObjs));
                }
                newObjs.addAll(overlaps);
            } else {
                Object obj = this.getStorageHandler().getStorage().get(this.m_StorageName);
                if (obj == null) {
                    result = "Failed to retrieve storage item: " + this.m_StorageName;
                } else if (obj instanceof Report) {
                    otherReport = (Report)obj;
                } else if (obj instanceof ReportHandler) {
                    otherReport = ((ReportHandler)obj).getReport();
                } else {
                    result = "Unhandled type of storage item '" + this.m_StorageName + "': " + Utils.classToString((Object)obj);
                }
                if (otherReport != null) {
                    thisObjs = this.m_Finder.findObjects(LocatedObjects.fromReport(thisReport, this.m_Finder.getPrefix()));
                    otherObjs = this.m_Finder.findObjects(LocatedObjects.fromReport(otherReport, this.m_Finder.getPrefix()));
                    newObjs = this.m_Algorithm.calculate(thisObjs, otherObjs);
                }
            }
        }
        if (newObjs != null) {
            try {
                Report newReport = (Report)thisReport.getClass().newInstance();
                for (AbstractField field : thisReport.getFields()) {
                    if (field.getName().startsWith(this.m_Finder.getPrefix())) continue;
                    newReport.addField(field);
                    newReport.setValue(field, thisReport.getValue(field));
                }
                newReport.mergeWith(newObjs.toReport(this.m_Finder.getPrefix()));
                if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
                    output = this.m_InputToken.getPayload();
                    ((AbstractImageContainer)output).setReport(newReport);
                } else if (this.m_InputToken.getPayload() instanceof MutableReportHandler) {
                    output = this.m_InputToken.getPayload();
                    ((MutableReportHandler)output).setReport(newReport);
                } else {
                    output = newReport;
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to create new report with updated objects!", e);
                output = null;
            }
        }
        if (output != null) {
            this.m_OutputToken = new Token(output);
        }
        return result;
    }
}

