/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.InPlaceProcessing;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.draw.AbstractDrawOperation;
import adams.flow.transformer.draw.Pixel;
import java.awt.image.BufferedImage;

public class Draw
extends AbstractTransformer
implements InPlaceProcessing {
    private static final long serialVersionUID = -7871688022041775952L;
    protected boolean m_NoCopy;
    protected AbstractDrawOperation m_Operation;

    public String globalInfo() {
        return "Performs a draw operation on an image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new Pixel());
        this.m_OptionManager.add("no-copy", "noCopy", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)((Object)this.m_Operation));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no-copy", (String)", ");
        return result;
    }

    public void setOperation(AbstractDrawOperation value) {
        this.m_Operation = value;
        this.reset();
    }

    public AbstractDrawOperation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The draw operation to perform.";
    }

    public void setNoCopy(boolean value) {
        this.m_NoCopy = value;
        this.reset();
    }

    public boolean getNoCopy() {
        return this.m_NoCopy;
    }

    public String noCopyTipText() {
        return "If enabled, no copy of the image is created before processing it.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected String doExecute() {
        AbstractImageContainer contIn = (AbstractImageContainer)this.m_InputToken.getPayload(AbstractImageContainer.class);
        if (!this.m_NoCopy) {
            contIn = (AbstractImageContainer)contIn.getClone();
        }
        BufferedImageContainer contBuff = new BufferedImageContainer();
        contBuff.setReport(contIn.getReport().getClone());
        contBuff.setImage((Object)contIn.toBufferedImage());
        this.m_Operation.setOwner((Actor)this);
        String result = this.m_Operation.draw(contBuff);
        if (result == null) {
            BufferedImageContainer contOut = (BufferedImageContainer)contBuff.getHeader();
            contOut.setReport(contIn.getReport().getClone());
            contOut.setImage((Object)((BufferedImage)contBuff.getImage()));
            this.m_OutputToken = new Token((Object)contOut);
        }
        return result;
    }
}

