/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collections;

public class GetImageObjectIndices
extends AbstractArrayProvider {
    private static final long serialVersionUID = -5644432725273726622L;
    protected ObjectFinder m_Finder;
    protected boolean m_Sort;

    public String globalInfo() {
        return "Uses the specified object finder to locate objects and forwards the indices.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("sort", "sort", (Object)true);
    }

    protected Class getItemClass() {
        return String.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the indices get output as array instead of one-by-one.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use for locating objects in the report.";
    }

    public void setSort(boolean value) {
        this.m_Sort = value;
        this.reset();
    }

    public boolean getSort() {
        return this.m_Sort;
    }

    public String sortTipText() {
        return "If enabled, the indices get sorted before output.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, Report.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sort", (boolean)this.m_Sort, (String)"sorted", (String)", ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        Report report = null;
        if (this.m_InputToken.hasPayload(AbstractImageContainer.class)) {
            report = ((AbstractImageContainer)this.m_InputToken.getPayload(AbstractImageContainer.class)).getReport();
        } else if (this.m_InputToken.hasPayload(Report.class)) {
            report = (Report)this.m_InputToken.getPayload(Report.class);
        } else {
            result = "Unhandled input: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        this.m_Queue.clear();
        if (result == null) {
            LocatedObjects objects = LocatedObjects.fromReport(report, this.m_Finder.getPrefix());
            TIntHashSet set = new TIntHashSet(this.m_Finder.find(report));
            for (LocatedObject obj : objects) {
                if (!set.contains(obj.getIndex())) continue;
                this.m_Queue.add(obj.getIndexString());
            }
        }
        if (this.m_Sort) {
            Collections.sort(this.m_Queue);
        }
        return result;
    }
}

