/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class GetImageObjects
extends AbstractArrayProvider {
    private static final long serialVersionUID = -5644432725273726622L;
    protected ObjectFinder m_Finder;
    protected boolean m_CleanIndices;

    public String globalInfo() {
        return "Uses the specified object finder to locate objects and forwards the objects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("clean-indices", "cleanIndices", (Object)false);
    }

    protected Class getItemClass() {
        return LocatedObject.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the indices get output as array instead of one-by-one.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use for locating objects in the report.";
    }

    public void setCleanIndices(boolean value) {
        this.m_CleanIndices = value;
        this.reset();
    }

    public boolean getCleanIndices() {
        return this.m_CleanIndices;
    }

    public String cleanIndicesTipText() {
        return "If enabled, all potential index entries get removed from the meta-data.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, Report.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"cleanIndices", (boolean)this.m_CleanIndices, (String)"clean indices", (String)", ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        Report report = null;
        if (this.m_InputToken.hasPayload(AbstractImageContainer.class)) {
            report = ((AbstractImageContainer)this.m_InputToken.getPayload(AbstractImageContainer.class)).getReport();
        } else if (this.m_InputToken.hasPayload(Report.class)) {
            report = (Report)this.m_InputToken.getPayload(Report.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        this.m_Queue.clear();
        if (result == null) {
            LocatedObjects objects = LocatedObjects.fromReport(report, this.m_Finder.getPrefix());
            if (this.m_CleanIndices) {
                objects.resetIndex();
            }
            this.m_Queue.addAll(objects.subset(this.m_Finder.find(objects)));
        }
        return result;
    }
}

