/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.QuickInfoHelper;
import adams.core.annotation.DeprecatedClass;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.conversion.MapToJson;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.flow.transformer.ImageObjectAnnotator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseToggleButton;
import adams.gui.core.ColorHelper;
import adams.gui.core.KeyUtils;
import adams.gui.event.ImagePanelLeftClickEvent;
import adams.gui.event.ImagePanelLeftClickListener;
import adams.gui.event.ImagePanelSelectionListener;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.NullOverlay;
import adams.gui.visualization.image.TypeColorProvider;
import adams.gui.visualization.image.interactionlogging.InteractionEvent;
import adams.gui.visualization.image.interactionlogging.InteractionLogManager;
import adams.gui.visualization.image.interactionlogging.InteractionLoggingFilter;
import adams.gui.visualization.image.interactionlogging.Null;
import adams.gui.visualization.image.selection.NullProcessor;
import adams.gui.visualization.image.selection.SelectionProcessor;
import adams.gui.visualization.image.selection.SelectionProcessorWithLabelSupport;
import adams.gui.visualization.image.selectionshape.RectanglePainter;
import adams.gui.visualization.image.selectionshape.SelectionShapePainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

@DeprecatedClass(useInstead={ImageObjectAnnotator.class})
public class ImageAnnotator
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = -3374468402777151698L;
    public static final String FIELD_INTERACTIONLOG = "interaction-log";
    public static final String UNSET = "[unset]";
    protected String m_Prefix;
    protected String m_Suffix;
    protected BaseString[] m_Labels;
    protected SelectionProcessor m_SelectionProcessor;
    protected SelectionShapePainter m_SelectionShapePainter;
    protected ImageOverlay m_Overlay;
    protected double m_Zoom;
    protected InteractionLoggingFilter m_InteractionLoggingFilter;
    protected boolean m_Accepted;
    protected transient String m_LastLabel;
    protected transient Integer m_LastMainDividerLocation;
    protected transient Date m_StartTimestamp;

    public String globalInfo() {
        return "Allows the user to label objects located on the image and pass on this enriched meta-data.\nAny logged interaction will get added as JSON under interaction-log in the report.\nClicking on objects while holding down the SHIFT key removes them.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("suffix", "suffix", (Object)".type");
        this.m_OptionManager.add("label", "labels", (Object)new BaseString[0]);
        this.m_OptionManager.add("selection-processor", "selectionProcessor", (Object)new NullProcessor());
        this.m_OptionManager.add("selection-shape-painter", "selectionShapePainter", (Object)new RectanglePainter());
        this.m_OptionManager.add("overlay", "overlay", (Object)new NullOverlay());
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0, (Number)-1.0, (Number)1600.0);
        this.m_OptionManager.add("interaction-logging-filter", "interactionLoggingFilter", (Object)new Null());
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix to use for the located objects.";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The report field suffix to use for the labels.";
    }

    public void setLabels(BaseString[] value) {
        this.m_Labels = value;
        this.reset();
    }

    public BaseString[] getLabels() {
        return this.m_Labels;
    }

    public String labelsTipText() {
        return "The labels to use.";
    }

    public void setSelectionProcessor(SelectionProcessor value) {
        this.m_SelectionProcessor = value;
        this.reset();
    }

    public SelectionProcessor getSelectionProcessor() {
        return this.m_SelectionProcessor;
    }

    public String selectionProcessorTipText() {
        return "The selection processor to use.";
    }

    public void setSelectionShapePainter(SelectionShapePainter value) {
        this.m_SelectionShapePainter = value;
        this.reset();
    }

    public SelectionShapePainter getSelectionShapePainter() {
        return this.m_SelectionShapePainter;
    }

    public String selectionShapePainterTipText() {
        return "The painter to use for the selection shape.";
    }

    public void setOverlay(ImageOverlay value) {
        this.m_Overlay = value;
        this.reset();
    }

    public ImageOverlay getOverlay() {
        return this.m_Overlay;
    }

    public String overlayTipText() {
        return "The overlay to use for highlighting the objects.";
    }

    public void setZoom(double value) {
        if (value == -1.0 || value > 0.0 && value <= 1600.0) {
            this.m_Zoom = value;
            this.reset();
        } else {
            this.getLogger().warning("Zoom must -1 to fit window or 0 < x < 1600, provided: " + value);
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public void setInteractionLoggingFilter(InteractionLoggingFilter value) {
        this.m_InteractionLoggingFilter = value;
        this.reset();
    }

    public InteractionLoggingFilter getInteractionLoggingFilter() {
        return this.m_InteractionLoggingFilter;
    }

    public String interactionLoggingFilterTipText() {
        return "The interaction logger to use.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"selectionProcessor", (Object)this.m_SelectionProcessor, (String)", selection: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"overlay", (Object)this.m_Overlay, (String)", overlay: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"labels", (Object)this.m_Labels, (String)", labels: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    public void clearPanel() {
    }

    protected BasePanel newPanel() {
        return new AnnotatorPanel(this.m_Prefix, this.m_Suffix, this.m_Labels, this.m_SelectionProcessor, this.m_SelectionShapePainter, this.m_Overlay, this.m_Zoom, this.m_InteractionLoggingFilter);
    }

    protected void postCreateDialog(BaseDialog dialog, BasePanel panel) {
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        dialog.getContentPane().add((Component)panelButtons, "South");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.addActionListener(e -> {
            this.m_Accepted = true;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonCancel = new BaseButton("Cancel");
        buttonCancel.addActionListener(e -> {
            this.m_Accepted = false;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonCancel);
    }

    protected void addInteractionsToReport(Report report, List<InteractionEvent> events) {
        JSONObject interaction;
        if (events == null) {
            return;
        }
        JSONArray array = new JSONArray();
        MapToJson m2j = new MapToJson();
        DateFormat formatter = DateUtils.getTimestampFormatterMsecs();
        Field field = new Field(FIELD_INTERACTIONLOG, DataType.STRING);
        if (report.hasValue((AbstractField)field)) {
            String value = "" + report.getValue((AbstractField)field);
            if (value.isEmpty()) {
                array = new JSONArray();
            } else {
                try {
                    JSONParser parser = new JSONParser(1984);
                    array = (JSONArray)parser.parse(value);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to parse old interactions: " + value, (Throwable)e);
                }
            }
        }
        if (array.size() > 0) {
            interaction = new JSONObject();
            interaction.put((Object)"timestamp", (Object)formatter.format(this.m_StartTimestamp));
            interaction.put((Object)"id", (Object)"---");
            array.add((Object)interaction);
        }
        for (InteractionEvent event : events) {
            interaction = new JSONObject();
            interaction.put((Object)"timestamp", (Object)formatter.format(event.getTimestamp()));
            interaction.put((Object)"id", (Object)event.getID());
            if (event.getData() != null) {
                m2j.setInput((Object)event.getData());
                String msg = m2j.convert();
                if (msg == null) {
                    interaction.put((Object)"data", m2j.getOutput());
                } else {
                    this.getLogger().warning("Failed to convert interaction data to JSON: " + event.getData());
                }
            }
            array.add((Object)interaction);
        }
        report.addField((AbstractField)field);
        report.setValue((AbstractField)field, (Object)array.toString());
    }

    public boolean doInteract() {
        this.m_Accepted = false;
        AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload();
        this.m_StartTimestamp = new Date();
        this.registerWindow((Window)this.m_Dialog, this.m_Dialog.getTitle());
        ((AnnotatorPanel)this.m_Panel).clearInteractionLog();
        ((AnnotatorPanel)this.m_Panel).setCurrentImage(cont);
        ((AnnotatorPanel)this.m_Panel).preselectLabel(this.m_LastLabel);
        if (this.m_LastMainDividerLocation != null) {
            ((AnnotatorPanel)this.m_Panel).setMainDividerLocation(this.m_LastMainDividerLocation);
        }
        this.m_Dialog.setVisible(true);
        this.deregisterWindow((Window)this.m_Dialog);
        this.m_LastLabel = ((AnnotatorPanel)this.m_Panel).getCurrentLabel();
        this.m_LastMainDividerLocation = ((AnnotatorPanel)this.m_Panel).getMainDividerLocation();
        if (this.m_Accepted) {
            cont = ((AnnotatorPanel)this.m_Panel).getCurrentImage();
            cont.setReport(((AnnotatorPanel)this.m_Panel).getCurrentReport());
            if (!(this.m_InteractionLoggingFilter instanceof Null)) {
                this.addInteractionsToReport(cont.getReport(), ((AnnotatorPanel)this.m_Panel).getInteractionLog());
            }
            this.m_OutputToken = new Token((Object)cont);
        }
        return this.m_Accepted;
    }

    public static class AnnotatorPanel
    extends BasePanel
    implements ImagePanelLeftClickListener {
        private static final long serialVersionUID = 301202246788374114L;
        protected String m_Prefix;
        protected String m_Suffix;
        protected BaseString[] m_Labels;
        protected SelectionProcessor m_SelectionProcessor;
        protected SelectionShapePainter m_SelectionShapePainter;
        protected ImageOverlay m_Overlay;
        protected double m_Zoom;
        protected InteractionLoggingFilter m_InteractionLoggingFilter;
        protected BaseToggleButton[] m_ButtonLabels;
        protected BaseToggleButton m_ButtonUnset;
        protected BaseButton m_ButtonReset;
        protected ButtonGroup m_ButtonGroup;
        protected ImagePanel m_PanelImage;
        protected String m_CurrentLabel;
        protected AbstractImageContainer m_CurrentImage;
        protected Report m_ReportBackup;
        protected LocatedObjects m_Objects;
        protected Double m_CurrentScale;
        protected SelectionProcessor m_ActualSelectionProcessor;
        protected ImageOverlay m_ActualOverlay;

        public AnnotatorPanel(String prefix, String suffix, BaseString[] labels, SelectionProcessor selectionProcessor, SelectionShapePainter selectionShapePainter, ImageOverlay overlay, double zoom, InteractionLoggingFilter interactionLoggingFilter) {
            this.m_Prefix = prefix;
            this.m_Suffix = suffix;
            this.m_Labels = labels;
            this.m_SelectionProcessor = selectionProcessor;
            this.m_SelectionShapePainter = selectionShapePainter;
            this.m_Overlay = overlay;
            this.m_Zoom = zoom;
            this.m_InteractionLoggingFilter = interactionLoggingFilter;
            this.initialize();
            this.initGUI();
            this.finishInit();
        }

        protected void initialize() {
            if (this.m_Labels == null) {
                return;
            }
            super.initialize();
            this.m_CurrentLabel = null;
            if (this.m_Labels.length > 0) {
                this.m_CurrentLabel = this.m_Labels[0].getValue();
            }
            this.m_CurrentImage = null;
            this.m_ReportBackup = null;
            this.m_Objects = new LocatedObjects();
            this.m_CurrentScale = null;
            this.m_ActualSelectionProcessor = null;
            this.m_ActualOverlay = null;
        }

        protected void initGUI() {
            GridBagConstraints con;
            int i;
            if (this.m_Labels == null) {
                return;
            }
            super.initGUI();
            this.setLayout(new BorderLayout());
            JPanel panelLeft = new JPanel(new BorderLayout(5, 5));
            this.add(panelLeft, "West");
            int gapHorizontal = 5;
            int gapVertical = 2;
            GridBagLayout layout = new GridBagLayout();
            JPanel panelButtons = new JPanel(layout);
            panelLeft.add((Component)new BaseScrollPane((Component)panelButtons), "Center");
            this.m_ButtonGroup = new ButtonGroup();
            ArrayList<Object> comps = new ArrayList<Object>();
            this.m_ButtonLabels = new BaseToggleButton[this.m_Labels.length];
            for (i = 0; i < this.m_Labels.length; ++i) {
                String label = this.m_Labels[i].getValue();
                this.m_ButtonLabels[i] = new BaseToggleButton(label);
                this.m_ButtonLabels[i].addActionListener(e -> this.setCurrentLabel(label));
                if (i == 0) {
                    this.m_ButtonLabels[i].setSelected(true);
                }
                this.m_ButtonGroup.add((AbstractButton)this.m_ButtonLabels[i]);
                comps.add(this.m_ButtonLabels[i]);
            }
            this.m_ButtonUnset = new BaseToggleButton("Unset");
            this.m_ButtonUnset.addActionListener(e -> this.setCurrentLabel(null));
            comps.add(this.m_ButtonUnset);
            this.m_ButtonGroup.add((AbstractButton)this.m_ButtonUnset);
            this.m_ButtonReset = new BaseButton("Reset");
            this.m_ButtonReset.addActionListener(e -> this.resetLabels());
            comps.add(this.m_ButtonReset);
            for (i = 0; i < comps.size(); ++i) {
                con = new GridBagConstraints();
                con.anchor = 17;
                con.fill = 2;
                con.gridy = i;
                con.gridx = 0;
                con.weightx = 100.0;
                con.ipadx = 20;
                con.insets = new Insets(gapVertical, gapHorizontal, gapVertical, gapHorizontal);
                layout.setConstraints((Component)comps.get(i), con);
                panelButtons.add((Component)comps.get(i));
            }
            JPanel panel = new JPanel();
            con = new GridBagConstraints();
            con.anchor = 17;
            con.fill = 1;
            con.gridy = comps.size();
            con.gridx = 0;
            con.weighty = 100.0;
            con.gridwidth = 0;
            layout.setConstraints(panel, con);
            panelButtons.add(panel);
            this.m_PanelImage = new ImagePanel();
            this.m_PanelImage.setShowProperties(true);
            this.m_PanelImage.setScale(this.m_Zoom);
            this.m_PanelImage.addLeftClickListener((ImagePanelLeftClickListener)this);
            this.m_ActualOverlay = (ImageOverlay)OptionUtils.shallowCopy((OptionHandler)this.m_Overlay, (boolean)false, (boolean)true);
            if (this.m_ActualOverlay instanceof TypeColorProvider) {
                ((TypeColorProvider)this.m_ActualOverlay).addLocationsUpdatedListeners(e -> this.updateLabelButtons());
            }
            this.m_PanelImage.addImageOverlay(this.m_ActualOverlay);
            this.m_ActualSelectionProcessor = (SelectionProcessor)OptionUtils.shallowCopy((OptionHandler)this.m_SelectionProcessor, (boolean)false, (boolean)true);
            this.m_PanelImage.addSelectionListener((ImagePanelSelectionListener)this.m_ActualSelectionProcessor);
            this.m_PanelImage.setSelectionShapePainter((SelectionShapePainter)OptionUtils.shallowCopy((OptionHandler)this.m_SelectionShapePainter, (boolean)false, (boolean)true));
            this.m_PanelImage.setSelectionEnabled(true);
            this.m_PanelImage.setInteractionLoggingFilter((InteractionLoggingFilter)OptionUtils.shallowCopy((OptionHandler)this.m_InteractionLoggingFilter, (boolean)false, (boolean)true));
            this.add((Component)this.m_PanelImage, "Center");
        }

        protected void finishInit() {
            if (this.m_Labels == null) {
                return;
            }
            super.finishInit();
            if (this.m_ButtonLabels.length > 0) {
                this.m_ButtonLabels[0].doClick();
            }
        }

        public ImagePanel getImagePanel() {
            return this.m_PanelImage;
        }

        protected void updateLabelButtons() {
            if (this.m_ActualOverlay instanceof TypeColorProvider) {
                TypeColorProvider provider = (TypeColorProvider)this.m_ActualOverlay;
                for (int i = 0; i < this.m_Labels.length; ++i) {
                    String label = this.m_Labels[i].getValue();
                    if (provider.hasTypeColor(label)) {
                        this.m_ButtonLabels[i].setText("<html><font color=\"" + ColorHelper.toHex((Color)provider.getTypeColor(label)) + "\">&#x2588;</font> " + label + "</html>");
                        continue;
                    }
                    this.m_ButtonLabels[i].setText(label);
                }
            }
        }

        protected void setCurrentLabel(String label) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("old-label", this.m_CurrentLabel == null ? ImageAnnotator.UNSET : this.m_CurrentLabel);
            data.put("new-label", label == null ? ImageAnnotator.UNSET : label);
            this.m_PanelImage.getInteractionLoggingFilter().filterInteractionLog(new InteractionEvent((InteractionLogManager)this.m_PanelImage, new Date(), "change label", data));
            this.m_CurrentLabel = label;
            this.notifyLabelChange(label);
        }

        protected void notifyLabelChange(String label) {
            if (this.m_ActualSelectionProcessor instanceof SelectionProcessorWithLabelSupport) {
                ((SelectionProcessorWithLabelSupport)this.m_ActualSelectionProcessor).setLabel(label == null ? "" : label);
            }
        }

        public String getCurrentLabel() {
            return this.m_CurrentLabel;
        }

        protected void resetLabels() {
            this.m_PanelImage.getInteractionLoggingFilter().filterInteractionLog(new InteractionEvent((InteractionLogManager)this.m_PanelImage, new Date(), "reset labels"));
            this.m_CurrentImage.setReport(this.m_ReportBackup.getClone());
            this.m_PanelImage.setCurrentImage(this.m_CurrentImage, this.m_PanelImage.getScale());
            this.updateObjects();
        }

        public void preselectLabel(String label) {
            if (label == null) {
                return;
            }
            for (int i = 0; i < this.m_Labels.length; ++i) {
                if (!this.m_Labels[i].getValue().equals(label)) continue;
                this.m_ButtonLabels[i].setSelected(true);
                this.m_CurrentLabel = label;
                break;
            }
            this.notifyLabelChange(label);
        }

        public int getMainDividerLocation() {
            return this.m_PanelImage.getMainDividerLocation();
        }

        public void setMainDividerLocation(int value) {
            this.m_PanelImage.setMainDividerLocation(value);
        }

        public void setCurrentImage(AbstractImageContainer value) {
            this.m_ReportBackup = value.getReport().getClone();
            this.m_CurrentImage = value;
            if (this.m_PanelImage.getCurrentImage() == null) {
                this.m_PanelImage.setCurrentImage(value, this.m_Zoom);
            } else {
                this.m_PanelImage.setCurrentImage(value, this.m_PanelImage.getScale());
            }
        }

        public void setCurrentImage(AbstractImageContainer value, double zoom) {
            this.m_ReportBackup = value.getReport().getClone();
            this.m_CurrentImage = value;
            this.m_PanelImage.setCurrentImage(value, zoom);
        }

        public AbstractImageContainer getCurrentImage() {
            return this.m_CurrentImage;
        }

        public Report getCurrentReport() {
            return this.m_PanelImage.getAdditionalProperties();
        }

        protected void updateObjects() {
            if (this.m_CurrentImage == null) {
                this.m_Objects = new LocatedObjects();
                return;
            }
            Report report = this.m_PanelImage.getAdditionalProperties();
            if (report == null) {
                report = this.m_CurrentImage.getReport();
            }
            LocatedObjects located = LocatedObjects.fromReport(report, this.m_Prefix);
            double actual = this.m_PanelImage.calcActualScale(this.m_PanelImage.getScale());
            located.scale(actual);
            this.m_Objects = located;
        }

        public void imageChanged(ImagePanel.PaintPanel panel) {
            this.updateObjects();
        }

        protected void logLabelClick(boolean add, LocatedObject object, String label) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.putAll(object.getMetaData());
            data.put("x", object.getX());
            data.put("y", object.getY());
            data.put("width", object.getWidth());
            data.put("height", object.getWidth());
            if (object.hasPolygon()) {
                data.put("poly_x", object.getPolygonX());
                data.put("poly_y", object.getPolygonY());
            }
            if (label == null) {
                data.put("label", ImageAnnotator.UNSET);
            } else {
                data.put("label", label);
            }
            this.m_PanelImage.getInteractionLoggingFilter().filterInteractionLog(new InteractionEvent((InteractionLogManager)this.m_PanelImage, new Date(), add ? "left-click-set-label" : "left-click-remove-label", data));
        }

        protected void logObjectRemoval(LocatedObject object) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.putAll(object.getMetaData());
            data.put("x", object.getX());
            data.put("y", object.getY());
            data.put("width", object.getWidth());
            data.put("height", object.getWidth());
            if (object.hasPolygon()) {
                data.put("poly_x", object.getPolygonX());
                data.put("poly_y", object.getPolygonY());
            }
            this.m_PanelImage.getInteractionLoggingFilter().filterInteractionLog(new InteractionEvent((InteractionLogManager)this.m_PanelImage, new Date(), "remove", data));
        }

        public void clicked(ImagePanelLeftClickEvent e) {
            if (KeyUtils.isNoneDown((int)e.getModifiersEx())) {
                double actual = this.m_PanelImage.calcActualScale(this.m_PanelImage.getScale());
                if (this.m_CurrentScale == null || this.m_CurrentScale != actual) {
                    this.updateObjects();
                    this.m_CurrentScale = actual;
                }
                boolean hit = false;
                Report report = this.m_PanelImage.getAdditionalProperties();
                for (LocatedObject obj : this.m_Objects) {
                    boolean contained = obj.hasPolygon() ? obj.getActualPolygon().contains(e.getPosition()) : obj.getActualRectangle().contains(e.getPosition());
                    if (!contained) continue;
                    hit = true;
                    if (this.m_CurrentLabel == null) {
                        obj.getMetaData().remove(this.m_Suffix.substring(1));
                        this.logLabelClick(false, obj, this.m_CurrentLabel);
                        break;
                    }
                    this.logLabelClick(true, obj, this.m_CurrentLabel);
                    obj.getMetaData().put(this.m_Suffix.substring(1), this.m_CurrentLabel);
                    break;
                }
                if (hit) {
                    report = this.m_PanelImage.getAdditionalProperties().getClone();
                    report.removeValuesStartingWith(this.m_Prefix);
                    Report reportNew = this.m_Objects.toReport(this.m_Prefix);
                    reportNew.mergeWith(report);
                    this.m_PanelImage.setAdditionalProperties(reportNew);
                    this.updateObjects();
                }
            } else if (KeyUtils.isOnlyShiftDown((int)e.getModifiersEx())) {
                ArrayList<LocatedObject> hits = new ArrayList<LocatedObject>();
                for (LocatedObject obj : this.m_Objects) {
                    boolean contained = obj.hasPolygon() ? obj.getActualPolygon().contains(e.getPosition()) : obj.getActualRectangle().contains(e.getPosition());
                    if (!contained) continue;
                    hits.add(obj);
                }
                if (hits.size() > 0) {
                    this.m_Objects.removeAll(hits);
                    Report report = this.m_PanelImage.getAdditionalProperties().getClone();
                    report.removeValuesStartingWith(this.m_Prefix);
                    Report reportNew = this.m_Objects.toReport(this.m_Prefix);
                    reportNew.mergeWith(report);
                    for (LocatedObject obj : hits) {
                        this.logObjectRemoval(obj);
                    }
                    this.m_PanelImage.setAdditionalProperties(reportNew);
                    this.updateObjects();
                }
            }
        }

        public void clearInteractionLog() {
            this.m_PanelImage.clearInteractionLog();
        }

        public boolean hasInteractionLog() {
            return this.m_PanelImage.hasInteractionLog();
        }

        public List<InteractionEvent> getInteractionLog() {
            return this.m_PanelImage.getInteractionLog();
        }
    }
}

