/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.MapToJson;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.visualization.image.interactionlogging.InteractionEvent;
import adams.gui.visualization.image.interactionlogging.InteractionLoggingFilter;
import adams.gui.visualization.image.interactionlogging.Null;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.annotationsdisplay.AbstractAnnotationsDisplayGenerator;
import adams.gui.visualization.object.annotationsdisplay.DefaultAnnotationsDisplayGenerator;
import adams.gui.visualization.object.annotator.AbstractAnnotator;
import adams.gui.visualization.object.annotator.AutoAdvanceAnnotator;
import adams.gui.visualization.object.annotator.BoundingBoxAnnotator;
import adams.gui.visualization.object.labelselector.AbstractLabelSelectorGenerator;
import adams.gui.visualization.object.labelselector.ButtonSelectorGenerator;
import adams.gui.visualization.object.mouseclick.AbstractMouseClickProcessor;
import adams.gui.visualization.object.mouseclick.NullProcessor;
import adams.gui.visualization.object.overlay.AbstractOverlay;
import adams.gui.visualization.object.overlay.ObjectLocationsOverlayFromReport;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JPanel;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class ImageObjectAnnotator
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = -761517109077084448L;
    public static final String FIELD_INTERACTIONLOG = "interaction-log";
    protected AbstractAnnotationsDisplayGenerator m_AnnotationsDisplay;
    protected AbstractAnnotator m_Annotator;
    protected AbstractLabelSelectorGenerator m_LabelSelector;
    protected AbstractMouseClickProcessor m_MouseClick;
    protected AbstractOverlay m_Overlay;
    protected int m_LeftDividerLocation;
    protected int m_RightDividerLocation;
    protected double m_Zoom;
    protected boolean m_BestFit;
    protected InteractionLoggingFilter m_InteractionLoggingFilter;
    protected boolean m_AllowUsingPreviousReport;
    protected ObjectAnnotationPanel m_PanelObjectAnnotation;
    protected boolean m_Accepted;
    protected transient Date m_StartTimestamp;
    protected Report m_PreviousReport;
    protected String m_PreviousLabel;

    public String globalInfo() {
        return "User interface for annotating objects in images.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("annotations-display", "annotationsDisplay", (Object)new DefaultAnnotationsDisplayGenerator());
        this.m_OptionManager.add("annotator", "annotator", (Object)new BoundingBoxAnnotator());
        this.m_OptionManager.add("label-selector", "labelSelector", (Object)new ButtonSelectorGenerator());
        this.m_OptionManager.add("mouse-click", "mouseClick", (Object)new NullProcessor());
        this.m_OptionManager.add("overlay", "overlay", (Object)new ObjectLocationsOverlayFromReport());
        this.m_OptionManager.add("left-divider-location", "leftDividerLocation", (Object)200, (Number)1, null);
        this.m_OptionManager.add("right-divider-location", "rightDividerLocation", (Object)900, (Number)1, null);
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0, (Number)1.0, (Number)1600.0);
        this.m_OptionManager.add("best-fit", "bestFit", (Object)false);
        this.m_OptionManager.add("interaction-logging-filter", "interactionLoggingFilter", (Object)new Null());
        this.m_OptionManager.add("allow-using-previous-report", "allowUsingPreviousReport", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_PreviousReport = null;
        this.m_PreviousLabel = null;
    }

    protected int getDefaultX() {
        return -2;
    }

    protected int getDefaultY() {
        return -2;
    }

    protected int getDefaultWidth() {
        return 1200;
    }

    protected int getDefaultHeight() {
        return 800;
    }

    public void setAnnotationsDisplay(AbstractAnnotationsDisplayGenerator value) {
        this.m_AnnotationsDisplay = value;
        this.reset();
    }

    public AbstractAnnotationsDisplayGenerator getAnnotationsDisplay() {
        return this.m_AnnotationsDisplay;
    }

    public String annotationsDisplayTipText() {
        return "The generator to use for instantiating the annotations display.";
    }

    public void setAnnotator(AbstractAnnotator value) {
        this.m_Annotator = value;
        this.reset();
    }

    public AbstractAnnotator getAnnotator() {
        return this.m_Annotator;
    }

    public String annotatorTipText() {
        return "The annotator to use.";
    }

    public void setLabelSelector(AbstractLabelSelectorGenerator value) {
        this.m_LabelSelector = value;
        this.reset();
    }

    public AbstractLabelSelectorGenerator getLabelSelector() {
        return this.m_LabelSelector;
    }

    public String labelSelectorTipText() {
        return "The generator for creating the panel with the labels.";
    }

    public void setMouseClick(AbstractMouseClickProcessor value) {
        this.m_MouseClick = value;
        this.reset();
    }

    public AbstractMouseClickProcessor getMouseClick() {
        return this.m_MouseClick;
    }

    public String mouseClickTipText() {
        return "The processor for handling mouse clicks.";
    }

    public void setOverlay(AbstractOverlay value) {
        this.m_Overlay = value;
        this.reset();
    }

    public AbstractOverlay getOverlay() {
        return this.m_Overlay;
    }

    public String overlayTipText() {
        return "The overlay to use for visualizing the annotations.";
    }

    public void setLeftDividerLocation(int value) {
        if (this.getOptionManager().isValid("leftDividerLocation", (Number)value)) {
            this.m_LeftDividerLocation = value;
            this.reset();
        }
    }

    public int getLeftDividerLocation() {
        return this.m_LeftDividerLocation;
    }

    public String leftDividerLocationTipText() {
        return "The position for the left divider in pixels.";
    }

    public void setRightDividerLocation(int value) {
        if (this.getOptionManager().isValid("rightDividerLocation", (Number)value)) {
            this.m_RightDividerLocation = value;
            this.reset();
        }
    }

    public int getRightDividerLocation() {
        return this.m_RightDividerLocation;
    }

    public String rightDividerLocationTipText() {
        return "The position for the right divider in pixels.";
    }

    public void setZoom(double value) {
        if (this.getOptionManager().isValid("zoom", (Number)value)) {
            this.m_Zoom = value;
            this.reset();
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public void setBestFit(boolean value) {
        this.m_BestFit = value;
        this.reset();
    }

    public boolean getBestFit() {
        return this.m_BestFit;
    }

    public String bestFitTipText() {
        return "If enabled, the image gets fitted into the viewport.";
    }

    public void setInteractionLoggingFilter(InteractionLoggingFilter value) {
        this.m_InteractionLoggingFilter = value;
        this.reset();
    }

    public InteractionLoggingFilter getInteractionLoggingFilter() {
        return this.m_InteractionLoggingFilter;
    }

    public String interactionLoggingFilterTipText() {
        return "The interaction logger to use.";
    }

    public void setAllowUsingPreviousReport(boolean value) {
        this.m_AllowUsingPreviousReport = value;
        this.reset();
    }

    public boolean getAllowUsingPreviousReport() {
        return this.m_AllowUsingPreviousReport;
    }

    public String allowUsingPreviousReportTipText() {
        return "If enabled, allows the user to make use of the previous report (ie annotations); useful when annotations do not change much between images.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"annotator", (Object)((Object)this.m_Annotator), (String)", annotator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"overlay", (Object)((Object)this.m_Overlay), (String)", overlay: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"mouseClick", (Object)((Object)this.m_MouseClick), (String)", mouse: ");
        result = this.m_BestFit ? result + QuickInfoHelper.toString((OptionHandler)this, (String)"bestFit", (boolean)this.m_BestFit, (String)"best fit", (String)", ") : result + QuickInfoHelper.toString((OptionHandler)this, (String)"zoom", (Object)this.m_Zoom, (String)", zoom: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"allowUsingPreviousReport", (boolean)this.m_AllowUsingPreviousReport, (String)"can use previous report", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{BufferedImage.class, AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    public void clearPanel() {
        if (this.m_PanelObjectAnnotation != null) {
            this.m_PanelObjectAnnotation.clear();
        }
    }

    protected BasePanel newPanel() {
        this.m_PanelObjectAnnotation = new ObjectAnnotationPanel();
        this.m_PanelObjectAnnotation.setAnnotationsPanel(this.m_AnnotationsDisplay.generate());
        this.m_PanelObjectAnnotation.setLabelSelectorPanel(this.m_LabelSelector.generate(this.m_PanelObjectAnnotation));
        this.m_PanelObjectAnnotation.setAnnotator((AbstractAnnotator)((Object)ObjectCopyHelper.copyObject((Object)((Object)this.m_Annotator))));
        this.m_PanelObjectAnnotation.setOverlay((AbstractOverlay)((Object)ObjectCopyHelper.copyObject((Object)((Object)this.m_Overlay))));
        this.m_PanelObjectAnnotation.setMouseClickProcessor((AbstractMouseClickProcessor)((Object)ObjectCopyHelper.copyObject((Object)((Object)this.m_MouseClick))));
        this.m_PanelObjectAnnotation.setLeftDividerLocation(this.m_LeftDividerLocation);
        this.m_PanelObjectAnnotation.setRightDividerLocation(this.m_RightDividerLocation - this.m_LeftDividerLocation);
        this.m_PanelObjectAnnotation.setZoom(this.m_Zoom / 100.0);
        this.m_PanelObjectAnnotation.setBestFit(this.m_BestFit);
        this.m_PanelObjectAnnotation.setInteractionLoggingFilter((InteractionLoggingFilter)ObjectCopyHelper.copyObject((Object)this.m_InteractionLoggingFilter));
        this.m_PanelObjectAnnotation.setUsePreviousReportVisible(this.m_AllowUsingPreviousReport);
        return this.m_PanelObjectAnnotation;
    }

    protected void postCreateDialog(BaseDialog dialog, BasePanel panel) {
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        dialog.getContentPane().add((Component)panelButtons, "South");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.addActionListener(e -> {
            this.m_Accepted = true;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonCancel = new BaseButton("Cancel");
        buttonCancel.addActionListener(e -> {
            this.m_Accepted = false;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonCancel);
    }

    protected void addInteractionsToReport(Report report, List<InteractionEvent> events) {
        JSONObject interaction;
        if (events == null) {
            return;
        }
        JSONArray array = new JSONArray();
        MapToJson m2j = new MapToJson();
        DateFormat formatter = DateUtils.getTimestampFormatterMsecs();
        Field field = new Field(FIELD_INTERACTIONLOG, DataType.STRING);
        if (report.hasValue((AbstractField)field)) {
            String value = "" + report.getValue((AbstractField)field);
            if (value.isEmpty()) {
                array = new JSONArray();
            } else {
                try {
                    JSONParser parser = new JSONParser(1984);
                    array = (JSONArray)parser.parse(value);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to parse old interactions: " + value, (Throwable)e);
                }
            }
        }
        if (array.size() > 0) {
            interaction = new JSONObject();
            interaction.put((Object)"timestamp", (Object)formatter.format(this.m_StartTimestamp));
            interaction.put((Object)"id", (Object)"---");
            array.add((Object)interaction);
        }
        for (InteractionEvent event : events) {
            interaction = new JSONObject();
            interaction.put((Object)"timestamp", (Object)formatter.format(event.getTimestamp()));
            interaction.put((Object)"id", (Object)event.getID());
            if (event.getData() != null) {
                m2j.setInput((Object)event.getData());
                String msg = m2j.convert();
                if (msg == null) {
                    interaction.put((Object)"data", m2j.getOutput());
                } else {
                    this.getLogger().warning("Failed to convert interaction data to JSON: " + event.getData());
                }
            }
            array.add((Object)interaction);
        }
        report.addField((AbstractField)field);
        report.setValue((AbstractField)field, (Object)array.toString());
    }

    public boolean doInteract() {
        AbstractImageContainer imgcont;
        this.m_Accepted = false;
        this.m_StartTimestamp = new Date();
        this.m_PreviousReport = this.m_AllowUsingPreviousReport ? this.m_PanelObjectAnnotation.getReport() : null;
        if (this.m_InputToken.hasPayload(BufferedImage.class)) {
            BufferedImage img = (BufferedImage)this.m_InputToken.getPayload(BufferedImage.class);
            imgcont = new BufferedImageContainer();
            imgcont.setImage((Object)img);
        } else {
            imgcont = (AbstractImageContainer)this.m_InputToken.getPayload(AbstractImageContainer.class);
        }
        this.registerWindow((Window)this.m_Dialog, this.m_Dialog.getTitle());
        this.m_PanelObjectAnnotation.clear();
        this.m_PanelObjectAnnotation.setImage(imgcont.toBufferedImage());
        this.m_PanelObjectAnnotation.setReport(imgcont.getReport());
        this.m_PanelObjectAnnotation.setPreviousReport(this.m_PreviousReport);
        this.m_PanelObjectAnnotation.annotationsChanged((Object)this);
        this.m_PanelObjectAnnotation.labelChanged((Object)this);
        boolean resetLabel = false;
        if (this.m_Annotator instanceof AutoAdvanceAnnotator) {
            resetLabel = ((AutoAdvanceAnnotator)((Object)this.m_Annotator)).getAutoAdvanceLabels();
        }
        if (resetLabel) {
            if (this.m_PanelObjectAnnotation.getLabelSelectorPanel().getLabels().length > 0) {
                this.m_PanelObjectAnnotation.preselectCurrentLabel(this.m_PanelObjectAnnotation.getLabelSelectorPanel().getLabels()[0]);
            } else {
                this.m_PanelObjectAnnotation.preselectCurrentLabel(null);
            }
        } else {
            this.m_PanelObjectAnnotation.preselectCurrentLabel(this.m_PreviousLabel);
        }
        this.m_Dialog.setVisible(true);
        this.deregisterWindow((Window)this.m_Dialog);
        if (this.m_Accepted) {
            imgcont = new BufferedImageContainer();
            imgcont.setImage((Object)this.m_PanelObjectAnnotation.getImage());
            imgcont.setReport(this.m_PanelObjectAnnotation.getReport().getClone());
            if (!(this.m_InteractionLoggingFilter instanceof Null)) {
                this.addInteractionsToReport(imgcont.getReport(), this.m_PanelObjectAnnotation.getInteractionLog());
            }
            this.m_OutputToken = new Token((Object)imgcont);
        }
        this.m_PreviousLabel = this.m_PanelObjectAnnotation.getCurrentLabel();
        return this.m_Accepted;
    }
}

