/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.imagesegmentationcontainer.AbstractImageSegmentationContainerOperation;
import adams.data.image.imagesegmentationcontainer.PassThrough;
import adams.flow.container.ImageSegmentationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class ImageSegmentationContainerOperation
extends AbstractTransformer {
    private static final long serialVersionUID = 3690378527551302472L;
    protected AbstractImageSegmentationContainerOperation m_Operation;

    public String globalInfo() {
        return "Applies a Image Segmentation container operation to the incoming container(s) and outputs the generated data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new PassThrough());
    }

    public void setOperation(AbstractImageSegmentationContainerOperation value) {
        this.m_Operation = value;
        this.reset();
    }

    public AbstractImageSegmentationContainerOperation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The operation to apply to the containers.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)((Object)this.m_Operation));
    }

    public Class[] accepts() {
        return new Class[]{ImageSegmentationContainer[].class};
    }

    public Class[] generates() {
        return new Class[]{this.m_Operation.generates()};
    }

    protected String doExecute() {
        String result = null;
        try {
            ImageSegmentationContainer[] input = (ImageSegmentationContainer[])this.m_InputToken.getPayload();
            Object output = this.m_Operation.process(input);
            if (output != null) {
                this.m_OutputToken = new Token(output);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to transform container(s): ", e);
        }
        return result;
    }
}

