/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.imagesharpness.AbstractImageSharpness;
import adams.data.imagesharpness.Dummy;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class ImageSharpness
extends AbstractTransformer {
    private static final long serialVersionUID = 7466006970025235243L;
    protected AbstractImageSharpness m_Algorithm;

    public String globalInfo() {
        return "Determines whether images are in focus ('sharp') using the specified algorithm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new Dummy());
    }

    public void setAlgorithm(AbstractImageSharpness value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractImageSharpness getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The algorithm to use to determine whether image is in focus.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{Boolean.class};
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)((Object)this.m_Algorithm));
    }

    protected String doExecute() {
        String result = null;
        AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload();
        boolean sharp = this.m_Algorithm.isSharp(cont);
        this.m_OutputToken = new Token((Object)sharp);
        return result;
    }
}

