/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.annotation.DeprecatedClass;
import adams.core.option.OptionHandler;
import adams.data.RoundingType;
import adams.data.RoundingUtils;
import adams.data.objectfilter.Scale;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.ImageObjectFilter;

@DeprecatedClass(useInstead={ImageObjectFilter.class, Scale.class})
public class ScaleReportObjects
extends AbstractTransformer {
    private static final long serialVersionUID = 3910027464955482939L;
    protected String m_Prefix;
    protected double m_ScaleX;
    protected double m_ScaleY;
    protected boolean m_Round;
    protected RoundingType m_RoundingType;
    protected int m_NumDecimals;

    public String globalInfo() {
        return "Scales the objects in the report using the provided scale factors.\nProcesses the following suffixes of all the report fields that match the provided prefix:\n- .x\n- .y\n- .width\n- .height";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("scale-x", "scaleX", (Object)1.0, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("scale-y", "scaleY", (Object)1.0, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("round", "round", (Object)false);
        this.m_OptionManager.add("rounding-type", "roundingType", (Object)RoundingType.ROUND);
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)0, (Number)0, null);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix of the objects to scale.";
    }

    public void setScaleX(double value) {
        if (this.getOptionManager().isValid("scaleX", (Number)value)) {
            this.m_ScaleX = value;
            this.reset();
        }
    }

    public double getScaleX() {
        return this.m_ScaleX;
    }

    public String scaleXTipText() {
        return "The factor for scaling x/width.";
    }

    public void setScaleY(double value) {
        if (this.getOptionManager().isValid("scaleY", (Number)value)) {
            this.m_ScaleY = value;
            this.reset();
        }
    }

    public double getScaleY() {
        return this.m_ScaleY;
    }

    public String scaleYTipText() {
        return "The factor for scaling y/width.";
    }

    public void setRound(boolean value) {
        this.m_Round = value;
        this.reset();
    }

    public boolean getRound() {
        return this.m_Round;
    }

    public String roundTipText() {
        return "If enabled, the scaled values get round.";
    }

    public void setRoundingType(RoundingType value) {
        this.m_RoundingType = value;
        this.reset();
    }

    public RoundingType getRoundingType() {
        return this.m_RoundingType;
    }

    public String roundingTypeTipText() {
        return "The type of rounding to perform.";
    }

    public void setNumDecimals(int value) {
        if (this.getOptionManager().isValid("numDecimals", (Number)value)) {
            this.m_NumDecimals = value;
            this.reset();
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals after the decimal point to use.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"scaleX", (Object)this.m_ScaleX, (String)"x: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"scaleY", (Object)this.m_ScaleY, (String)", y: ");
        if (this.m_Round) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"roundingType", (Object)this.m_RoundingType, (String)", rounding: ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numDecimals", (Object)this.m_NumDecimals, (String)", decimals: ");
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Report.class, ReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{Report.class, ReportHandler.class};
    }

    protected double round(double value) {
        if (!this.m_Round) {
            return value;
        }
        return RoundingUtils.apply((RoundingType)this.m_RoundingType, (double)value, (int)this.m_NumDecimals);
    }

    protected String doExecute() {
        String result = null;
        Report report = null;
        if (this.m_InputToken.getPayload() instanceof Report) {
            report = (Report)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof ReportHandler) {
            report = ((ReportHandler)this.m_InputToken.getPayload()).getReport();
        } else {
            result = "Unhandled input type: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (result == null) {
            MessageCollection errors = new MessageCollection();
            for (AbstractField field : report.getFields()) {
                try {
                    double value;
                    if (!field.getName().startsWith(this.m_Prefix)) continue;
                    if (field.getName().endsWith(".x") || field.getName().endsWith(".width")) {
                        value = report.getDoubleValue(field);
                        value = this.round(value * this.m_ScaleX);
                        report.setNumericValue(field.getName(), value);
                        continue;
                    }
                    if (!field.getName().endsWith(".y") && !field.getName().endsWith(".height")) continue;
                    value = report.getDoubleValue(field);
                    value = this.round(value * this.m_ScaleY);
                    report.setNumericValue(field.getName(), value);
                }
                catch (Exception e) {
                    errors.add("Failed to process field '" + field + "'!", (Throwable)e);
                }
            }
            if (!errors.isEmpty()) {
                result = errors.toString();
            }
            this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        }
        return result;
    }
}

