/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.core.Utils;
import adams.data.image.BufferedImageContainer;
import adams.data.report.Report;
import adams.flow.control.StorageName;
import adams.flow.transformer.draw.AbstractDrawObjectsFromReport;
import adams.flow.transformer.draw.AbstractDrawOperation;
import adams.flow.transformer.draw.ObjectLocationsFromReport;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class AnnotationsAndPredictions
extends AbstractDrawOperation {
    private static final long serialVersionUID = 6356419097401574024L;
    protected StorageName m_StorageAnnotations;
    protected AbstractDrawOperation m_DrawAnnotations;
    protected StorageName m_StoragePredictions;
    protected AbstractDrawOperation m_DrawPredictions;

    public String globalInfo() {
        return "Overlays the image with annotations and predictions from storage with their respective draw operations.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-annotations", "storageAnnotations", (Object)new StorageName("annotations"));
        this.m_OptionManager.add("draw-annotations", "drawAnnotations", (Object)this.getDefaultDrawAnnotations());
        this.m_OptionManager.add("storage-predictions", "storagePredictions", (Object)new StorageName("predictions"));
        this.m_OptionManager.add("draw-predictions", "drawPredictions", (Object)this.getDefaultDrawPredictions());
    }

    public void setStorageAnnotations(StorageName value) {
        this.m_StorageAnnotations = value;
        this.reset();
    }

    public StorageName getStorageAnnotations() {
        return this.m_StorageAnnotations;
    }

    public String storageAnnotationsTipText() {
        return "The storage item containing the annotations report.";
    }

    protected AbstractDrawOperation getDefaultDrawAnnotations() {
        ObjectLocationsFromReport result = new ObjectLocationsFromReport();
        result.setColor(Color.BLUE);
        result.setLabelFormat("");
        return result;
    }

    public void setDrawAnnotations(AbstractDrawOperation value) {
        this.m_DrawAnnotations = value;
        this.reset();
    }

    public AbstractDrawOperation getDrawAnnotations() {
        return this.m_DrawAnnotations;
    }

    public String drawAnnotationsTipText() {
        return "The draw operation to apply to the annotations.";
    }

    public void setStoragePredictions(StorageName value) {
        this.m_StoragePredictions = value;
        this.reset();
    }

    public StorageName getStoragePredictions() {
        return this.m_StoragePredictions;
    }

    public String storagePredictionsTipText() {
        return "The storage item containing the predictions report.";
    }

    protected AbstractDrawOperation getDefaultDrawPredictions() {
        ObjectLocationsFromReport result = new ObjectLocationsFromReport();
        result.setColor(Color.RED);
        result.setLabelFormat("{score}");
        return result;
    }

    public void setDrawPredictions(AbstractDrawOperation value) {
        this.m_DrawPredictions = value;
        this.reset();
    }

    public AbstractDrawOperation getDrawPredictions() {
        return this.m_DrawPredictions;
    }

    public String drawPredictionsTipText() {
        return "The draw operation to apply to the predictions.";
    }

    @Override
    protected String check(BufferedImageContainer image) {
        String result = super.check(image);
        if (result == null) {
            if (this.m_Owner.getStorageHandler() == null) {
                result = "Actor does not have a storage handler!";
            } else if (this.m_Owner.getStorageHandler().getStorage() == null) {
                result = "Actor does not have access to storage!";
            } else if (!this.m_Owner.getStorageHandler().getStorage().has(this.m_StorageAnnotations)) {
                result = "Annotations not found in storage: " + this.m_StorageAnnotations;
            } else if (!this.m_Owner.getStorageHandler().getStorage().has(this.m_StoragePredictions)) {
                result = "Predictions not found in storage: " + this.m_StoragePredictions;
            } else if (!(this.m_Owner.getStorageHandler().getStorage().get(this.m_StorageAnnotations) instanceof Report)) {
                result = "Annotations in storage ('" + this.m_StorageAnnotations + "') are not in Report format: " + Utils.classToString((Object)this.m_Owner.getStorageHandler().getStorage().get(this.m_StorageAnnotations));
            } else if (!(this.m_Owner.getStorageHandler().getStorage().get(this.m_StoragePredictions) instanceof Report)) {
                result = "Predictions in storage ('" + this.m_StoragePredictions + "') are not in Report format: " + Utils.classToString((Object)this.m_Owner.getStorageHandler().getStorage().get(this.m_StoragePredictions));
            }
        }
        return result;
    }

    @Override
    protected String doDraw(BufferedImageContainer image) {
        Report reportBak = image.getReport().getClone();
        BufferedImage img = (BufferedImage)image.getContent();
        Report report = reportBak.getClone();
        if (this.m_DrawAnnotations instanceof AbstractDrawObjectsFromReport) {
            report.removeValuesStartingWith(((AbstractDrawObjectsFromReport)this.m_DrawAnnotations).getPrefix());
        } else {
            report.removeValuesStartingWith("Object.");
        }
        report.mergeWith((Report)this.m_Owner.getStorageHandler().getStorage().get(this.m_StorageAnnotations));
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)img);
        cont.setReport(report);
        this.m_DrawAnnotations.setOwner(this.getOwner());
        String result = this.m_DrawAnnotations.draw(cont);
        if (result == null) {
            img = (BufferedImage)cont.getContent();
        }
        if (result == null) {
            report = reportBak.getClone();
            if (this.m_DrawPredictions instanceof AbstractDrawObjectsFromReport) {
                report.removeValuesStartingWith(((AbstractDrawObjectsFromReport)this.m_DrawPredictions).getPrefix());
            } else {
                report.removeValuesStartingWith("Object.");
            }
            report.mergeWith((Report)this.m_Owner.getStorageHandler().getStorage().get(this.m_StoragePredictions));
            cont = new BufferedImageContainer();
            cont.setImage((Object)img);
            cont.setReport(report);
            this.m_DrawPredictions.setOwner(this.getOwner());
            result = this.m_DrawPredictions.draw(cont);
            if (result == null) {
                img = (BufferedImage)cont.getContent();
            }
        }
        if (result == null) {
            image.setImage((Object)img);
        }
        return result;
    }
}

