/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.exiftagoperation;

import adams.core.License;
import adams.core.MessageCollection;
import adams.core.annotation.MixedCopyright;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.flow.transformer.exiftagoperation.AbstractApacheCommonsExifTagOperation;
import adams.flow.transformer.exiftagoperation.ExifTagRemoveOperation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;

@MixedCopyright(author="yurko - https://stackoverflow.com/users/418516/yurko", url="https://stackoverflow.com/a/36873897/4698227", license=License.CC_BY_SA_3, note="general usage of Apache Commons Imaging for EXIF operations")
public class ApacheCommonsExifTagRemove
extends AbstractApacheCommonsExifTagOperation<Object, Object>
implements ExifTagRemoveOperation<Object, Object> {
    private static final long serialVersionUID = -4257460091938302125L;

    public String globalInfo() {
        return "Removes the specified tag from the file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, File.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doProcess(Object input, MessageCollection errors) {
        Object result = null;
        File inputFile = input instanceof String ? new PlaceholderFile((String)input).getAbsoluteFile() : ((File)input).getAbsoluteFile();
        File tmpFile = TempUtils.createTempFile((String)(this.getClass().getSimpleName().toLowerCase() + "-"), (String)".jpg");
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            JpegImageMetadata meta = (JpegImageMetadata)Imaging.getMetadata((File)inputFile);
            if (meta != null) {
                TiffImageMetadata exif = meta.getExif();
                if (exif != null) {
                    TiffOutputSet outputSet = exif.getOutputSet();
                    if (outputSet != null) {
                        TiffOutputDirectory exifDir = outputSet.getOrCreateExifDirectory();
                        if (exifDir != null) {
                            exifDir.removeField(this.m_Tag.getTagInfo());
                            fos = new FileOutputStream(tmpFile);
                            bos = new BufferedOutputStream(fos);
                            new ExifRewriter().updateExifMetadataLossless(inputFile, (OutputStream)bos, outputSet);
                            if (!FileUtils.copy((File)tmpFile, (File)inputFile)) {
                                errors.add("Failed to replace " + inputFile + " with updated EXIF from " + tmpFile);
                            }
                            if (!FileUtils.delete((File)tmpFile)) {
                                errors.add("Failed to delete tmp file: " + tmpFile);
                            }
                        } else {
                            errors.add("Failed to obtain EXIF directory: " + input);
                        }
                    } else {
                        errors.add("Failed to obtain output set: " + input);
                    }
                } else {
                    errors.add("No EXIF meta-data available: " + input);
                }
            } else {
                errors.add("No meta-data available: " + input);
            }
        }
        catch (Exception e) {
            errors.add("Failed to read EXIF tag " + (Object)((Object)this.m_Tag) + " from: " + input, (Throwable)e);
        }
        finally {
            FileUtils.closeQuietly(bos);
            FileUtils.closeQuietly(fos);
        }
        if (errors.isEmpty()) {
            result = input;
        }
        return result;
    }
}

