/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.negativeregions;

import adams.data.image.AbstractImageContainer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.negativeregions.AbstractMetaNegativeRegionsGenerator;
import java.util.Collections;
import java.util.Comparator;

public class LargestRegions
extends AbstractMetaNegativeRegionsGenerator {
    private static final long serialVersionUID = -904202231629949668L;
    protected int m_MaxRegions;

    public String globalInfo() {
        return "Returns only the top X largest regions from the base generator.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-regions", "maxRegions", (Object)-1, (Number)-1, null);
    }

    public void setMaxRegions(int value) {
        if (this.getOptionManager().isValid("maxRegions", (Number)value)) {
            this.m_MaxRegions = value;
            this.reset();
        }
    }

    public int getMaxRegions() {
        return this.m_MaxRegions;
    }

    public String maxRegionsTipText() {
        return "The maximum number of regions to return; <1 returns all.";
    }

    @Override
    protected LocatedObjects doGenerateRegions(AbstractImageContainer cont) {
        LocatedObjects result = this.getActualAlgorithm().generateRegions(cont);
        if (this.m_MaxRegions < 1 || result.size() <= this.m_MaxRegions) {
            return result;
        }
        Collections.sort(result, new Comparator<LocatedObject>(){

            @Override
            public int compare(LocatedObject o1, LocatedObject o2) {
                return -Double.compare(o1.getWidth() * o1.getHeight(), o2.getWidth() * o2.getHeight());
            }
        });
        while (result.size() > this.m_MaxRegions && !this.isStopped()) {
            result.remove(this.m_MaxRegions);
        }
        if (this.isStopped()) {
            result.clear();
        }
        return result;
    }
}

