/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.negativeregions;

import adams.data.image.AbstractImageContainer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.negativeregions.AbstractMetaNegativeRegionsGenerator;

public class MaxDimensions
extends AbstractMetaNegativeRegionsGenerator {
    private static final long serialVersionUID = -904202231629949668L;
    protected int m_MaxWidth;
    protected int m_MaxHeight;

    public String globalInfo() {
        return "Enforces the specified maximum dimensions.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-width", "maxWidth", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-height", "maxHeight", (Object)-1, (Number)-1, null);
    }

    public void setMaxWidth(int value) {
        if (this.getOptionManager().isValid("maxWidth", (Number)value)) {
            this.m_MaxWidth = value;
            this.reset();
        }
    }

    public int getMaxWidth() {
        return this.m_MaxWidth;
    }

    public String maxWidthTipText() {
        return "The maximum width that a negative region can have, ignored if <1.";
    }

    public void setMaxHeight(int value) {
        if (this.getOptionManager().isValid("maxHeight", (Number)value)) {
            this.m_MaxHeight = value;
            this.reset();
        }
    }

    public int getMaxHeight() {
        return this.m_MaxHeight;
    }

    public String maxHeightTipText() {
        return "The maximum height that a negative region can have, ignored if <1.";
    }

    @Override
    protected LocatedObjects doGenerateRegions(AbstractImageContainer cont) {
        LocatedObjects result = this.getActualAlgorithm().generateRegions(cont);
        if (result != null && (this.m_MaxHeight > 0 || this.m_MaxWidth > 0)) {
            int i = 0;
            while (i < result.size() && !this.isStopped()) {
                if (this.m_MaxWidth > 0 && ((LocatedObject)result.get(i)).getWidth() > this.m_MaxWidth) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Removed, width too large: " + result.get(i) + " > " + this.m_MaxWidth);
                    }
                    result.remove(i);
                    continue;
                }
                if (this.m_MaxHeight > 0 && ((LocatedObject)result.get(i)).getHeight() > this.m_MaxHeight) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Removed, height too large: " + result.get(i) + " > " + this.m_MaxHeight);
                    }
                    result.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (this.isStopped()) {
            result.clear();
        }
        return result;
    }
}

