/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.negativeregions;

import adams.core.Randomizable;
import adams.data.image.AbstractImageContainer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.objectoverlap.AreaRatio;
import adams.data.objectoverlap.ObjectOverlap;
import adams.data.overlappingobjectremoval.AbstractOverlappingObjectRemoval;
import adams.data.overlappingobjectremoval.OverlappingObjectRemoval;
import adams.data.overlappingobjectremoval.PassThrough;
import adams.data.overlappingobjectremoval.RemoveAll;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.negativeregions.AbstractNegativeRegionsGenerator;
import java.util.Random;
import java.util.logging.Level;

public class RandomRegions
extends AbstractNegativeRegionsGenerator
implements Randomizable {
    private static final long serialVersionUID = -904202231629949668L;
    protected ObjectFinder m_Finder;
    protected long m_Seed;
    protected int m_MinWidth;
    protected int m_MaxWidth;
    protected int m_MinHeight;
    protected int m_MaxHeight;
    protected int m_NumRegions;
    protected ObjectOverlap m_OverlapDetection;
    protected OverlappingObjectRemoval m_OverlapRemoval;
    protected transient Random m_Random;

    public String globalInfo() {
        return "Generates specified number of random regions and then prunes ones that overlap with other regions or annotations.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("min-width", "minWidth", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-width", "maxWidth", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("min-height", "minHeight", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-height", "maxHeight", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("num-regions", "numRegions", (Object)100, (Number)1, null);
        this.m_OptionManager.add("overlap-detection", "overlapDetection", (Object)new AreaRatio());
        this.m_OptionManager.add("overlap-removal", "overlapRemoval", (Object)new PassThrough());
    }

    protected void reset() {
        super.reset();
        this.m_Random = null;
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use for locating objects in the report.";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed to use for the random number generator.";
    }

    public void setMinWidth(int value) {
        if (this.getOptionManager().isValid("minWidth", (Number)value)) {
            this.m_MinWidth = value;
            this.reset();
        }
    }

    public int getMinWidth() {
        return this.m_MinWidth;
    }

    public String minWidthTipText() {
        return "The minimum width that a negative region must have, ignored if <1.";
    }

    public void setMaxWidth(int value) {
        if (this.getOptionManager().isValid("maxWidth", (Number)value)) {
            this.m_MaxWidth = value;
            this.reset();
        }
    }

    public int getMaxWidth() {
        return this.m_MaxWidth;
    }

    public String maxWidthTipText() {
        return "The maximum width that a negative region can have, ignored if <1.";
    }

    public void setMinHeight(int value) {
        if (this.getOptionManager().isValid("minHeight", (Number)value)) {
            this.m_MinHeight = value;
            this.reset();
        }
    }

    public int getMinHeight() {
        return this.m_MinHeight;
    }

    public String minHeightTipText() {
        return "The minimum height that a negative region must have, ignored if <1.";
    }

    public void setMaxHeight(int value) {
        if (this.getOptionManager().isValid("maxHeight", (Number)value)) {
            this.m_MaxHeight = value;
            this.reset();
        }
    }

    public int getMaxHeight() {
        return this.m_MaxHeight;
    }

    public String maxHeightTipText() {
        return "The maximum height that a negative region can have, ignored if <1.";
    }

    public void setNumRegions(int value) {
        if (this.getOptionManager().isValid("numRegions", (Number)value)) {
            this.m_NumRegions = value;
            this.reset();
        }
    }

    public int getNumRegions() {
        return this.m_NumRegions;
    }

    public String numRegionsTipText() {
        return "The number of regions to generate, before removing ones that overlap or overlap with annotations.";
    }

    public void setOverlapDetection(ObjectOverlap value) {
        this.m_OverlapDetection = value;
        this.reset();
    }

    public ObjectOverlap getOverlapDetection() {
        return this.m_OverlapDetection;
    }

    public String overlapDetectionTipText() {
        return "The algorithm to use for determining the overlapping objects.";
    }

    public void setOverlapRemoval(OverlappingObjectRemoval value) {
        this.m_OverlapRemoval = value;
        this.reset();
    }

    public OverlappingObjectRemoval getOverlapRemoval() {
        return this.m_OverlapRemoval;
    }

    public String overlapRemovalTipText() {
        return "The algorithm to use for removing the overlapping objects.";
    }

    @Override
    protected LocatedObjects doGenerateRegions(AbstractImageContainer cont) {
        LocatedObjects result = new LocatedObjects();
        LocatedObjects candidates = new LocatedObjects();
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
        int width = cont.getWidth();
        int height = cont.getHeight();
        int minWidth = this.m_MinWidth == -1 ? 1 : this.m_MinWidth;
        int maxWidth = this.m_MaxWidth == -1 ? width : this.m_MaxWidth;
        int minHeight = this.m_MinHeight == -1 ? 1 : this.m_MinHeight;
        int maxHeight = this.m_MaxHeight == -1 ? height : this.m_MaxHeight;
        int rangeWidth = maxWidth - minWidth + 1;
        int rangeHeight = maxHeight - minHeight + 1;
        for (int i = 0; i < this.m_NumRegions; ++i) {
            int x = this.m_Random.nextInt(width - minWidth);
            int y = this.m_Random.nextInt(height - minHeight);
            int w = this.m_Random.nextInt(rangeWidth) + minWidth;
            int h = this.m_Random.nextInt(rangeHeight) + minHeight;
            candidates.add(new LocatedObject(x, y, w, h));
        }
        Report candReport = candidates.toReport(this.m_Finder.getPrefix());
        LocatedObjects annotations = this.m_Finder.findObjects(cont.getReport());
        Report annReport = annotations.toReport(this.m_Finder.getPrefix());
        try {
            candReport = AbstractOverlappingObjectRemoval.remove(candReport, candReport, new AllFinder(), this.m_OverlapDetection, this.m_OverlapRemoval);
            candReport = AbstractOverlappingObjectRemoval.remove(candReport, annReport, new AllFinder(), this.m_OverlapDetection, new RemoveAll());
            result = LocatedObjects.fromReport(candReport, this.m_Finder.getPrefix());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to remove overlaps!", (Throwable)e);
            result.clear();
        }
        if (this.isStopped()) {
            result.clear();
        }
        return result;
    }
}

