/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.io.PlaceholderFile;
import adams.data.tesseract.TesseractHelper;
import adams.flow.core.TesseractLanguage;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.BaseComboBox;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

public class TesseractSettingsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -5325521437739323748L;
    protected ParameterPanel m_PanelParameters;
    protected FileChooserPanel m_PanelExecutable;
    protected BaseComboBox m_ComboBoxLanguages;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "North");
        this.m_PanelExecutable = new FileChooserPanel();
        this.m_PanelParameters.addParameter("_Executable", (Component)this.m_PanelExecutable);
        this.m_ComboBoxLanguages = new BaseComboBox((Object[])TesseractLanguage.values());
        this.m_PanelParameters.addParameter("_Language", (Component)this.m_ComboBoxLanguages);
        this.load();
    }

    protected void load() {
        TesseractHelper helper = TesseractHelper.getSingleton();
        helper.reload();
        this.m_PanelExecutable.setCurrent((File)new PlaceholderFile(helper.getExecutable()));
        this.m_ComboBoxLanguages.setSelectedItem((Object)helper.getLanguage());
    }

    public String getTitle() {
        return "Tesseract";
    }

    public boolean requiresWrapper() {
        return true;
    }

    public String activate() {
        TesseractHelper helper = TesseractHelper.getSingleton();
        helper.setExecutable(((File)this.m_PanelExecutable.getCurrent()).getAbsolutePath());
        if (this.m_ComboBoxLanguages.getSelectedIndex() > -1) {
            helper.setLanguage((TesseractLanguage)((Object)this.m_ComboBoxLanguages.getSelectedItem()));
        } else {
            helper.setLanguage(TesseractLanguage.ENGLISH);
        }
        boolean result = helper.save();
        if (result) {
            return null;
        }
        return "Failed to save tesseract setup!";
    }
}

