/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.io.output.DefaultSimpleReportWriter;
import adams.data.report.Report;
import adams.flow.transformer.ImageAnnotator;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.ImagePanelLeftClickListener;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.NullOverlay;
import adams.gui.visualization.image.interactionlogging.InteractionLoggingFilter;
import adams.gui.visualization.image.interactionlogging.Null;
import adams.gui.visualization.image.leftclick.AddMetaData;
import adams.gui.visualization.image.selection.NullProcessor;
import adams.gui.visualization.image.selection.SelectionProcessor;
import adams.gui.visualization.image.selectionshape.RectanglePainter;
import adams.gui.visualization.image.selectionshape.SelectionShapePainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AnnotateImage
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    protected AbstractReportReader m_Reader;
    protected String m_AlternativeFileSuffix;
    protected AbstractReportWriter m_Writer;
    protected String m_Prefix;
    protected String m_Suffix;
    protected BaseString[] m_Labels;
    protected SelectionProcessor m_SelectionProcessor;
    protected SelectionShapePainter m_SelectionShapePainter;
    protected ImageOverlay m_Overlay;
    protected double m_Zoom;

    public String globalInfo() {
        return "Allows annotating images and/or modifying their meta-data.\nHold down CTRL key when clicking on an annotation to add meta-data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new DefaultSimpleReportReader());
        this.m_OptionManager.add("alternative-file-suffix", "alternativeFileSuffix", (Object)"-rois");
        this.m_OptionManager.add("writer", "writer", (Object)new DefaultSimpleReportWriter());
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("suffix", "suffix", (Object)".type");
        this.m_OptionManager.add("label", "labels", (Object)new BaseString[0]);
        this.m_OptionManager.add("selection-processor", "selectionProcessor", (Object)new NullProcessor());
        this.m_OptionManager.add("selection-shape-painter", "selectionShapePainter", (Object)new RectanglePainter());
        this.m_OptionManager.add("overlay", "overlay", (Object)new NullOverlay());
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0, (Number)-1.0, (Number)1600.0);
    }

    public void setReader(AbstractReportReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractReportReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader setup to use for reading the object locations from the spreadsheet.";
    }

    public void setAlternativeFileSuffix(String value) {
        this.m_AlternativeFileSuffix = value;
        this.reset();
    }

    public String getAlternativeFileSuffix() {
        return this.m_AlternativeFileSuffix;
    }

    public String alternativeFileSuffixTipText() {
        return "The alternative file suffix to use for locating the associated spreadsheet (eg '-rois').";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix to use for the located objects.";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The report field suffix to use for the labels.";
    }

    public void setLabels(BaseString[] value) {
        this.m_Labels = value;
        this.reset();
    }

    public BaseString[] getLabels() {
        return this.m_Labels;
    }

    public String labelsTipText() {
        return "The labels to use.";
    }

    public void setSelectionProcessor(SelectionProcessor value) {
        this.m_SelectionProcessor = value;
        this.reset();
    }

    public SelectionProcessor getSelectionProcessor() {
        return this.m_SelectionProcessor;
    }

    public String selectionProcessorTipText() {
        return "The selection processor to use.";
    }

    public void setSelectionShapePainter(SelectionShapePainter value) {
        this.m_SelectionShapePainter = value;
        this.reset();
    }

    public SelectionShapePainter getSelectionShapePainter() {
        return this.m_SelectionShapePainter;
    }

    public String selectionShapePainterTipText() {
        return "The painter to use for the selection shape.";
    }

    public void setOverlay(ImageOverlay value) {
        this.m_Overlay = value;
        this.reset();
    }

    public ImageOverlay getOverlay() {
        return this.m_Overlay;
    }

    public String overlayTipText() {
        return "The overlay to use for highlighting the objects.";
    }

    public void setZoom(double value) {
        if (value == -1.0 || value > 0.0 && value <= 1600.0) {
            this.m_Zoom = value;
            this.reset();
        } else {
            this.getLogger().warning("Zoom must -1 to fit window or 0 < x < 1600, provided: " + value);
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public void setWriter(AbstractReportWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractReportWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for writing the modified report back to disk.";
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected File determineReportFile(File file, boolean mustExist, boolean reader) {
        String ext = reader ? this.m_Reader.getDefaultFormatExtension() : this.m_Writer.getDefaultFormatExtension();
        File reportFile1 = FileUtils.replaceExtension((File)file, (String)("." + ext));
        File reportFile2 = FileUtils.replaceExtension((File)file, (String)(this.m_AlternativeFileSuffix + "." + ext));
        if (reportFile2.exists() && reportFile2.isFile()) {
            reportFile1 = reportFile2;
        }
        if (mustExist && reportFile1.exists() && reportFile1.isFile()) {
            return reportFile1;
        }
        if (!mustExist) {
            return reportFile1;
        }
        return null;
    }

    protected Report loadReport(File file) {
        Report result = null;
        File reportFile = this.determineReportFile(file, true, true);
        if (reportFile != null) {
            this.m_Reader.setInput(new PlaceholderFile(reportFile));
            List reports = this.m_Reader.read();
            if (reports.size() > 0) {
                result = (Report)reports.get(0);
            }
        }
        return result;
    }

    protected BufferedImageContainer loadContainer(File file) {
        Report report;
        JAIImageReader reader = new JAIImageReader();
        BufferedImageContainer result = (BufferedImageContainer)reader.read(new PlaceholderFile(file));
        if (result != null && (report = this.loadReport(file)) != null) {
            result.setReport(report);
        }
        return result;
    }

    protected void saveReport(ImageAnnotator.AnnotatorPanel panel, File file) {
        File reportFile = this.determineReportFile(file, false, false);
        if (reportFile != null) {
            this.m_Writer.setOutput(new PlaceholderFile(reportFile));
            if (!this.m_Writer.write(panel.getCurrentReport())) {
                this.getLogger().severe("Failed to write report to: " + reportFile);
            }
        } else {
            this.getLogger().severe("Failed to determine report file, cannot save to disk!");
        }
    }

    protected PreviewPanel createPreview(File file) {
        CombinedPanel combined = new CombinedPanel();
        BufferedImageContainer cont = this.loadContainer(file);
        if (cont != null) {
            combined.setCurrentImage((AbstractImageContainer)cont, this.m_Zoom);
        }
        return new PreviewPanel((JComponent)((Object)combined), (JComponent)((Object)combined.getAnnotatorPanel()));
    }

    public PreviewPanel reusePreview(File file, PreviewPanel previewPanel) {
        CombinedPanel panel = (CombinedPanel)((Object)previewPanel.getComponent());
        if (panel != null) {
            BufferedImageContainer cont = this.loadContainer(file);
            if (cont != null) {
                panel.setCurrentFile(file);
                panel.setCurrentImage((AbstractImageContainer)cont);
            }
        } else {
            previewPanel = this.createPreview(file);
        }
        return previewPanel;
    }

    public class CombinedPanel
    extends BasePanel {
        private static final long serialVersionUID = -5987843428926585139L;
        protected ImageAnnotator.AnnotatorPanel m_PanelAnnotator;
        protected JPanel m_PanelButtons;
        protected JButton m_ButtonSave;
        protected File m_CurrentFile;

        protected void initialize() {
            super.initialize();
            this.m_CurrentFile = null;
        }

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            AddMetaData addMetaData = new AddMetaData();
            addMetaData.setCtrlDown(true);
            this.m_PanelAnnotator = new ImageAnnotator.AnnotatorPanel(AnnotateImage.this.m_Prefix, AnnotateImage.this.m_Suffix, AnnotateImage.this.m_Labels, AnnotateImage.this.m_SelectionProcessor, AnnotateImage.this.m_SelectionShapePainter, AnnotateImage.this.m_Overlay, AnnotateImage.this.m_Zoom, (InteractionLoggingFilter)new Null());
            this.m_PanelAnnotator.getImagePanel().addLeftClickListener((ImagePanelLeftClickListener)addMetaData);
            this.add((Component)((Object)this.m_PanelAnnotator), "Center");
            this.m_PanelButtons = new JPanel(new FlowLayout(2));
            this.add(this.m_PanelButtons, "South");
            this.m_ButtonSave = new BaseButton((Icon)GUIHelper.getIcon((String)"save.gif"));
            this.m_ButtonSave.addActionListener(e -> AnnotateImage.this.saveReport(this.m_PanelAnnotator, this.m_CurrentFile));
            this.m_PanelButtons.add(this.m_ButtonSave);
        }

        public void setCurrentFile(File value) {
            this.m_CurrentFile = value;
        }

        public File getCurrentFile() {
            return this.m_CurrentFile;
        }

        public void setCurrentImage(AbstractImageContainer value) {
            this.m_PanelAnnotator.setCurrentImage(value);
        }

        public void setCurrentImage(AbstractImageContainer value, double zoom) {
            this.m_PanelAnnotator.setCurrentImage(value, zoom);
        }

        public ImageAnnotator.AnnotatorPanel getAnnotatorPanel() {
            return this.m_PanelAnnotator;
        }
    }
}

