/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.BlueChannelColorizer;
import adams.data.io.input.ApacheCommonsImageReader;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.image.ImagePanel;
import java.io.File;
import javax.swing.JComponent;

public class BlueChannelImageHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    protected ColorProvider m_ColorProvider;

    public String globalInfo() {
        return "Interprets the values in the blue channel as color indices, corresponding to colors generated by the color provider.\nSupported image types: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)this.getDefaultColorProvider());
    }

    protected ColorProvider getDefaultColorProvider() {
        return new DefaultColorProvider();
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for the blue channel indices.";
    }

    public String[] getExtensions() {
        return new ApacheCommonsImageReader().getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        ApacheCommonsImageReader reader = new ApacheCommonsImageReader();
        BufferedImageContainer cont = (BufferedImageContainer)reader.read(new PlaceholderFile(file));
        if (cont == null) {
            return new NoPreviewAvailablePanel();
        }
        BlueChannelColorizer colorizer = new BlueChannelColorizer();
        colorizer.setLoggingLevel(this.m_LoggingLevel);
        colorizer.setColorProvider((ColorProvider)this.m_ColorProvider.shallowCopy());
        cont = ((BufferedImageContainer[])colorizer.transform((AbstractImageContainer)cont))[0];
        colorizer.cleanUp();
        ImagePanel panel = new ImagePanel();
        panel.setCurrentImage((AbstractImageContainer)cont);
        return new PreviewPanel((JComponent)panel, (JComponent)panel.getPaintPanel());
    }
}

