/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.io.filechanged.FileChangeMonitor;
import adams.core.io.filechanged.LastModified;
import adams.core.io.filechanged.MultiMonitor;
import adams.core.io.filechanged.Size;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.CocoAnnotationsReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BasePanel;
import adams.gui.core.Fonts;
import adams.gui.event.ImagePanelLeftClickListener;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import adams.gui.visualization.image.leftclick.ViewObjects;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CocoAnnotationsHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    protected Color m_Color;
    protected boolean m_UseColorsPerType;
    protected ColorProvider m_TypeColorProvider;
    protected BaseRegExp m_TypeRegExp;
    protected String m_LabelFormat;
    protected Font m_LabelFont;
    protected ObjectFinder m_Finder;
    protected boolean m_UseAlternativeLocation;
    protected PlaceholderDirectory m_AlternativeLocation;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the objects stored in the COCO JSON files: " + Utils.arrayToString((Object)this.getExtensions()) + "\nLoads all JSON files in either the directory of the image or the alternative location.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("use-colors-per-type", "useColorsPerType", (Object)true);
        this.m_OptionManager.add("type-color-provider", "typeColorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("label-format", "labelFormat", (Object)"#. $");
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("use-alternative-location", "useAlternativeLocation", (Object)false);
        this.m_OptionManager.add("alternative-location", "alternativeLocation", (Object)new PlaceholderDirectory());
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    public void setUseColorsPerType(boolean value) {
        this.m_UseColorsPerType = value;
        this.reset();
    }

    public boolean getUseColorsPerType() {
        return this.m_UseColorsPerType;
    }

    public String useColorsPerTypeTipText() {
        return "If enabled, individual colors per type are used.";
    }

    public void setTypeColorProvider(ColorProvider value) {
        this.m_TypeColorProvider = value;
        this.reset();
    }

    public ColorProvider getTypeColorProvider() {
        return this.m_TypeColorProvider;
    }

    public String typeColorProviderTipText() {
        return "The color provider to use for the various types.";
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_TypeRegExp = value;
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_TypeRegExp;
    }

    public String typeRegExpTipText() {
        return "The regular expression that the types must match in order to get drawn (eg only plotting a subset).";
    }

    public void setLabelFormat(String value) {
        this.m_LabelFormat = value;
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_LabelFormat;
    }

    public String labelFormatTipText() {
        return "The label format string to use for the rectangles; '#' for index, '@' for type and '$' for short type (type suffix must be defined for '@' and '$'); for instance: '# @'.";
    }

    public void setLabelFont(Font value) {
        this.m_LabelFont = value;
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    public String labelFontTipText() {
        return "The font to use for the labels.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public void setUseAlternativeLocation(boolean value) {
        this.m_UseAlternativeLocation = value;
        this.reset();
    }

    public boolean getUseAlternativeLocation() {
        return this.m_UseAlternativeLocation;
    }

    public String useAlternativeLocationTipText() {
        return "If enabled, the alternative location is used to locate the associated report rather than the directory with the image.";
    }

    public void setAlternativeLocation(PlaceholderDirectory value) {
        this.m_AlternativeLocation = value;
        this.reset();
    }

    public PlaceholderDirectory getAlternativeLocation() {
        return this.m_AlternativeLocation;
    }

    public String alternativeLocationTipText() {
        return "The alternative location to use look for associated reports.";
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected File determineBaseFile(CombinedPanel panel, File file) {
        File result = panel.getUseAlternativeLocation() ? new PlaceholderFile(panel.getAlternativeLocation().getAbsolutePath() + File.separator + file.getName()) : file;
        return result;
    }

    protected File[] locateJsonFiles(CombinedPanel panel, File file) {
        File baseFile = this.determineBaseFile(panel, file);
        File baseDir = baseFile.getParentFile();
        return baseDir.listFiles(pathname -> pathname.isFile() && pathname.getName().toLowerCase().endsWith(".json"));
    }

    protected void refreshReportsIfNecessary(CombinedPanel panel, File file) {
        boolean changed = false;
        boolean init = panel.getFileMonitors() == null;
        File[] files = this.locateJsonFiles(panel, file);
        if (panel.getFileMonitors() != null) {
            for (File f : files) {
                if (panel.getFileMonitors().containsKey(f.getAbsolutePath())) continue;
                init = true;
                if (!this.isLoggingEnabled()) break;
                this.getLogger().info("No file change monitor for " + f + ", need to initialize");
                break;
            }
        }
        if (init) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Initializing file monitors");
            }
            panel.setFileMonitors(new HashMap<String, FileChangeMonitor>());
            for (File f : files) {
                MultiMonitor multi = new MultiMonitor();
                multi.setCombinationType(MultiMonitor.CombinationType.OR);
                multi.setMonitors(new FileChangeMonitor[]{new Size(), new LastModified()});
                multi.initialize(f);
                panel.getFileMonitors().put(f.getAbsolutePath(), (FileChangeMonitor)multi);
            }
        } else {
            for (File f : files) {
                if (!panel.getFileMonitors().get(f.getAbsolutePath()).hasChanged(f)) continue;
                changed = true;
                if (!this.isLoggingEnabled()) break;
                this.getLogger().info("File " + f + " changed, need to reload");
                break;
            }
        }
        if (init || changed) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Reloading files");
            }
            panel.setReports(new HashMap<String, Report>());
            CocoAnnotationsReportReader reader = new CocoAnnotationsReportReader();
            for (File f : files) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Reloading " + f);
                }
                reader.setInput(new PlaceholderFile(f));
                List reports = reader.read();
                for (Report report : reports) {
                    File image = new File(report.getStringValue("Filename"));
                    panel.getReports().put(image.getName(), report);
                }
            }
        }
    }

    protected Report filterReport(Report report) {
        if (this.m_Finder instanceof AllFinder) {
            return report;
        }
        LocatedObjects objs = this.m_Finder.findObjects(report);
        Report result = report.getClone();
        result.removeValuesStartingWith(this.m_Finder.getPrefix());
        result.mergeWith(objs.toReport(this.m_Finder.getPrefix()));
        return result;
    }

    protected Report loadFromJson(CombinedPanel panel, File file) {
        this.refreshReportsIfNecessary(panel, file);
        Report result = null;
        if (panel.getReports().containsKey(file.getName())) {
            result = this.filterReport(panel.getReports().get(file.getName()));
        }
        return result;
    }

    protected PreviewPanel createPreview(File file) {
        CombinedPanel panel = new CombinedPanel();
        panel.setAlternativeLocation((File)this.m_AlternativeLocation);
        panel.setUseAlternativeLocation(this.m_UseAlternativeLocation);
        Report report = this.loadFromJson(panel, file);
        panel.getImagePanel().load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        panel.getImagePanel().setAdditionalProperties(report);
        return new PreviewPanel((JComponent)((Object)panel), (JComponent)panel.getImagePanel().getPaintPanel());
    }

    public PreviewPanel reusePreview(File file, PreviewPanel previewPanel) {
        CombinedPanel panel = (CombinedPanel)((Object)previewPanel.getComponent());
        Report report = this.loadFromJson(panel, file);
        panel.getImagePanel().load(file, (AbstractImageReader)new JAIImageReader(), panel.getImagePanel().getScale());
        panel.getImagePanel().setAdditionalProperties(report);
        return previewPanel;
    }

    public class CombinedPanel
    extends BasePanel {
        private static final long serialVersionUID = 236378741683380463L;
        protected ImagePanel m_PanelImage;
        protected BaseCheckBox m_CheckBoxAlternative;
        protected DirectoryChooserPanel m_ChooserAlternative;
        protected Map<String, FileChangeMonitor> m_FileMonitors;
        protected Map<String, Report> m_Reports;

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PanelImage = new ImagePanel();
            ObjectLocationsOverlayFromReport overlay = new ObjectLocationsOverlayFromReport();
            overlay.setColor(CocoAnnotationsHandler.this.m_Color);
            overlay.setUseColorsPerType(CocoAnnotationsHandler.this.m_UseColorsPerType);
            overlay.setTypeColorProvider((ColorProvider)CocoAnnotationsHandler.this.m_TypeColorProvider.shallowCopy());
            overlay.setTypeRegExp((BaseRegExp)CocoAnnotationsHandler.this.m_TypeRegExp.getClone());
            overlay.setLabelFormat(CocoAnnotationsHandler.this.m_LabelFormat);
            overlay.setLabelFont(CocoAnnotationsHandler.this.m_LabelFont);
            this.m_PanelImage.addImageOverlay((ImageOverlay)overlay);
            this.m_PanelImage.addLeftClickListener((ImagePanelLeftClickListener)new ViewObjects());
            this.add((Component)this.m_PanelImage, "Center");
            JPanel panelBottom = new JPanel(new FlowLayout(0));
            this.add(panelBottom, "South");
            this.m_CheckBoxAlternative = new BaseCheckBox("Alternative report location");
            this.m_CheckBoxAlternative.addActionListener(e -> this.toggleAlternative());
            panelBottom.add((Component)this.m_CheckBoxAlternative);
            this.m_ChooserAlternative = new DirectoryChooserPanel();
            this.m_ChooserAlternative.setEnabled(false);
            this.m_ChooserAlternative.addChangeListener(e -> this.updateReport());
            panelBottom.add((Component)this.m_ChooserAlternative);
        }

        protected void updateReport() {
            if (this.getImagePanel().getCurrentFile() != null) {
                this.getImagePanel().setAdditionalProperties(CocoAnnotationsHandler.this.loadFromJson(this, this.getImagePanel().getCurrentFile()));
            }
        }

        protected void toggleAlternative() {
            this.m_ChooserAlternative.setEnabled(this.m_CheckBoxAlternative.isSelected());
            this.updateReport();
        }

        public void setUseAlternativeLocation(boolean value) {
            this.m_CheckBoxAlternative.setSelected(value);
            this.m_ChooserAlternative.setEnabled(value);
            this.updateReport();
        }

        public boolean getUseAlternativeLocation() {
            return this.m_CheckBoxAlternative.isSelected();
        }

        public void setAlternativeLocation(File value) {
            this.m_ChooserAlternative.setCurrent(value);
            this.updateReport();
        }

        public File getAlternativeLocation() {
            return (File)this.m_ChooserAlternative.getCurrent();
        }

        public ImagePanel getImagePanel() {
            return this.m_PanelImage;
        }

        public void setFileMonitors(Map<String, FileChangeMonitor> value) {
            this.m_FileMonitors = value;
        }

        public Map<String, FileChangeMonitor> getFileMonitors() {
            return this.m_FileMonitors;
        }

        public void setReports(Map<String, Report> reports) {
            this.m_Reports = reports;
        }

        public Map<String, Report> getReports() {
            return this.m_Reports;
        }
    }
}

