/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BasePanel;
import adams.gui.core.Fonts;
import adams.gui.event.ImagePanelLeftClickListener;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.TranslucentColorProvider;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectCentersOverlayFromReport;
import adams.gui.visualization.image.leftclick.ViewObjects;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ObjectCentersFromReport
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    protected String m_Prefix;
    protected int m_Diameter;
    protected Color m_Color;
    protected boolean m_UseColorsPerType;
    protected ColorProvider m_TypeColorProvider;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeRegExp;
    protected String m_LabelFormat;
    protected Font m_LabelFont;
    protected boolean m_VaryShapeColor;
    protected ColorProvider m_ShapeColorProvider;
    protected ObjectFinder m_Finder;
    protected boolean m_UseAlternativeLocation;
    protected PlaceholderDirectory m_AlternativeLocation;
    protected boolean m_ShowObjectPanel;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the objects stored in the report with the same name (using object prefix 'Object.'): " + Utils.arrayToString((Object)this.getExtensions());
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("diameter", "diameter", (Object)10, (Number)-1, null);
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("use-colors-per-type", "useColorsPerType", (Object)true);
        this.m_OptionManager.add("type-color-provider", "typeColorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("label-format", "labelFormat", (Object)"#. $");
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
        this.m_OptionManager.add("vary-shape-color", "varyShapeColor", (Object)false);
        this.m_OptionManager.add("shape-color-provider", "shapeColorProvider", (Object)new TranslucentColorProvider());
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("use-alternative-location", "useAlternativeLocation", (Object)false);
        this.m_OptionManager.add("alternative-location", "alternativeLocation", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("show-object-panel", "showObjectPanel", (Object)false);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix of fields in the report to identify as object location, eg 'Object.'.";
    }

    public void setDiameter(int value) {
        if (this.getOptionManager().isValid("diameter", (Number)value)) {
            this.m_Diameter = value;
            this.reset();
        }
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the circle that is drawn; < 1 to use the rectangle's dimensions to draw an ellipse.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    public void setUseColorsPerType(boolean value) {
        this.m_UseColorsPerType = value;
        this.reset();
    }

    public boolean getUseColorsPerType() {
        return this.m_UseColorsPerType;
    }

    public String useColorsPerTypeTipText() {
        return "If enabled, individual colors per type are used.";
    }

    public void setTypeColorProvider(ColorProvider value) {
        this.m_TypeColorProvider = value;
        this.reset();
    }

    public ColorProvider getTypeColorProvider() {
        return this.m_TypeColorProvider;
    }

    public String typeColorProviderTipText() {
        return "The color provider to use for the various types.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The suffix of fields in the report to identify the type.";
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_TypeRegExp = value;
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_TypeRegExp;
    }

    public String typeRegExpTipText() {
        return "The regular expression that the types must match in order to get drawn (eg only plotting a subset).";
    }

    public void setLabelFormat(String value) {
        this.m_LabelFormat = value;
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_LabelFormat;
    }

    public String labelFormatTipText() {
        return "The label format string to use for the rectangles; '#' for index, '@' for type and '$' for short type (type suffix must be defined for '@' and '$'); for instance: '# @'.";
    }

    public void setLabelFont(Font value) {
        this.m_LabelFont = value;
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    public String labelFontTipText() {
        return "The font to use for the labels.";
    }

    public void setVaryShapeColor(boolean value) {
        this.m_VaryShapeColor = value;
        this.reset();
    }

    public boolean getVaryShapeColor() {
        return this.m_VaryShapeColor;
    }

    public String varyShapeColorTipText() {
        return "If enabled, the shape colors get varied.";
    }

    public void setShapeColorProvider(ColorProvider value) {
        this.m_ShapeColorProvider = value;
        this.reset();
    }

    public ColorProvider getShapeColorProvider() {
        return this.m_ShapeColorProvider;
    }

    public String shapeColorProviderTipText() {
        return "The color provider to use when varying the shape colors.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public void setUseAlternativeLocation(boolean value) {
        this.m_UseAlternativeLocation = value;
        this.reset();
    }

    public boolean getUseAlternativeLocation() {
        return this.m_UseAlternativeLocation;
    }

    public String useAlternativeLocationTipText() {
        return "If enabled, the alternative location is used to locate the associated report rather than the directory with the image.";
    }

    public void setAlternativeLocation(PlaceholderDirectory value) {
        this.m_AlternativeLocation = value;
        this.reset();
    }

    public PlaceholderDirectory getAlternativeLocation() {
        return this.m_AlternativeLocation;
    }

    public String alternativeLocationTipText() {
        return "The alternative location to use look for associated reports.";
    }

    public void setShowObjectPanel(boolean value) {
        this.m_ShowObjectPanel = value;
        this.reset();
    }

    public boolean getShowObjectPanel() {
        return this.m_ShowObjectPanel;
    }

    public String showObjectPanelTipText() {
        return "If enabled, the panel for selecting located objects is being displayed.";
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected Report filterReport(Report report) {
        if (this.m_Finder instanceof AllFinder) {
            return report;
        }
        LocatedObjects objs = this.m_Finder.findObjects(report);
        Report result = report.getClone();
        result.removeValuesStartingWith(this.m_Finder.getPrefix());
        result.mergeWith(objs.toReport(this.m_Finder.getPrefix()));
        return result;
    }

    protected Report loadReport(CombinedPanel panel, File file) {
        Report result = null;
        File baseFile = panel.getUseAlternativeLocation() ? new PlaceholderFile(panel.getAlternativeLocation().getAbsolutePath() + File.separator + file.getName()) : file;
        File reportFile = FileUtils.replaceExtension((File)baseFile, (String)".report");
        if (reportFile.exists() && reportFile.isFile()) {
            DefaultSimpleReportReader reportReader = new DefaultSimpleReportReader();
            reportReader.setInput(new PlaceholderFile(reportFile));
            List reports = reportReader.read();
            if (reports.size() > 0) {
                result = this.filterReport((Report)reports.get(0));
            }
        }
        return result;
    }

    protected PreviewPanel createPreview(File file) {
        CombinedPanel panel = new CombinedPanel();
        panel.setAlternativeLocation((File)this.m_AlternativeLocation);
        panel.setUseAlternativeLocation(this.m_UseAlternativeLocation);
        Report report = this.loadReport(panel, file);
        panel.getImagePanel().load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        panel.getImagePanel().setAdditionalProperties(report);
        return new PreviewPanel((JComponent)((Object)panel), (JComponent)panel.getImagePanel().getPaintPanel());
    }

    public PreviewPanel reusePreview(File file, PreviewPanel previewPanel) {
        CombinedPanel panel = (CombinedPanel)((Object)previewPanel.getComponent());
        Report report = this.loadReport(panel, file);
        panel.getImagePanel().load(file, (AbstractImageReader)new JAIImageReader(), panel.getImagePanel().getScale());
        panel.getImagePanel().setAdditionalProperties(report);
        return previewPanel;
    }

    public class CombinedPanel
    extends BasePanel {
        private static final long serialVersionUID = 236378741683380463L;
        protected ImagePanel m_PanelImage;
        protected BaseCheckBox m_CheckBoxAlternative;
        protected DirectoryChooserPanel m_ChooserAlternative;

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PanelImage = new ImagePanel();
            ObjectCentersOverlayFromReport overlay = new ObjectCentersOverlayFromReport();
            overlay.setPrefix(ObjectCentersFromReport.this.m_Prefix);
            overlay.setColor(ObjectCentersFromReport.this.m_Color);
            overlay.setUseColorsPerType(ObjectCentersFromReport.this.m_UseColorsPerType);
            overlay.setTypeColorProvider((ColorProvider)ObjectCentersFromReport.this.m_TypeColorProvider.shallowCopy());
            overlay.setTypeSuffix(ObjectCentersFromReport.this.m_TypeSuffix);
            overlay.setTypeRegExp((BaseRegExp)ObjectCentersFromReport.this.m_TypeRegExp.getClone());
            overlay.setLabelFormat(ObjectCentersFromReport.this.m_LabelFormat);
            overlay.setLabelFont(ObjectCentersFromReport.this.m_LabelFont);
            overlay.setVaryShapeColor(ObjectCentersFromReport.this.m_VaryShapeColor);
            overlay.setShapeColorProvider((ColorProvider)ObjectCentersFromReport.this.m_ShapeColorProvider.shallowCopy());
            overlay.setShowObjectPanel(ObjectCentersFromReport.this.m_ShowObjectPanel);
            this.m_PanelImage.addImageOverlay((ImageOverlay)overlay);
            this.m_PanelImage.addLeftClickListener((ImagePanelLeftClickListener)new ViewObjects());
            this.add((Component)this.m_PanelImage, "Center");
            JPanel panelBottom = new JPanel(new FlowLayout(0));
            this.add(panelBottom, "South");
            this.m_CheckBoxAlternative = new BaseCheckBox("Alternative report location");
            this.m_CheckBoxAlternative.addActionListener(e -> this.toggleAlternative());
            panelBottom.add((Component)this.m_CheckBoxAlternative);
            this.m_ChooserAlternative = new DirectoryChooserPanel();
            this.m_ChooserAlternative.setEnabled(false);
            this.m_ChooserAlternative.addChangeListener(e -> this.updateReport());
            panelBottom.add((Component)this.m_ChooserAlternative);
        }

        protected void updateReport() {
            if (this.getImagePanel().getCurrentFile() != null) {
                this.getImagePanel().setAdditionalProperties(ObjectCentersFromReport.this.loadReport(this, this.getImagePanel().getCurrentFile()));
            }
        }

        protected void toggleAlternative() {
            this.m_ChooserAlternative.setEnabled(this.m_CheckBoxAlternative.isSelected());
            this.updateReport();
        }

        public void setUseAlternativeLocation(boolean value) {
            this.m_CheckBoxAlternative.setSelected(value);
            this.m_ChooserAlternative.setEnabled(value);
            this.updateReport();
        }

        public boolean getUseAlternativeLocation() {
            return this.m_CheckBoxAlternative.isSelected();
        }

        public void setAlternativeLocation(File value) {
            this.m_ChooserAlternative.setCurrent(value);
            this.updateReport();
        }

        public File getAlternativeLocation() {
            return (File)this.m_ChooserAlternative.getCurrent();
        }

        public ImagePanel getImagePanel() {
            return this.m_PanelImage;
        }
    }
}

