/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.data.image.ImageAnchor;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.objectoverlap.AreaRatio;
import adams.data.objectoverlap.ObjectOverlap;
import adams.data.overlappingobjectremoval.AbstractOverlappingObjectRemoval;
import adams.data.overlappingobjectremoval.OverlappingObjectRemoval;
import adams.data.overlappingobjectremoval.PassThrough;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BasePanel;
import adams.gui.core.Fonts;
import adams.gui.event.ImagePanelLeftClickListener;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.TranslucentColorProvider;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import adams.gui.visualization.image.leftclick.ViewObjects;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ObjectLocationsFromReport
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    protected AbstractReportReader m_Reader;
    protected String m_Prefix;
    protected Color m_Color;
    protected boolean m_UseColorsPerType;
    protected ColorProvider m_TypeColorProvider;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeRegExp;
    protected boolean m_Filled;
    protected String m_LabelFormat;
    protected Font m_LabelFont;
    protected ImageAnchor m_LabelAnchor;
    protected int m_LabelOffsetX;
    protected int m_LabelOffsetY;
    protected BaseString[] m_PredefinedLabels;
    protected boolean m_VaryShapeColor;
    protected ColorProvider m_ShapeColorProvider;
    protected ObjectFinder m_Finder;
    protected double m_BoundingBoxFallbackRatio;
    protected ObjectOverlap m_OverlapDetection;
    protected OverlappingObjectRemoval m_OverlapRemoval;
    protected boolean m_UseAlternativeLocation;
    protected PlaceholderDirectory m_AlternativeLocation;
    protected boolean m_ShowObjectPanel;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the objects stored in the report with the same name (using object prefix 'Object.'): " + Utils.arrayToString((Object)this.getExtensions());
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)this.getDefaultReader());
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("use-colors-per-type", "useColorsPerType", (Object)this.getDefaultUseColorsPerType());
        this.m_OptionManager.add("type-color-provider", "typeColorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("filled", "filled", (Object)false);
        this.m_OptionManager.add("label-format", "labelFormat", (Object)this.getDefaultLabelFormat());
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
        this.m_OptionManager.add("label-anchor", "labelAnchor", (Object)this.getDefaultLabelAnchor());
        this.m_OptionManager.add("label-offset-x", "labelOffsetX", (Object)this.getDefaultLabelOffsetX());
        this.m_OptionManager.add("label-offset-y", "labelOffsetY", (Object)this.getDefaultLabelOffsetY());
        this.m_OptionManager.add("predefined-labels", "predefinedLabels", (Object)new BaseString[0]);
        this.m_OptionManager.add("vary-shape-color", "varyShapeColor", (Object)false);
        this.m_OptionManager.add("shape-color-provider", "shapeColorProvider", (Object)new TranslucentColorProvider());
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("bounding-box-fallback-ratio", "boundingBoxFallbackRatio", (Object)0.0, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("overlap-detection", "overlapDetection", (Object)new AreaRatio());
        this.m_OptionManager.add("overlap-removal", "overlapRemoval", (Object)new PassThrough());
        this.m_OptionManager.add("use-alternative-location", "useAlternativeLocation", (Object)false);
        this.m_OptionManager.add("alternative-location", "alternativeLocation", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("show-object-panel", "showObjectPanel", (Object)false);
    }

    protected AbstractReportReader getDefaultReader() {
        return new DefaultSimpleReportReader();
    }

    public void setReader(AbstractReportReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractReportReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for reading the report.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix of fields in the report to identify as object location, eg 'Object.'.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    protected boolean getDefaultUseColorsPerType() {
        return true;
    }

    public void setUseColorsPerType(boolean value) {
        this.m_UseColorsPerType = value;
        this.reset();
    }

    public boolean getUseColorsPerType() {
        return this.m_UseColorsPerType;
    }

    public String useColorsPerTypeTipText() {
        return "If enabled, individual colors per type are used.";
    }

    public void setTypeColorProvider(ColorProvider value) {
        this.m_TypeColorProvider = value;
        this.reset();
    }

    public ColorProvider getTypeColorProvider() {
        return this.m_TypeColorProvider;
    }

    public String typeColorProviderTipText() {
        return "The color provider to use for the various types.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The suffix of fields in the report to identify the type.";
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_TypeRegExp = value;
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_TypeRegExp;
    }

    public String typeRegExpTipText() {
        return "The regular expression that the types must match in order to get drawn (eg only plotting a subset).";
    }

    public void setFilled(boolean value) {
        this.m_Filled = value;
        this.reset();
    }

    public boolean getFilled() {
        return this.m_Filled;
    }

    public String filledTipText() {
        return "If enabled, the shape is drawn filled.";
    }

    protected String getDefaultLabelFormat() {
        return "#. $";
    }

    public void setLabelFormat(String value) {
        this.m_LabelFormat = value;
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_LabelFormat;
    }

    public String labelFormatTipText() {
        return "The label format string to use for the rectangles; '#' for index, '@' for type and '$' for short type (type suffix must be defined for '@' and '$'), '{BLAH}' gets replaced with the value associated with the meta-data key 'BLAH'; for instance: '# @' or '# {BLAH}'; in case of numeric values, use '|.X' to limit the number of decimals, eg '{BLAH|.2}' for a maximum of decimals after the decimal point.";
    }

    public void setLabelFont(Font value) {
        this.m_LabelFont = value;
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    public String labelFontTipText() {
        return "The font to use for the labels.";
    }

    protected ImageAnchor getDefaultLabelAnchor() {
        return ImageAnchor.TOP_RIGHT;
    }

    public void setLabelAnchor(ImageAnchor value) {
        this.m_LabelAnchor = value;
        this.reset();
    }

    public ImageAnchor getLabelAnchor() {
        return this.m_LabelAnchor;
    }

    public String labelAnchorTipText() {
        return "The anchor for the label.";
    }

    protected int getDefaultLabelOffsetX() {
        return 0;
    }

    public void setLabelOffsetX(int value) {
        this.m_LabelOffsetX = value;
        this.reset();
    }

    public int getLabelOffsetX() {
        return this.m_LabelOffsetX;
    }

    public String labelOffsetXTipText() {
        return "The X offset for the label; values of 0 or greater are interpreted as absolute pixels, -1 uses left as anchor, -2 the center and -3 the right.";
    }

    protected int getDefaultLabelOffsetY() {
        return 0;
    }

    public void setLabelOffsetY(int value) {
        this.m_LabelOffsetY = value;
        this.reset();
    }

    public int getLabelOffsetY() {
        return this.m_LabelOffsetY;
    }

    public String labelOffsetYTipText() {
        return "The Y offset for the label values of 0 or greater are interpreted as absolute pixels, -1 uses top as anchor, -2 the middle and -3 the bottom.";
    }

    public void setPredefinedLabels(BaseString[] value) {
        this.m_PredefinedLabels = value;
        this.reset();
    }

    public BaseString[] getPredefinedLabels() {
        return this.m_PredefinedLabels;
    }

    public String predefinedLabelsTipText() {
        return "The predefined labels to use for setting up the colors; avoids constants changing in color pallet.";
    }

    public void setVaryShapeColor(boolean value) {
        this.m_VaryShapeColor = value;
        this.reset();
    }

    public boolean getVaryShapeColor() {
        return this.m_VaryShapeColor;
    }

    public String varyShapeColorTipText() {
        return "If enabled, the shape colors get varied.";
    }

    public void setShapeColorProvider(ColorProvider value) {
        this.m_ShapeColorProvider = value;
        this.reset();
    }

    public ColorProvider getShapeColorProvider() {
        return this.m_ShapeColorProvider;
    }

    public String shapeColorProviderTipText() {
        return "The color provider to use when varying the shape colors.";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public void setBoundingBoxFallbackRatio(double value) {
        if (this.getOptionManager().isValid("boundingBoxFallbackRatio", (Number)value)) {
            this.m_BoundingBoxFallbackRatio = value;
            this.reset();
        }
    }

    public double getBoundingBoxFallbackRatio() {
        return this.m_BoundingBoxFallbackRatio;
    }

    public String boundingBoxFallbackRatioTipText() {
        return "The threshold for the ratio between the areas (shape / bbox), below which the bounding box is used over the polygon (ie bad masks/shapes).";
    }

    public void setOverlapDetection(ObjectOverlap value) {
        this.m_OverlapDetection = value;
        this.reset();
    }

    public ObjectOverlap getOverlapDetection() {
        return this.m_OverlapDetection;
    }

    public String overlapDetectionTipText() {
        return "The algorithm to use for determining the overlapping objects.";
    }

    public void setOverlapRemoval(OverlappingObjectRemoval value) {
        this.m_OverlapRemoval = value;
        this.reset();
    }

    public OverlappingObjectRemoval getOverlapRemoval() {
        return this.m_OverlapRemoval;
    }

    public String overlapRemovalTipText() {
        return "The algorithm to use for removing the overlapping objects.";
    }

    public void setUseAlternativeLocation(boolean value) {
        this.m_UseAlternativeLocation = value;
        this.reset();
    }

    public boolean getUseAlternativeLocation() {
        return this.m_UseAlternativeLocation;
    }

    public String useAlternativeLocationTipText() {
        return "If enabled, the alternative location is used to locate the associated report rather than the directory with the image.";
    }

    public void setAlternativeLocation(PlaceholderDirectory value) {
        this.m_AlternativeLocation = value;
        this.reset();
    }

    public PlaceholderDirectory getAlternativeLocation() {
        return this.m_AlternativeLocation;
    }

    public String alternativeLocationTipText() {
        return "The alternative location to use look for associated reports.";
    }

    public void setShowObjectPanel(boolean value) {
        this.m_ShowObjectPanel = value;
        this.reset();
    }

    public boolean getShowObjectPanel() {
        return this.m_ShowObjectPanel;
    }

    public String showObjectPanelTipText() {
        return "If enabled, the panel for selecting located objects is being displayed.";
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected Report filterReport(Report report) {
        Report result;
        if (this.m_Finder instanceof AllFinder && this.m_OverlapRemoval instanceof PassThrough) {
            return report;
        }
        if (this.m_OverlapRemoval instanceof PassThrough) {
            LocatedObjects objs = this.m_Finder.findObjects(report);
            result = report.getClone();
            result.removeValuesStartingWith(this.m_Finder.getPrefix());
            result.mergeWith(objs.toReport(this.m_Finder.getPrefix()));
        } else {
            try {
                result = AbstractOverlappingObjectRemoval.remove(report, report, this.m_Finder, this.m_OverlapDetection, this.m_OverlapRemoval);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to remove objects!", (Throwable)e);
                result = report;
            }
        }
        return result;
    }

    protected void loadAdditionalReports(CombinedPanel panel, File file, Report report) {
    }

    protected Report loadReport(CombinedPanel panel, File file) {
        Report result = null;
        File baseFile = panel.getUseAlternativeLocation() ? new PlaceholderFile(panel.getAlternativeLocation().getAbsolutePath() + File.separator + file.getName()) : file;
        File reportFile = FileUtils.replaceExtension((File)baseFile, (String)("." + this.m_Reader.getDefaultFormatExtension()));
        if (reportFile.exists() && reportFile.isFile()) {
            this.m_Reader.setInput(new PlaceholderFile(reportFile));
            List reports = this.m_Reader.read();
            if (reports.size() > 0) {
                result = (Report)reports.get(0);
                this.loadAdditionalReports(panel, file, result);
            }
        }
        if (result != null) {
            return this.filterReport(result);
        }
        return null;
    }

    protected void postProcessPanel(CombinedPanel panel, Report report, boolean isCreate) {
    }

    protected PreviewPanel createPreview(File file) {
        CombinedPanel panel = new CombinedPanel();
        panel.setAlternativeLocation((File)this.m_AlternativeLocation);
        panel.setUseAlternativeLocation(this.m_UseAlternativeLocation);
        Report report = this.loadReport(panel, file);
        panel.getImagePanel().load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        panel.getImagePanel().setAdditionalProperties(report);
        this.postProcessPanel(panel, report, true);
        return new PreviewPanel((JComponent)((Object)panel), (JComponent)panel.getImagePanel().getPaintPanel());
    }

    public PreviewPanel reusePreview(File file, PreviewPanel previewPanel) {
        CombinedPanel panel = (CombinedPanel)((Object)previewPanel.getComponent());
        Report report = this.loadReport(panel, file);
        panel.getImagePanel().load(file, (AbstractImageReader)new JAIImageReader(), panel.getImagePanel().getScale());
        panel.getImagePanel().setAdditionalProperties(report);
        this.postProcessPanel(panel, report, false);
        return previewPanel;
    }

    public class CombinedPanel
    extends BasePanel {
        private static final long serialVersionUID = 236378741683380463L;
        protected ImagePanel m_PanelImage;
        protected BaseCheckBox m_CheckBoxAlternative;
        protected DirectoryChooserPanel m_ChooserAlternative;

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PanelImage = new ImagePanel();
            ObjectLocationsOverlayFromReport overlay = new ObjectLocationsOverlayFromReport();
            overlay.setPrefix(ObjectLocationsFromReport.this.m_Prefix);
            overlay.setColor(ObjectLocationsFromReport.this.m_Color);
            overlay.setUseColorsPerType(ObjectLocationsFromReport.this.m_UseColorsPerType);
            overlay.setTypeColorProvider((ColorProvider)ObjectLocationsFromReport.this.m_TypeColorProvider.shallowCopy());
            overlay.setTypeSuffix(ObjectLocationsFromReport.this.m_TypeSuffix);
            overlay.setTypeRegExp((BaseRegExp)ObjectLocationsFromReport.this.m_TypeRegExp.getClone());
            overlay.setLabelFormat(ObjectLocationsFromReport.this.m_LabelFormat);
            overlay.setLabelFont(ObjectLocationsFromReport.this.m_LabelFont);
            overlay.setLabelAnchor(ObjectLocationsFromReport.this.m_LabelAnchor);
            overlay.setLabelOffsetX(ObjectLocationsFromReport.this.m_LabelOffsetX);
            overlay.setLabelOffsetY(ObjectLocationsFromReport.this.m_LabelOffsetY);
            overlay.setPredefinedLabels(ObjectLocationsFromReport.this.m_PredefinedLabels);
            overlay.setFilled(ObjectLocationsFromReport.this.m_Filled);
            overlay.setVaryShapeColor(ObjectLocationsFromReport.this.m_VaryShapeColor);
            overlay.setShapeColorProvider((ColorProvider)ObjectLocationsFromReport.this.m_ShapeColorProvider.shallowCopy());
            overlay.setBoundingBoxFallbackRatio(ObjectLocationsFromReport.this.m_BoundingBoxFallbackRatio);
            overlay.setShowObjectPanel(ObjectLocationsFromReport.this.m_ShowObjectPanel);
            this.m_PanelImage.addImageOverlay((ImageOverlay)overlay);
            this.m_PanelImage.addLeftClickListener((ImagePanelLeftClickListener)new ViewObjects());
            this.add((Component)this.m_PanelImage, "Center");
            JPanel panelBottom = new JPanel(new FlowLayout(0));
            this.add(panelBottom, "South");
            this.m_CheckBoxAlternative = new BaseCheckBox("Alternative report location");
            this.m_CheckBoxAlternative.addActionListener(e -> this.toggleAlternative());
            panelBottom.add((Component)this.m_CheckBoxAlternative);
            this.m_ChooserAlternative = new DirectoryChooserPanel();
            this.m_ChooserAlternative.setEnabled(false);
            this.m_ChooserAlternative.addChangeListener(e -> this.updateReport());
            panelBottom.add((Component)this.m_ChooserAlternative);
        }

        protected void updateReport() {
            if (this.getImagePanel().getCurrentFile() != null) {
                this.getImagePanel().setAdditionalProperties(ObjectLocationsFromReport.this.loadReport(this, this.getImagePanel().getCurrentFile()));
            }
        }

        protected void toggleAlternative() {
            this.m_ChooserAlternative.setEnabled(this.m_CheckBoxAlternative.isSelected());
            this.updateReport();
        }

        public void setUseAlternativeLocation(boolean value) {
            this.m_CheckBoxAlternative.setSelected(value);
            this.m_ChooserAlternative.setEnabled(value);
            this.updateReport();
        }

        public boolean getUseAlternativeLocation() {
            return this.m_CheckBoxAlternative.isSelected();
        }

        public void setAlternativeLocation(File value) {
            this.m_ChooserAlternative.setCurrent(value);
            this.updateReport();
        }

        public File getAlternativeLocation() {
            return (File)this.m_ChooserAlternative.getCurrent();
        }

        public ImagePanel getImagePanel() {
            return this.m_PanelImage;
        }
    }
}

