/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.VggXmlAnnotationReportReader;
import adams.data.report.Report;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.report.ReportFactory;
import java.awt.Container;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public class VggXmlAnnotationHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -1671414346233382229L;

    public String globalInfo() {
        return "Displays the VGG XML file as a report: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"xml"};
    }

    protected PreviewPanel createPreview(File file) {
        File reportFile = FileUtils.replaceExtension((File)file, (String)".xml");
        if (reportFile.exists() && reportFile.isFile()) {
            VggXmlAnnotationReportReader reportReader = new VggXmlAnnotationReportReader();
            reportReader.setInput(new PlaceholderFile(reportFile));
            List reports = reportReader.read();
            if (reports.size() > 0) {
                BasePanel result = ReportFactory.getPanel((Report)((Report)reports.get(0)), (boolean)true);
                ReportFactory.Table table = (ReportFactory.Table)GUIHelper.findFirstComponent((Container)result, ReportFactory.Table.class, (boolean)true, (boolean)true);
                return new PreviewPanel((JComponent)result, (JComponent)table);
            }
        }
        return new NoPreviewAvailablePanel();
    }
}

