/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.data.image.ImageAnchor;
import adams.flow.transformer.locateobjects.AcceptAllLocatedObjectsFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseList;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.PopupMenuCustomizer;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.TranslucentColorProvider;
import adams.gui.visualization.image.AbstractImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ReportObjectOverlay;
import adams.gui.visualization.image.TypeColorProvider;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractObjectOverlayFromReport
extends AbstractImageOverlay
implements PopupMenuCustomizer<ImagePanel.PaintPanel>,
TypeColorProvider {
    private static final long serialVersionUID = 6356419097401574024L;
    public static final String PREFIX_DEFAULT = "Object.";
    protected ReportObjectOverlay m_Overlays;
    protected Set<ChangeListener> m_LocationsUpdatedListeners;
    protected boolean m_ShowObjectPanel;
    protected LocatedObjectsPanel m_PanelObjects;
    protected transient ImagePanel.PaintPanel m_Owner;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)PREFIX_DEFAULT);
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("use-colors-per-type", "useColorsPerType", (Object)false);
        this.m_OptionManager.add("type-color-provider", "typeColorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("label-format", "labelFormat", (Object)"#");
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
        this.m_OptionManager.add("label-anchor", "labelAnchor", (Object)this.getDefaultLabelAnchor());
        this.m_OptionManager.add("label-offset-x", "labelOffsetX", (Object)this.getDefaultLabelOffsetX());
        this.m_OptionManager.add("label-offset-y", "labelOffsetY", (Object)this.getDefaultLabelOffsetY());
        this.m_OptionManager.add("predefined-labels", "predefinedLabels", (Object)new BaseString[0]);
        this.m_OptionManager.add("vary-shape-color", "varyShapeColor", (Object)false);
        this.m_OptionManager.add("shape-color-provider", "shapeColorProvider", (Object)new TranslucentColorProvider());
        this.m_OptionManager.add("show-object-panel", "showObjectPanel", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Owner = null;
        this.m_Overlays = new ReportObjectOverlay();
        this.m_LocationsUpdatedListeners = new HashSet<ChangeListener>();
    }

    public ImagePanel.PaintPanel getOwner() {
        return this.m_Owner;
    }

    protected ReportObjectOverlay getOverlays() {
        return this.m_Overlays;
    }

    public void setPrefix(String value) {
        this.m_Overlays.setPrefix(value);
        this.reset();
    }

    public String getPrefix() {
        return this.m_Overlays.getPrefix();
    }

    public String prefixTipText() {
        return this.m_Overlays.prefixTipText();
    }

    public void setColor(Color value) {
        this.m_Overlays.setColor(value);
        this.reset();
    }

    public Color getColor() {
        return this.m_Overlays.getColor();
    }

    public String colorTipText() {
        return this.m_Overlays.colorTipText();
    }

    public void setUseColorsPerType(boolean value) {
        this.m_Overlays.setUseColorsPerType(value);
        this.reset();
    }

    public boolean getUseColorsPerType() {
        return this.m_Overlays.getUseColorsPerType();
    }

    public String useColorsPerTypeTipText() {
        return this.m_Overlays.useColorsPerTypeTipText();
    }

    public void setTypeColorProvider(ColorProvider value) {
        this.m_Overlays.setTypeColorProvider(value);
        this.reset();
    }

    public ColorProvider getTypeColorProvider() {
        return this.m_Overlays.getTypeColorProvider();
    }

    public String typeColorProviderTipText() {
        return this.m_Overlays.typeColorProviderTipText();
    }

    public void setTypeSuffix(String value) {
        this.m_Overlays.setTypeSuffix(value);
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_Overlays.getTypeSuffix();
    }

    public String typeSuffixTipText() {
        return this.m_Overlays.typeSuffixTipText();
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_Overlays.setTypeRegExp(value);
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_Overlays.getTypeRegExp();
    }

    public String typeRegExpTipText() {
        return this.m_Overlays.typeRegExpTipText();
    }

    public void setLabelFormat(String value) {
        this.m_Overlays.setLabelFormat(value);
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_Overlays.getLabelFormat();
    }

    public String labelFormatTipText() {
        return this.m_Overlays.labelFormatTipText();
    }

    public void setLabelFont(Font value) {
        this.m_Overlays.setLabelFont(value);
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_Overlays.getLabelFont();
    }

    public String labelFontTipText() {
        return this.m_Overlays.labelFontTipText();
    }

    protected ImageAnchor getDefaultLabelAnchor() {
        return ImageAnchor.TOP_RIGHT;
    }

    public void setLabelAnchor(ImageAnchor value) {
        this.m_Overlays.setLabelAnchor(value);
        this.reset();
    }

    public ImageAnchor getLabelAnchor() {
        return this.m_Overlays.getLabelAnchor();
    }

    public String labelAnchorTipText() {
        return this.m_Overlays.labelAnchorTipText();
    }

    protected int getDefaultLabelOffsetX() {
        return 0;
    }

    public void setLabelOffsetX(int value) {
        this.m_Overlays.setLabelOffsetX(value);
        this.reset();
    }

    public int getLabelOffsetX() {
        return this.m_Overlays.getLabelOffsetX();
    }

    public String labelOffsetXTipText() {
        return this.m_Overlays.labelOffsetXTipText();
    }

    protected int getDefaultLabelOffsetY() {
        return 0;
    }

    public void setLabelOffsetY(int value) {
        this.m_Overlays.setLabelOffsetY(value);
        this.reset();
    }

    public int getLabelOffsetY() {
        return this.m_Overlays.getLabelOffsetY();
    }

    public String labelOffsetYTipText() {
        return this.m_Overlays.labelOffsetYTipText();
    }

    public void setPredefinedLabels(BaseString[] value) {
        this.m_Overlays.setPredefinedLabels(value);
        this.reset();
    }

    public BaseString[] getPredefinedLabels() {
        return this.m_Overlays.getPredefinedLabels();
    }

    public String predefinedLabelsTipText() {
        return this.m_Overlays.predefinedLabelsTipText();
    }

    public void setVaryShapeColor(boolean value) {
        this.m_Overlays.setVaryShapeColor(value);
        this.reset();
    }

    public boolean getVaryShapeColor() {
        return this.m_Overlays.getVaryShapeColor();
    }

    public String varyShapeColorTipText() {
        return this.m_Overlays.varyShapeColorTipText();
    }

    public void setShapeColorProvider(ColorProvider value) {
        this.m_Overlays.setShapeColorProvider(value);
        this.reset();
    }

    public ColorProvider getShapeColorProvider() {
        return this.m_Overlays.getShapeColorProvider();
    }

    public String shapeColorProviderTipText() {
        return this.m_Overlays.shapeColorProviderTipText();
    }

    public void setShowObjectPanel(boolean value) {
        this.m_ShowObjectPanel = value;
        this.reset();
    }

    public boolean getShowObjectPanel() {
        return this.m_ShowObjectPanel;
    }

    public String showObjectPanelTipText() {
        return "If enabled, the panel for selecting located objects is being displayed.";
    }

    @Override
    public boolean hasTypeColor(String type) {
        return this.m_Overlays.hasTypeColor(type);
    }

    @Override
    public Color getTypeColor(String type) {
        return this.m_Overlays.getTypeColor(type);
    }

    @Override
    public void addLocationsUpdatedListeners(ChangeListener l) {
        this.m_LocationsUpdatedListeners.add(l);
    }

    @Override
    public void removeLocationsUpdatedListeners(ChangeListener l) {
        this.m_LocationsUpdatedListeners.remove(l);
    }

    protected void notifyLocationsUpdatedListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_LocationsUpdatedListeners) {
            l.stateChanged(e);
        }
    }

    protected LocatedObjectsPanel getLocatedObjectsPanel() {
        if (this.m_PanelObjects == null) {
            this.m_PanelObjects = new LocatedObjectsPanel();
            this.m_PanelObjects.setOwner(this);
        }
        this.m_PanelObjects.setLocatedObjects(this.m_Overlays.getAllObjects());
        return this.m_PanelObjects;
    }

    public void overlayAdded(ImagePanel.PaintPanel panel) {
        super.overlayAdded(panel);
        this.m_Owner = panel;
        if (panel.getOwner() == null) {
            return;
        }
        if (this.m_ShowObjectPanel) {
            panel.getOwner().setLeftPanel((JPanel)((Object)this.getLocatedObjectsPanel()));
        } else {
            panel.getOwner().removeLeftPanel();
        }
    }

    public void overlayRemoved(ImagePanel.PaintPanel panel) {
        if (this.m_ShowObjectPanel && panel.getOwner() != null) {
            panel.getOwner().removeLeftPanel();
        }
        this.m_Owner = null;
        super.overlayRemoved(panel);
    }

    protected synchronized void doImageChanged(ImagePanel.PaintPanel panel) {
        this.m_Overlays.reset();
    }

    protected abstract void doPaintObjects(ImagePanel.PaintPanel var1, Graphics var2, List<Polygon> var3);

    protected synchronized void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        LocatedObjectsPanel objects;
        JPanel left;
        if (this.m_ShowObjectPanel && (left = panel.getOwner().getLeftPanel()) != (objects = this.getLocatedObjectsPanel())) {
            panel.getOwner().setLeftPanel((JPanel)((Object)objects));
        }
        LocatedObjectFilter filter = null;
        if (this.m_ShowObjectPanel) {
            filter = this.m_PanelObjects.getFilter();
        }
        if (filter == null) {
            filter = new AcceptAllLocatedObjectsFilter();
        }
        boolean updated = this.m_Overlays.determineLocations(panel.getOwner().getAdditionalProperties(), filter);
        if (this.m_Overlays.hasLocations()) {
            this.doPaintObjects(panel, g, this.m_Overlays.getLocations());
        }
        if (updated) {
            this.notifyLocationsUpdatedListeners();
            if (this.m_ShowObjectPanel) {
                this.m_PanelObjects.setLocatedObjects(this.m_Overlays.getAllObjects());
            }
        }
    }

    public void customizePopupMenu(ImagePanel.PaintPanel source, JPopupMenu menu) {
        if (!this.getTypeSuffix().isEmpty()) {
            JMenuItem menuitem = new JMenuItem("Displayed types", GUIHelper.getIcon((String)"objecttypes.gif"));
            menuitem.addActionListener(e -> {
                String type = GUIHelper.showInputDialog((Component)source, (String)"Regular expression for type", (String)this.getTypeRegExp().getValue());
                if (type == null) {
                    return;
                }
                if (!this.getTypeRegExp().isValid(type)) {
                    GUIHelper.showErrorMessage((Component)source, (String)("Invalid regular expression: " + type));
                    return;
                }
                this.setTypeRegExp(new BaseRegExp(type));
                source.update();
            });
            menu.add(menuitem);
        }
    }

    public void cleanUp() {
        if (this.m_LocationsUpdatedListeners != null) {
            this.m_LocationsUpdatedListeners.clear();
        }
        super.cleanUp();
    }

    public static final class LocatedObjectsPanel
    extends BasePanel {
        private static final long serialVersionUID = -2961421584086204608L;
        protected AbstractObjectOverlayFromReport m_Owner;
        protected LocatedObjects m_LocatedObjects;
        protected BaseList m_ListObjects;
        protected DefaultListModel<LocatedObject> m_ModelObjects;
        protected JLabel m_LabelCounts;
        protected BaseButton m_ButtonAll;
        protected BaseButton m_ButtonNone;
        protected BaseButton m_ButtonInvert;

        protected void initialize() {
            super.initialize();
            this.m_Owner = null;
            this.m_LocatedObjects = new LocatedObjects();
        }

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_ModelObjects = new DefaultListModel();
            this.m_ListObjects = new BaseList(this.m_ModelObjects);
            this.m_ListObjects.setSelectionMode(2);
            this.m_ListObjects.addListSelectionListener(e -> {
                this.updateCounts();
                if (this.m_Owner == null) {
                    return;
                }
                if (this.m_Owner.getOwner() == null) {
                    return;
                }
                if (this.m_Owner.getOwner().getOwner() == null) {
                    return;
                }
                this.m_Owner.getOwner().update();
            });
            this.add((Component)new BaseScrollPane((Component)this.m_ListObjects), "Center");
            JPanel panelBottom = new JPanel(new GridLayout(2, 1, 0, 0));
            this.add(panelBottom, "South");
            JPanel panel = new JPanel(new FlowLayout(0, 5, 0));
            panelBottom.add(panel);
            this.m_LabelCounts = new JLabel();
            panel.add(this.m_LabelCounts);
            panel = new JPanel(new FlowLayout(0, 5, 0));
            panelBottom.add(panel);
            this.m_ButtonAll = new BaseButton("All");
            this.m_ButtonAll.setToolTipText("Selects all objects");
            this.m_ButtonAll.addActionListener(ActionEvent2 -> this.m_ListObjects.selectAll());
            panel.add((Component)this.m_ButtonAll);
            this.m_ButtonNone = new BaseButton("None");
            this.m_ButtonNone.setToolTipText("Removes any selection");
            this.m_ButtonNone.addActionListener(ActionEvent2 -> this.m_ListObjects.selectNone());
            panel.add((Component)this.m_ButtonNone);
            this.m_ButtonInvert = new BaseButton("Invert");
            this.m_ButtonInvert.setToolTipText("Inverts the selection");
            this.m_ButtonInvert.addActionListener(ActionEvent2 -> this.m_ListObjects.invertSelection());
            panel.add((Component)this.m_ButtonInvert);
        }

        protected void finishInit() {
            super.finishInit();
            this.updateCounts();
        }

        public void setOwner(AbstractObjectOverlayFromReport value) {
            this.m_Owner = value;
            if (this.m_Owner != null) {
                this.update();
            }
        }

        public AbstractObjectOverlayFromReport getOwner() {
            return this.m_Owner;
        }

        protected void updateCounts() {
            this.m_LabelCounts.setText("Total: " + this.m_ModelObjects.getSize() + ", Selected: " + this.m_ListObjects.getSelectedIndices().length);
        }

        public void setLocatedObjects(LocatedObjects value) {
            if (value == null) {
                return;
            }
            HashSet<LocatedObject> currentObjs = new HashSet<LocatedObject>(this.m_LocatedObjects);
            HashSet<LocatedObject> newObjs = new HashSet<LocatedObject>(value);
            if (currentObjs.containsAll(newObjs) && newObjs.containsAll(currentObjs)) {
                return;
            }
            this.m_LocatedObjects = new LocatedObjects(value);
            this.m_LocatedObjects.sort((o1, o2) -> {
                int result = 0;
                if (result == 0) {
                    result = Integer.compare(o1.getX(), o2.getX());
                }
                if (result == 0) {
                    result = Integer.compare(o1.getY(), o2.getY());
                }
                if (result == 0) {
                    result = Integer.compare(o1.getWidth(), o2.getWidth());
                }
                if (result == 0) {
                    result = Integer.compare(o1.getHeight(), o2.getHeight());
                }
                return result;
            });
            this.update();
            this.m_ListObjects.selectAll();
        }

        public LocatedObjects getLocatedObjects() {
            return this.m_LocatedObjects;
        }

        public void update() {
            if (this.m_Owner == null) {
                return;
            }
            List selectedObjs = this.m_ListObjects.getSelectedValuesList();
            DefaultListModel<LocatedObject> model = new DefaultListModel<LocatedObject>();
            for (LocatedObject obj : this.m_LocatedObjects) {
                model.addElement(obj);
            }
            this.m_ModelObjects = model;
            this.m_ListObjects.setModel(this.m_ModelObjects);
            TIntArrayList selected = new TIntArrayList();
            for (LocatedObject obj : selectedObjs) {
                int index = this.m_ModelObjects.indexOf(obj);
                if (index <= -1) continue;
                selected.add(index);
            }
            this.m_ListObjects.setSelectedIndices(selected.toArray());
        }

        public LocatedObjectFilter getFilter() {
            if (this.m_ModelObjects == null) {
                return new AcceptAllLocatedObjectsFilter();
            }
            List selectedObjs = this.m_ListObjects.getSelectedValuesList();
            HashSet<LocatedObject> selectedSet = new HashSet<LocatedObject>();
            for (Object obj : selectedObjs) {
                selectedSet.add((LocatedObject)obj);
            }
            return new SelectedObjectFilter(selectedSet);
        }
    }

    public static final class SelectedObjectFilter
    implements Serializable,
    LocatedObjectFilter {
        private static final long serialVersionUID = -2342481415499910354L;
        protected Set<LocatedObject> m_Selected;

        public SelectedObjectFilter(Set<LocatedObject> selected) {
            this.m_Selected = selected;
        }

        @Override
        public boolean accept(LocatedObject obj) {
            return this.m_Selected.contains(obj);
        }
    }
}

