/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.gui.visualization.image.AbstractObjectOverlayFromReport;
import adams.gui.visualization.image.ImagePanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;

public class ObjectLocationsOverlayFromReport
extends AbstractObjectOverlayFromReport {
    private static final long serialVersionUID = 6356419097401574024L;
    protected boolean m_Filled;
    protected boolean m_PolygonBounds;
    protected float m_StrokeThickness;

    public String globalInfo() {
        return "Displays the locations of objects in the image, using data from the attached report.\nSuffixes:\n.x\n.y\n.width\n.height\nOptionally, if type information is available per object, the locations can be displayed in distinct colors per type. The type itself can be displayed as well.\nIf polygon data should be available (.poly_x and .poly_y), then this takes precedence over the rectangle coordinates.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filled", "filled", (Object)false);
        this.m_OptionManager.add("polygon-bounds", "polygonBounds", (Object)false);
        this.m_OptionManager.add("bounding-box-fallback-ratio", "boundingBoxFallbackRatio", (Object)0.0, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("stroke-thickness", "strokeThickness", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(0.01f), null);
    }

    public void setFilled(boolean value) {
        this.m_Filled = value;
        this.reset();
    }

    public boolean getFilled() {
        return this.m_Filled;
    }

    public String filledTipText() {
        return "If enabled, the shape is drawn filled.";
    }

    public void setPolygonBounds(boolean value) {
        this.m_PolygonBounds = value;
        this.reset();
    }

    public boolean getPolygonBounds() {
        return this.m_PolygonBounds;
    }

    public String polygonBoundsTipText() {
        return "If enabled, the polygon bounds are drawn as well.";
    }

    public void setBoundingBoxFallbackRatio(double value) {
        this.m_Overlays.setBoundingBoxFallbackRatio(value);
        this.reset();
    }

    public double getBoundingBoxFallbackRatio() {
        return this.m_Overlays.getBoundingBoxFallbackRatio();
    }

    public String boundingBoxFallbackRatioTipText() {
        return this.m_Overlays.boundingBoxFallbackRatioTipText();
    }

    public void setStrokeThickness(float value) {
        this.m_StrokeThickness = value;
        this.reset();
    }

    public float getStrokeThickness() {
        return this.m_StrokeThickness;
    }

    public String strokeThicknessTipText() {
        return "The thickness of the stroke.";
    }

    protected float getStrokeWidth(Graphics g, float defValue) {
        Graphics2D g2d;
        if (g instanceof Graphics2D && (g2d = (Graphics2D)g).getStroke() instanceof BasicStroke) {
            return ((BasicStroke)g2d.getStroke()).getLineWidth();
        }
        return defValue;
    }

    protected void applyStroke(Graphics g, float stroke) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(stroke));
        }
    }

    @Override
    protected void doPaintObjects(ImagePanel.PaintPanel panel, Graphics g, List<Polygon> locations) {
        float width = this.getStrokeWidth(g, 1.0f);
        this.applyStroke(g, this.m_StrokeThickness);
        Color labelColor = this.getColor();
        g.setFont(this.getLabelFont());
        for (Polygon poly : locations) {
            if (poly == null) continue;
            if (this.getUseColorsPerType() && this.m_Overlays.hasColor(poly)) {
                labelColor = this.m_Overlays.getColor(poly);
            }
            Color shapeColor = null;
            if (this.getVaryShapeColor() && this.m_Overlays.hasShapeColor(poly)) {
                shapeColor = this.m_Overlays.getShapeColor(poly);
            }
            g.setColor(shapeColor == null ? labelColor : shapeColor);
            if (this.m_Filled) {
                g.fillPolygon(poly);
                g.setColor(labelColor);
                g.drawPolygon(poly);
            } else {
                g.drawPolygon(poly);
            }
            Rectangle rect = null;
            if (this.m_PolygonBounds) {
                g.setColor(shapeColor == null ? labelColor : shapeColor);
                rect = poly.getBounds();
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!this.m_Overlays.hasLabel(poly)) continue;
            g.setColor(labelColor);
            String label = this.m_Overlays.getLabel(poly);
            if (label == null || label.isEmpty()) continue;
            if (rect == null) {
                rect = poly.getBounds();
            }
            this.m_Overlays.drawString(g, rect, label);
        }
        this.applyStroke(g, width);
    }
}

