/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.base.BaseString;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.TranslucentColorProvider;
import adams.gui.visualization.image.AbstractReportBasedOverlayHelper;
import java.awt.Color;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ReportObjectOverlay
extends AbstractReportBasedOverlayHelper {
    private static final long serialVersionUID = 6356419097401574024L;
    public static final String PREFIX_DEFAULT = "Object.";
    protected HashMap<Polygon, Color> m_ShapeColors;
    protected boolean m_VaryShapeColor;
    protected ColorProvider m_ShapeColorProvider;
    protected double m_BoundingBoxFallbackRatio;

    public String globalInfo() {
        return "Computes colors and labels for objects in report.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("vary-shape-color", "varyShapeColor", (Object)false);
        this.m_OptionManager.add("shape-color-provider", "shapeColorProvider", (Object)new TranslucentColorProvider());
        this.m_OptionManager.add("bounding-box-fallback-ratio", "boundingBoxFallbackRatio", (Object)0.0, (Number)0.0, (Number)1.0);
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ShapeColors = new HashMap();
    }

    @Override
    protected String getDefaultPrefix() {
        return PREFIX_DEFAULT;
    }

    @Override
    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public void setVaryShapeColor(boolean value) {
        this.m_VaryShapeColor = value;
        this.reset();
    }

    public boolean getVaryShapeColor() {
        return this.m_VaryShapeColor;
    }

    public String varyShapeColorTipText() {
        return "If enabled, the shape colors get varied.";
    }

    public void setShapeColorProvider(ColorProvider value) {
        this.m_ShapeColorProvider = value;
        this.reset();
    }

    public ColorProvider getShapeColorProvider() {
        return this.m_ShapeColorProvider;
    }

    public String shapeColorProviderTipText() {
        return "The color provider to use when varying the shape colors.";
    }

    public void setBoundingBoxFallbackRatio(double value) {
        if (this.getOptionManager().isValid("boundingBoxFallbackRatio", (Number)value)) {
            this.m_BoundingBoxFallbackRatio = value;
            this.reset();
        }
    }

    public double getBoundingBoxFallbackRatio() {
        return this.m_BoundingBoxFallbackRatio;
    }

    public String boundingBoxFallbackRatioTipText() {
        return "The threshold for the ratio between the areas (shape / bbox), below which the bounding box is used over the polygon (ie bad masks/shapes).";
    }

    @Override
    public boolean determineLocations(Report report, LocatedObjectFilter filter) {
        if (this.m_Locations != null) {
            return false;
        }
        if (report == null) {
            return false;
        }
        this.m_ShapeColorProvider.resetColors();
        if (this.m_UseColorsPerType) {
            this.m_TypeColors.clear();
            this.m_TypeColorProvider.resetColors();
            HashSet<String> types = new HashSet<String>();
            for (BaseString predefined : this.m_PredefinedLabels) {
                this.m_TypeColors.put(predefined.getValue(), this.m_TypeColorProvider.next());
            }
            for (AbstractField field : report.getFields()) {
                if (!field.getName().endsWith(this.m_TypeSuffix)) continue;
                types.add("" + report.getValue(field));
            }
            for (String t : types) {
                if (this.m_TypeColors.containsKey(t)) continue;
                this.m_TypeColors.put(t, this.m_TypeColorProvider.next());
            }
        }
        this.m_ObjectLocationMappings = new HashMap();
        this.m_Locations = new ArrayList();
        this.m_AllObjects = new LocatedObjects();
        this.m_FilteredObjects = new LocatedObjects();
        this.m_Colors = new HashMap();
        this.m_ShapeColors = new HashMap();
        this.m_Labels = new HashMap();
        String suffix = this.determineTypeSuffix();
        LocatedObjects result = LocatedObjects.fromReport(report, this.m_Prefix);
        for (LocatedObject object : result) {
            String label;
            Polygon poly = null;
            if (object.hasPolygon()) {
                poly = object.getPolygon();
            }
            int[] bbox_x = new int[]{object.getX(), object.getX() + object.getWidth() - 1, object.getX() + object.getWidth() - 1, object.getX()};
            int[] bbox_y = new int[]{object.getY(), object.getY(), object.getY() + object.getHeight() - 1, object.getY() + object.getHeight() - 1};
            Polygon bbox = new Polygon(bbox_x, bbox_y, bbox_x.length);
            if (poly != null && this.m_BoundingBoxFallbackRatio > 0.0) {
                double ratio;
                double area_bbox = LocatedObject.toGeometry(bbox).getArea();
                double area_poly = LocatedObject.toGeometry(poly).getArea();
                if (area_bbox > 0.0 && (ratio = area_poly / area_bbox) < this.m_BoundingBoxFallbackRatio) {
                    poly = null;
                }
            }
            if (poly == null) {
                poly = bbox;
            }
            Color color = this.m_Color;
            if (!suffix.isEmpty() && object.getMetaData() != null && object.getMetaData().containsKey(suffix)) {
                String type = "" + object.getMetaData().get(suffix);
                if (!this.m_TypeRegExp.isMatchAll() && !this.m_TypeRegExp.isMatch(type)) continue;
                if (this.m_UseColorsPerType && this.m_TypeColors.containsKey(type)) {
                    color = (Color)this.m_TypeColors.get(type);
                }
                if (!this.m_LabelFormat.isEmpty()) {
                    label = this.applyLabelFormat(object, type);
                    this.m_Labels.put(poly, label);
                }
            } else if (!this.m_LabelFormat.isEmpty()) {
                label = this.applyLabelFormat(object, "");
                this.m_Labels.put(poly, label);
            }
            this.m_AllObjects.add(object);
            if (!filter.accept(object)) continue;
            this.m_FilteredObjects.add(object);
            this.m_Colors.put(poly, color);
            this.m_ShapeColors.put(poly, this.m_ShapeColorProvider.next());
            this.m_Locations.add(poly);
            this.m_ObjectLocationMappings.put(object, poly);
        }
        return true;
    }

    public boolean hasShapeColor(Polygon poly) {
        return this.m_ShapeColors.containsKey(poly);
    }

    public Color getShapeColor(Polygon poly) {
        return this.m_ShapeColors.get(poly);
    }
}

