/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.base.BaseString;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.visualization.image.AbstractReportBasedOverlayHelper;
import java.awt.Color;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ReportPointOverlay
extends AbstractReportBasedOverlayHelper {
    private static final long serialVersionUID = 6356419097401574024L;
    public static final String PREFIX_DEFAULT = "Point.";

    public String globalInfo() {
        return "Computes colors and labels for points in report.";
    }

    @Override
    protected String getDefaultPrefix() {
        return PREFIX_DEFAULT;
    }

    @Override
    public boolean determineLocations(Report report, LocatedObjectFilter filter) {
        if (this.m_Locations != null) {
            return false;
        }
        if (report == null) {
            return false;
        }
        if (this.m_UseColorsPerType) {
            this.m_TypeColors.clear();
            this.m_TypeColorProvider.resetColors();
            HashSet<String> types = new HashSet<String>();
            for (BaseString predefined : this.m_PredefinedLabels) {
                this.m_TypeColors.put(predefined.getValue(), this.m_TypeColorProvider.next());
            }
            for (AbstractField field : report.getFields()) {
                if (!field.getName().endsWith(this.m_TypeSuffix)) continue;
                types.add("" + report.getValue(field));
            }
            for (String t : types) {
                if (this.m_TypeColors.containsKey(t)) continue;
                this.m_TypeColors.put(t, this.m_TypeColorProvider.next());
            }
        }
        this.m_ObjectLocationMappings = new HashMap();
        this.m_Locations = new ArrayList();
        this.m_AllObjects = new LocatedObjects();
        this.m_FilteredObjects = new LocatedObjects();
        this.m_Colors = new HashMap();
        this.m_Labels = new HashMap();
        String suffix = this.determineTypeSuffix();
        LocatedObjects result = LocatedObjects.fromReport(report, this.m_Prefix);
        for (LocatedObject object : result) {
            String label;
            Polygon poly = null;
            if (object.hasPolygon()) {
                poly = object.getPolygon();
            }
            int[] bbox_x = new int[]{object.getX(), object.getX() + object.getWidth() - 1, object.getX() + object.getWidth() - 1, object.getX()};
            int[] bbox_y = new int[]{object.getY(), object.getY(), object.getY() + object.getHeight() - 1, object.getY() + object.getHeight() - 1};
            Polygon bbox = new Polygon(bbox_x, bbox_y, bbox_x.length);
            if (poly == null) {
                poly = bbox;
            }
            Color color = this.m_Color;
            if (!suffix.isEmpty() && object.getMetaData() != null && object.getMetaData().containsKey(suffix)) {
                String type = "" + object.getMetaData().get(suffix);
                if (!this.m_TypeRegExp.isMatchAll() && !this.m_TypeRegExp.isMatch(type)) continue;
                if (this.m_UseColorsPerType && this.m_TypeColors.containsKey(type)) {
                    color = (Color)this.m_TypeColors.get(type);
                }
                if (!this.m_LabelFormat.isEmpty()) {
                    label = this.applyLabelFormat(object, type);
                    this.m_Labels.put(poly, label);
                }
            } else if (!this.m_LabelFormat.isEmpty()) {
                label = this.applyLabelFormat(object, "");
                this.m_Labels.put(poly, label);
            }
            this.m_AllObjects.add(object);
            if (!filter.accept(object)) continue;
            this.m_FilteredObjects.add(object);
            this.m_Colors.put(poly, color);
            this.m_Locations.add(poly);
            this.m_ObjectLocationMappings.put(object, poly);
        }
        return true;
    }
}

