/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.leftclick;

import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.leftclick.AbstractLeftClickProcessor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;

public class ViewObjects
extends AbstractLeftClickProcessor {
    private static final long serialVersionUID = -5747047661002140048L;
    protected BaseString[] m_Prefixes;

    public String globalInfo() {
        return "Displays the annotated objects in a dialog that contain the click position.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefixes", (Object)this.getDefaultPrefixes());
    }

    protected BaseString[] getDefaultPrefixes() {
        return new BaseString[]{new BaseString("Object.")};
    }

    public void setPrefixes(BaseString[] value) {
        this.m_Prefixes = value;
        this.reset();
    }

    public BaseString[] getPrefixes() {
        return this.m_Prefixes;
    }

    public String prefixesTipText() {
        return "The prefix(es) to use for the fields in the report of the image.";
    }

    protected void doProcessClick(ImagePanel panel, Point position, int modifiersEx) {
        LocatedObjects objects = LocatedObjects.fromReport(panel.getAllProperties(), BaseObject.toStringArray((BaseObject[])this.m_Prefixes));
        LocatedObjects hits = new LocatedObjects();
        Point location = panel.mouseToPixelLocation(position);
        for (LocatedObject object : objects) {
            boolean add = object.hasPolygon() ? object.getActualPolygon().contains(location) : object.getActualRectangle().contains(location);
            if (!add) continue;
            hits.add(object);
        }
        if (hits.size() > 0) {
            SpreadSheet sheet = null;
            for (LocatedObject hit : hits) {
                SpreadSheet sheetHit = hit.toSpreadSheet();
                if (sheet == null) {
                    sheet = sheetHit;
                    continue;
                }
                sheet.addRow().assign((Row)sheetHit.getRow(0));
            }
            SpreadSheetDialog dialog = panel.getParentDialog() != null ? new SpreadSheetDialog(panel.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(panel.getParentFrame(), false);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Objects");
            dialog.setSize(GUIHelper.getDefaultDialogDimension());
            dialog.setLocationRelativeTo((Component)panel);
            dialog.setSpreadSheet(sheet);
            dialog.setShowSearch(true);
            dialog.setVisible(true);
        }
    }
}

