/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object;

import adams.data.RoundingUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.io.output.AbstractImageWriter;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.visualization.image.interactionlogging.InteractionEvent;
import adams.gui.visualization.image.interactionlogging.InteractionLogManager;
import adams.gui.visualization.image.interactionlogging.InteractionLoggingFilter;
import adams.gui.visualization.image.interactionlogging.Null;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.PopupMenuCustomizer;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;

public class CanvasPanel
extends BasePanel {
    private static final long serialVersionUID = 276009384422635395L;
    protected ObjectAnnotationPanel m_Owner;
    protected BufferedImage m_Image;
    protected boolean m_BestFit;
    protected double m_Zoom;
    protected double m_ActualZoom;
    protected float m_Brightness;
    protected Float m_LastBrightness;
    protected BufferedImage m_BrightImage;
    protected boolean m_ResizeRequired;
    protected boolean m_FirstDisplay;
    protected InteractionLoggingFilter m_InteractionLoggingFilter;
    protected PopupMenuCustomizer m_PopupMenuCustomizer;
    protected ImageFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        this.m_Owner = null;
        this.m_Image = null;
        this.m_BestFit = false;
        this.m_Zoom = 1.0;
        this.m_ActualZoom = 1.0;
        this.m_Brightness = 100.0f;
        this.m_ResizeRequired = false;
        this.m_FirstDisplay = true;
        this.m_FileChooser = null;
        this.m_InteractionLoggingFilter = new Null();
        this.m_PopupMenuCustomizer = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.addMouseWheelListener(e -> {
            double oldZoom = this.m_Owner.getActualZoom();
            int rotation = e.getWheelRotation();
            double newZoom = rotation < 0 ? oldZoom * Math.pow(1.4, -rotation) : oldZoom / Math.pow(1.4, rotation);
            newZoom = RoundingUtils.round((double)newZoom, (int)3);
            this.logMouseWheel(e, oldZoom, newZoom);
            this.getOwner().setZoom(newZoom);
            this.update();
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                CanvasPanel.this.getOwner().updateStatus(e.getPoint());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick((MouseEvent)e) && MouseUtils.hasNoModifierKey((MouseEvent)e)) {
                    JPopupMenu menu = CanvasPanel.this.createPopupMenu();
                    menu.show((Component)((Object)CanvasPanel.this), e.getX(), e.getY());
                }
            }
        });
    }

    public void setOwner(ObjectAnnotationPanel value) {
        this.m_Owner = value;
    }

    public ObjectAnnotationPanel getOwner() {
        return this.m_Owner;
    }

    public void setBestFit(boolean value) {
        this.m_BestFit = value;
        this.getOwner().updateStatus();
    }

    public boolean getBestFit() {
        return this.m_BestFit;
    }

    public void setZoom(double value) {
        this.m_Zoom = value;
        this.m_ActualZoom = value;
        this.m_BestFit = false;
        this.logScale(value);
        this.getOwner().updateStatus();
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public double getActualZoom() {
        return this.m_ActualZoom;
    }

    public void setBrightness(float value) {
        this.m_Brightness = value;
    }

    public float getBrightness() {
        return this.m_Brightness;
    }

    public void setImage(BufferedImage value) {
        this.m_Image = value;
        this.m_BrightImage = null;
    }

    public BufferedImage getImage() {
        return this.m_Image;
    }

    public void setInteractionLoggingFilter(InteractionLoggingFilter value) {
        this.m_InteractionLoggingFilter = value;
    }

    public InteractionLoggingFilter getInteractionLoggingFilter() {
        return this.m_InteractionLoggingFilter;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_PopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this.m_PopupMenuCustomizer;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon((String)"copy.gif"));
        menuitem.setEnabled(this.m_Image != null);
        menuitem.addActionListener(e -> this.copyToClipboard());
        result.add(menuitem);
        menuitem = new JMenuItem("Save as...", GUIHelper.getIcon((String)"save.gif"));
        menuitem.setEnabled(this.m_Image != null);
        menuitem.addActionListener(e -> this.saveAs());
        result.add(menuitem);
        if (this.m_PopupMenuCustomizer != null) {
            this.m_PopupMenuCustomizer.customizePopupMenu((Object)this, result);
        }
        return result;
    }

    public void copyToClipboard() {
        if (this.m_Image == null) {
            return;
        }
        ClipboardHelper.copyToClipboard((JComponent)((Object)this));
    }

    public void saveAs() {
        int retVal;
        if (this.m_Image == null) {
            return;
        }
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new ImageFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog((Component)this.getParent())) != 0) {
            return;
        }
        int width = (int)((double)this.m_Image.getWidth() * this.getActualZoom());
        int height = (int)((double)this.m_Image.getHeight() * this.getActualZoom());
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)BufferedImageHelper.toBufferedImage((JComponent)((Object)this), (Color)this.getBackground(), (int)width, (int)height));
        AbstractImageWriter writer = this.m_FileChooser.getImageWriter();
        String msg = writer.write(this.m_FileChooser.getSelectedPlaceholderFile(), (AbstractImageContainer)cont);
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)this.getParent(), (String)msg);
        }
    }

    public void update() {
        this.update(false);
    }

    public void update(boolean doLayout) {
        if (this.m_Image != null) {
            int height;
            int width;
            boolean bl = this.m_ResizeRequired = this.m_FirstDisplay || this.m_BestFit && this.getOwner().getScrollPane().getWidth() == 0;
            if (this.m_BestFit && this.getOwner().getScrollPane().getWidth() > 0) {
                width = this.getOwner().getScrollPane().getWidth() - 20;
                height = this.getOwner().getScrollPane().getHeight() - 20;
                double zoomW = (double)width / (double)this.m_Image.getWidth();
                double zoomH = (double)height / (double)this.m_Image.getHeight();
                this.m_ActualZoom = Math.min(zoomW, zoomH);
            } else {
                this.m_ActualZoom = this.m_Zoom;
            }
            width = (int)((double)this.m_Image.getWidth() * this.m_ActualZoom);
            height = (int)((double)this.m_Image.getHeight() * this.m_ActualZoom);
            if (width != this.getWidth() || height != this.getHeight()) {
                this.setSize(new Dimension(width, height));
                this.setMinimumSize(new Dimension(width, height));
                this.setPreferredSize(new Dimension(width, height));
                JScrollBar sbHor = this.getOwner().getScrollPane().getHorizontalScrollBar();
                sbHor.setUnitIncrement(width / 25);
                sbHor.setBlockIncrement(width / 10);
                JScrollBar sbVer = this.getOwner().getScrollPane().getVerticalScrollBar();
                sbVer.setUnitIncrement(height / 25);
                sbVer.setBlockIncrement(height / 10);
                doLayout = true;
            }
        }
        if (doLayout) {
            this.m_Owner.invalidate();
            this.m_Owner.revalidate();
            this.m_Owner.doLayout();
        }
        this.m_Owner.repaint();
    }

    public Point mouseToPixelLocation(Point mousePos) {
        int y;
        int x = (int)(mousePos.getX() / this.m_ActualZoom);
        if (x < 0) {
            x = 0;
        }
        if ((y = (int)(mousePos.getY() / this.m_ActualZoom)) < 0) {
            y = 0;
        }
        if (this.m_Image != null) {
            if (x > this.m_Image.getWidth()) {
                x = this.m_Image.getWidth();
            }
            if (y > this.m_Image.getHeight()) {
                y = this.m_Image.getHeight();
            }
        }
        return new Point(x, y);
    }

    public Point pixelToMouseLocation(Point pixelPos) {
        int x = (int)((double)pixelPos.x * this.m_ActualZoom);
        int y = (int)((double)pixelPos.y * this.m_ActualZoom);
        return new Point(x, y);
    }

    public void logMouseButtonPressed(MouseEvent e) {
        if (this.getOwner() == null) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("x", e.getX());
        data.put("y", e.getY());
        data.put("modifiers", MouseUtils.modifiersToStr((MouseEvent)e));
        if (MouseUtils.isLeftClick((MouseEvent)e)) {
            this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "left-pressed", data));
        } else if (MouseUtils.isMiddleClick((MouseEvent)e)) {
            data.put("scale", 1.0);
            this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "middle-pressed", data));
        } else if (MouseUtils.isRightClick((MouseEvent)e)) {
            this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "right-pressed", data));
        }
    }

    public void logMouseButtonClick(MouseEvent e) {
        if (this.getOwner() == null) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("x", e.getX());
        data.put("y", e.getY());
        data.put("modifiers", MouseUtils.modifiersToStr((MouseEvent)e));
        if (MouseUtils.isLeftClick((MouseEvent)e)) {
            this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "left-click", data));
        } else if (MouseUtils.isMiddleClick((MouseEvent)e)) {
            data.put("scale", 1.0);
            this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "middle-click", data));
        } else if (MouseUtils.isRightClick((MouseEvent)e)) {
            this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "right-click", data));
        }
    }

    public void logMouseButtonReleased(MouseEvent e) {
        if (this.getOwner() == null) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("x", e.getX());
        data.put("y", e.getY());
        data.put("modifiers", MouseUtils.modifiersToStr((MouseEvent)e));
        if (MouseUtils.isLeftClick((MouseEvent)e)) {
            this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "left-released", data));
        } else if (MouseUtils.isMiddleClick((MouseEvent)e)) {
            data.put("scale", 1.0);
            this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "middle-released", data));
        } else if (MouseUtils.isRightClick((MouseEvent)e)) {
            this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "right-released", data));
        }
    }

    public void logMouseWheel(MouseWheelEvent e, double oldZoom, double newZoom) {
        if (this.getOwner() == null) {
            return;
        }
        HashMap<String, Number> data = new HashMap<String, Number>();
        data.put("x", e.getX());
        data.put("y", e.getY());
        data.put("rotation", e.getWheelRotation());
        data.put("oldScale", oldZoom);
        data.put("newScale", newZoom);
        this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "mouse-wheel", data));
    }

    public void logScale(double newScale) {
        if (this.getOwner() == null) {
            return;
        }
        HashMap<String, Double> data = new HashMap<String, Double>();
        data.put("newScale", newScale);
        this.m_InteractionLoggingFilter.filterInteractionLog(new InteractionEvent((InteractionLogManager)this.getOwner(), new Date(), "zoom", data));
    }

    public void paint(Graphics g) {
        if (this.m_ResizeRequired) {
            this.m_ResizeRequired = false;
            this.m_FirstDisplay = false;
            this.getOwner().bestFitZoom();
            return;
        }
        ((Graphics2D)g).scale(1.0, 1.0);
        g.setColor(this.getOwner().getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.m_Image != null) {
            ((Graphics2D)g).scale(this.m_ActualZoom, this.m_ActualZoom);
            if (this.m_BrightImage == null || this.m_LastBrightness == null || this.m_LastBrightness.floatValue() != this.m_Brightness) {
                RescaleOp op = new RescaleOp(this.m_Brightness / 100.0f, 0.0f, null);
                this.m_BrightImage = new BufferedImage(this.m_Image.getWidth(), this.m_Image.getHeight(), this.m_Image.getType());
                BufferedImage image = this.m_Image;
                if (this.m_Image.getType() == 13) {
                    image = BufferedImageHelper.convert((BufferedImage)this.m_Image, (int)2);
                }
                this.m_BrightImage = op.filter(image, this.m_BrightImage);
                this.m_LastBrightness = Float.valueOf(this.m_Brightness);
            }
            g.drawImage(this.m_BrightImage, 0, 0, this.getOwner().getBackground(), null);
        }
        this.getOwner().getOverlay().paint(this.getOwner(), g);
        this.getOwner().getAnnotator().paintSelection(g);
    }
}

