/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object;

import adams.core.CleanUpHandler;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.RoundingUtils;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.report.Report;
import adams.env.Environment;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.CheckedTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.core.Undo;
import adams.gui.core.UndoHandlerWithQuickAccess;
import adams.gui.event.UndoEvent;
import adams.gui.event.UndoListener;
import adams.gui.visualization.image.interactionlogging.InteractionEvent;
import adams.gui.visualization.image.interactionlogging.InteractionLogManager;
import adams.gui.visualization.image.interactionlogging.InteractionLoggingFilter;
import adams.gui.visualization.object.CanvasPanel;
import adams.gui.visualization.object.annotationsdisplay.AbstractAnnotationsDisplayPanel;
import adams.gui.visualization.object.annotationsdisplay.DefaultAnnotationsDisplayGenerator;
import adams.gui.visualization.object.annotator.AbstractAnnotator;
import adams.gui.visualization.object.annotator.BoundingBoxAnnotator;
import adams.gui.visualization.object.annotator.NullAnnotator;
import adams.gui.visualization.object.labelselector.AbstractLabelSelectorPanel;
import adams.gui.visualization.object.labelselector.ButtonSelectorGenerator;
import adams.gui.visualization.object.mouseclick.AbstractMouseClickProcessor;
import adams.gui.visualization.object.mouseclick.AddMetaData;
import adams.gui.visualization.object.mouseclick.MultiProcessor;
import adams.gui.visualization.object.mouseclick.NullProcessor;
import adams.gui.visualization.object.mouseclick.SetLabel;
import adams.gui.visualization.object.mouseclick.ViewObjects;
import adams.gui.visualization.object.overlay.AbstractOverlay;
import adams.gui.visualization.object.overlay.NullOverlay;
import adams.gui.visualization.object.overlay.ObjectLocationsOverlayFromReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ObjectAnnotationPanel
extends BasePanel
implements CleanUpHandler,
UndoHandlerWithQuickAccess,
UndoListener,
InteractionLogManager {
    private static final long serialVersionUID = 2804494506168717754L;
    public static final double ZOOM_FACTOR = 1.4;
    protected JPanel m_PanelZoom;
    protected NumberTextField m_TextZoom;
    protected BaseFlatButton m_ButtonZoomClear;
    protected BaseFlatButton m_ButtonZoomIn;
    protected BaseFlatButton m_ButtonZoomOut;
    protected BaseFlatButton m_ButtonZoomBestFit;
    protected BaseFlatButton m_ButtonZoom;
    protected JPanel m_PanelUndo;
    protected BaseFlatButton m_ButtonUndo;
    protected BaseFlatButton m_ButtonRedo;
    protected JPanel m_PanelBrightness;
    protected NumberTextField m_TextBrightness;
    protected BaseFlatButton m_ButtonBrightness;
    protected JPanel m_PanelUsePreviousReport;
    protected BaseFlatButton m_ButtonUsePreviousReport;
    protected BaseSplitPane m_SplitPaneLeft;
    protected BaseSplitPane m_SplitPaneRight;
    protected AbstractLabelSelectorPanel m_PanelLabelSelector;
    protected CanvasPanel m_PanelCanvas;
    protected BaseScrollPane m_ScrollPane;
    protected AbstractAnnotationsDisplayPanel m_PanelAnnotations;
    protected BaseStatusBar m_StatusBar;
    protected AbstractOverlay m_Overlay;
    protected AbstractMouseClickProcessor m_MouseClickProcessor;
    protected AbstractAnnotator m_Annotator;
    protected Undo m_Undo;
    protected String m_CurrentLabel;
    protected List<InteractionEvent> m_InteractionLog;
    protected Report m_PreviousReport;

    protected void initialize() {
        super.initialize();
        this.m_Overlay = new NullOverlay();
        this.m_MouseClickProcessor = new NullProcessor();
        this.m_PanelLabelSelector = null;
        this.m_CurrentLabel = null;
        this.m_InteractionLog = null;
        this.m_PreviousReport = null;
        this.m_Undo = new Undo(List.class, false);
        this.m_Undo.addUndoListener((UndoListener)this);
        this.setAnnotator(new NullAnnotator());
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        this.add(panel, "North");
        this.m_PanelZoom = new JPanel(new FlowLayout(0));
        panel.add(this.m_PanelZoom);
        this.m_TextZoom = new NumberTextField(NumberTextField.Type.DOUBLE, "100");
        this.m_TextZoom.setColumns(5);
        this.m_TextZoom.setToolTipText("100 = original image size");
        this.m_TextZoom.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.DOUBLE, (Number)1.0, null));
        this.m_TextZoom.addAnyChangeListener(e -> this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate_blue.png")));
        JLabel label = new JLabel("Zoom");
        label.setDisplayedMnemonic('Z');
        label.setLabelFor((Component)this.m_TextZoom);
        this.m_PanelZoom.add(label);
        this.m_PanelZoom.add((Component)this.m_TextZoom);
        this.m_ButtonZoom = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.m_ButtonZoom.setToolTipText("Apply zoom");
        this.m_ButtonZoom.addActionListener(e -> {
            this.setZoom(this.m_TextZoom.getValue().doubleValue() / 100.0);
            this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
            this.update();
        });
        this.m_PanelZoom.add((Component)this.m_ButtonZoom);
        this.m_PanelZoom.add(new JLabel(" "));
        this.m_ButtonZoomClear = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"zoom_clear.png"));
        this.m_ButtonZoomClear.setToolTipText("Clear zoom");
        this.m_ButtonZoomClear.addActionListener(e -> this.clearZoom());
        this.m_PanelZoom.add((Component)this.m_ButtonZoomClear);
        this.m_ButtonZoomIn = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"zoom_in.png"));
        this.m_ButtonZoomIn.setToolTipText("Zoom in");
        this.m_ButtonZoomIn.addActionListener(e -> this.zoomIn());
        this.m_PanelZoom.add((Component)this.m_ButtonZoomIn);
        this.m_ButtonZoomOut = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"zoom_out.png"));
        this.m_ButtonZoomOut.setToolTipText("Zoom out");
        this.m_ButtonZoomOut.addActionListener(e -> this.zoomOut());
        this.m_PanelZoom.add((Component)this.m_ButtonZoomOut);
        this.m_ButtonZoomBestFit = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"zoom_fit.png"));
        this.m_ButtonZoomBestFit.setToolTipText("Best fit");
        this.m_ButtonZoomBestFit.addActionListener(e -> this.bestFitZoom());
        this.m_PanelZoom.add((Component)this.m_ButtonZoomBestFit);
        this.m_PanelUndo = new JPanel(new FlowLayout(0));
        panel.add(this.m_PanelUndo);
        this.m_PanelUndo.add(new JLabel(" "));
        this.m_ButtonUndo = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"undo.gif"));
        this.m_ButtonUndo.setToolTipText("Undo changes");
        this.m_ButtonUndo.addActionListener(e -> this.undo());
        this.m_PanelUndo.add((Component)this.m_ButtonUndo);
        this.m_ButtonRedo = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"redo.gif"));
        this.m_ButtonRedo.setToolTipText("Redo changes");
        this.m_ButtonRedo.addActionListener(e -> this.redo());
        this.m_PanelUndo.add((Component)this.m_ButtonRedo);
        this.m_PanelBrightness = new JPanel(new FlowLayout(0));
        panel.add(this.m_PanelBrightness);
        this.m_PanelBrightness.add(new JLabel(" "));
        this.m_PanelBrightness.add(new JLabel("Brightness"));
        this.m_TextBrightness = new NumberTextField(NumberTextField.Type.DOUBLE, "100");
        this.m_TextBrightness.setColumns(5);
        this.m_TextBrightness.setToolTipText("100 = original brightness");
        this.m_TextBrightness.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.DOUBLE, (Number)1.0, null));
        this.m_TextBrightness.addAnyChangeListener(e -> this.m_ButtonBrightness.setIcon((Icon)GUIHelper.getIcon((String)"validate_blue.png")));
        this.m_PanelBrightness.add((Component)this.m_TextBrightness);
        this.m_ButtonBrightness = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.m_ButtonBrightness.setToolTipText("Apply current values");
        this.m_ButtonBrightness.addActionListener(e -> {
            this.m_PanelCanvas.setBrightness(this.m_TextBrightness.getValue().floatValue());
            this.m_ButtonBrightness.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
            this.update();
        });
        this.m_PanelBrightness.add((Component)this.m_ButtonBrightness);
        this.m_PanelUsePreviousReport = new JPanel(new FlowLayout(0));
        panel.add(this.m_PanelUsePreviousReport);
        this.m_PanelUsePreviousReport.add(new JLabel(" "));
        this.m_ButtonUsePreviousReport = new BaseFlatButton("Apply previous report");
        this.m_ButtonUsePreviousReport.setToolTipText("Apply previous report");
        this.m_ButtonUsePreviousReport.addActionListener(e -> {
            this.applyPreviousReport();
            this.update();
        });
        this.m_PanelUsePreviousReport.add((Component)this.m_ButtonUsePreviousReport);
        this.m_PanelUsePreviousReport.setVisible(false);
        this.m_SplitPaneLeft = new BaseSplitPane();
        this.m_SplitPaneLeft.setOneTouchExpandable(true);
        this.m_SplitPaneLeft.setResizeWeight(0.0);
        this.add((Component)this.m_SplitPaneLeft, "Center");
        this.m_SplitPaneRight = new BaseSplitPane();
        this.m_SplitPaneRight.setOneTouchExpandable(true);
        this.m_SplitPaneRight.setResizeWeight(1.0);
        this.m_SplitPaneLeft.setRightComponent((Component)this.m_SplitPaneRight);
        this.m_PanelCanvas = new CanvasPanel();
        this.m_PanelCanvas.setOwner(this);
        this.m_PanelCanvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ObjectAnnotationPanel.this.m_MouseClickProcessor.process(ObjectAnnotationPanel.this, e);
            }
        });
        this.m_ScrollPane = new BaseScrollPane((Component)((Object)this.m_PanelCanvas));
        this.m_SplitPaneRight.setLeftComponent((Component)this.m_ScrollPane);
        this.m_PanelAnnotations = new DefaultAnnotationsDisplayGenerator().generate();
        this.m_PanelAnnotations.setOwner(this);
        this.m_SplitPaneRight.setRightComponent((Component)((Object)this.m_PanelAnnotations));
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
    }

    protected void finishInit() {
        super.finishInit();
        this.setLeftDividerLocation(0.2);
        this.setRightDividerLocation(0.75);
    }

    public void setZoomVisible(boolean value) {
        this.m_PanelZoom.setVisible(value);
    }

    public boolean isZoomVisible() {
        return this.m_PanelZoom.isVisible();
    }

    public void setUndoVisible(boolean value) {
        this.m_PanelUndo.setVisible(value);
    }

    public boolean isUndoVisible() {
        return this.m_PanelUndo.isVisible();
    }

    public void setBrightnessVisible(boolean value) {
        this.m_PanelBrightness.setVisible(value);
    }

    public boolean isBrightnessVisible() {
        return this.m_PanelBrightness.isVisible();
    }

    public void setUsePreviousReportVisible(boolean value) {
        this.m_PanelUsePreviousReport.setVisible(value);
    }

    public boolean isUsePreviousReportVisible() {
        return this.m_PanelUsePreviousReport.isVisible();
    }

    public void setBestFit(boolean value) {
        this.m_PanelCanvas.setBestFit(value);
    }

    public boolean getBestFit() {
        return this.m_PanelCanvas.getBestFit();
    }

    public void setZoom(double value) {
        this.m_TextZoom.setValue((Number)RoundingUtils.round((double)(value * 100.0), (int)1));
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.m_PanelCanvas.setZoom(value);
    }

    public double getZoom() {
        return this.m_PanelCanvas.getZoom();
    }

    public double getActualZoom() {
        return this.m_PanelCanvas.getActualZoom();
    }

    public void clearZoom() {
        this.m_TextZoom.setValue((Number)100);
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.setZoom(1.0);
        this.update();
    }

    public void zoomIn() {
        this.m_TextZoom.setValue((Number)RoundingUtils.round((double)(this.m_TextZoom.getValue().doubleValue() * 1.4), (int)1));
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.setZoom(this.m_TextZoom.getValue().doubleValue() / 100.0);
        this.update();
    }

    public void zoomOut() {
        this.m_TextZoom.setValue((Number)RoundingUtils.round((double)(this.m_TextZoom.getValue().doubleValue() / 1.4), (int)1));
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.setZoom(this.m_TextZoom.getValue().doubleValue() / 100.0);
        this.update();
    }

    public void bestFitZoom() {
        this.setBestFit(true);
        this.update();
        this.m_TextZoom.setValue((Number)RoundingUtils.round((double)(this.getActualZoom() * 100.0), (int)1));
        this.m_ButtonZoom.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        this.setBestFit(true);
    }

    public void clear() {
        this.setCurrentLabel(null);
        this.setImage(null);
        this.setReport(new Report());
        this.annotationsChanged((Object)this);
        this.labelChanged((Object)this);
        this.clearInteractionLog();
        this.m_Undo.clear();
    }

    public void setImage(BufferedImage value) {
        this.m_PanelCanvas.setImage(value);
    }

    public BufferedImage getImage() {
        return this.m_PanelCanvas.getImage();
    }

    public void setReport(Report value) {
        this.m_PanelAnnotations.setReport(value);
    }

    public Report getReport() {
        return this.m_PanelAnnotations.getReport();
    }

    public void setPreviousReport(Report value) {
        this.m_PreviousReport = value;
    }

    public Report getPreviousReport() {
        return this.m_PreviousReport;
    }

    protected void applyPreviousReport() {
        if (this.m_PreviousReport == null) {
            return;
        }
        this.addUndoPoint("Applying previous report");
        Report report = this.getReport().getClone();
        report.removeValuesStartingWith(this.m_PanelAnnotations.getPrefix());
        report.mergeWith(this.m_PreviousReport);
        this.setReport(report);
        this.annotationsChanged((Object)this);
    }

    public void setObjects(LocatedObjects value) {
        this.m_PanelAnnotations.setObjects(value);
    }

    public LocatedObjects getObjects() {
        return this.m_PanelAnnotations.getObjects();
    }

    public void setBrightness(float value) {
        this.m_TextBrightness.setValue((Number)Float.valueOf(value));
        this.m_ButtonBrightness.doClick();
    }

    public float getBrightness() {
        return this.m_TextBrightness.getValue().floatValue();
    }

    public void setUndo(Undo value) {
        if (this.m_Undo != null) {
            this.m_Undo.removeUndoListener((UndoListener)this);
        }
        this.m_Undo = value;
        this.m_Undo.addUndoListener((UndoListener)this);
    }

    public Undo getUndo() {
        return this.m_Undo;
    }

    public boolean isUndoSupported() {
        return this.m_Undo != null;
    }

    public void undo() {
        if (!this.getUndo().canUndo()) {
            return;
        }
        this.getUndo().undo();
    }

    public void redo() {
        if (!this.getUndo().canRedo()) {
            return;
        }
        this.getUndo().redo();
    }

    public AnnotationsState getState() {
        AnnotationsState result = new AnnotationsState();
        result.report = this.getReport();
        return result;
    }

    public void setState(AnnotationsState state) {
        if (state.report != null) {
            this.setReport(state.report);
        }
    }

    public void addUndoPoint(String comment) {
        if (this.isUndoSupported() && this.getUndo().isEnabled()) {
            this.getUndo().addUndo((Object)this.getState(), comment);
        }
    }

    public void undoOccurred(UndoEvent e) {
        switch (e.getType()) {
            case UNDO: {
                this.getUndo().addRedo((Object)this.getState(), e.getUndoPoint().getComment());
                this.setState((AnnotationsState)e.getUndoPoint().getData());
                this.annotationsChanged((Object)this);
                break;
            }
            case REDO: {
                this.getUndo().addUndo((Object)this.getState(), e.getUndoPoint().getComment(), true);
                this.setState((AnnotationsState)e.getUndoPoint().getData());
                this.annotationsChanged((Object)this);
            }
        }
    }

    public void preselectCurrentLabel(String label) {
        if (this.m_PanelLabelSelector != null) {
            this.m_PanelLabelSelector.preselectCurrentLabel(label);
        }
    }

    public void setCurrentLabel(String value) {
        this.m_CurrentLabel = value;
    }

    public String getCurrentLabel() {
        return this.m_CurrentLabel;
    }

    public void setLabelSelectorPanel(AbstractLabelSelectorPanel value) {
        this.m_PanelLabelSelector = value;
        if (this.m_SplitPaneLeft.getLeftComponent() != null) {
            this.m_SplitPaneLeft.remove(this.m_SplitPaneLeft.getLeftComponent());
        }
        if (value == null) {
            this.m_SplitPaneLeft.setLeftComponentHidden(true);
        } else {
            value.setOwner(this);
            this.m_SplitPaneLeft.setLeftComponent((Component)((Object)value));
        }
    }

    public AbstractLabelSelectorPanel getLabelSelectorPanel() {
        return (AbstractLabelSelectorPanel)((Object)this.m_SplitPaneLeft.getLeftComponent());
    }

    public void setAnnotationsPanel(AbstractAnnotationsDisplayPanel value) {
        this.m_PanelAnnotations.cleanUp();
        this.m_PanelAnnotations = value;
        this.m_SplitPaneRight.setRightComponent((Component)((Object)this.m_PanelAnnotations));
    }

    public AbstractAnnotationsDisplayPanel getAnnotationsPanel() {
        return this.m_PanelAnnotations;
    }

    public BaseScrollPane getScrollPane() {
        return this.m_ScrollPane;
    }

    public CanvasPanel getCanvas() {
        return this.m_PanelCanvas;
    }

    public void setLeftDividerLocation(int value) {
        this.m_SplitPaneLeft.setDividerLocation(value);
    }

    public void setLeftDividerLocation(double value) {
        this.m_SplitPaneLeft.setDividerLocation(value);
    }

    public int getLeftDividerLocation() {
        return this.m_SplitPaneLeft.getDividerLocation();
    }

    public void setRightDividerLocation(int value) {
        this.m_SplitPaneRight.setDividerLocation(value);
    }

    public void setRightDividerLocation(double value) {
        this.m_SplitPaneRight.setDividerLocation(value);
    }

    public int getRightDividerLocation() {
        return this.m_SplitPaneRight.getDividerLocation();
    }

    public void setOverlay(AbstractOverlay value) {
        this.m_Overlay = value;
    }

    public AbstractOverlay getOverlay() {
        return this.m_Overlay;
    }

    public void setMouseClickProcessor(AbstractMouseClickProcessor value) {
        this.m_MouseClickProcessor = value;
    }

    public AbstractMouseClickProcessor getMouseClickProcessor() {
        return this.m_MouseClickProcessor;
    }

    public void annotationsChanged(Object source) {
        if (source != this.m_Overlay) {
            this.m_Overlay.annotationsChanged();
        }
        if (source != this.m_Annotator) {
            this.m_Annotator.annotationsChanged();
        }
        this.update();
    }

    public void labelChanged(Object source) {
        if (this.m_PanelLabelSelector != null && source != this.m_PanelLabelSelector) {
            this.m_PanelLabelSelector.setCurrentLabel(this.m_CurrentLabel);
        }
        if (this.m_Annotator != null && source != this.m_Annotator) {
            this.m_Annotator.labelChanged();
        }
        this.update();
    }

    public void setAnnotator(AbstractAnnotator value) {
        if (this.m_Annotator != null) {
            this.m_Annotator.uninstall();
        }
        this.m_Annotator = value;
        this.m_Annotator.setOwner(this);
        this.m_Annotator.install();
    }

    public AbstractAnnotator getAnnotator() {
        return this.m_Annotator;
    }

    public void updateStatus() {
        Point pos = this.getMousePosition();
        if (pos != null) {
            this.updateStatus(pos.getLocation());
        }
    }

    public void updateStatus(Point pos) {
        Point loc = this.mouseToPixelLocation(pos);
        this.showStatus("X: " + (int)(loc.getX() + 1.0) + "   Y: " + (int)(loc.getY() + 1.0) + "   Zoom: " + Utils.doubleToString((double)(this.getZoom() * 100.0), (int)1) + "%");
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public void updateButtons() {
        this.m_ButtonUndo.setEnabled(this.getUndo().canUndo());
        this.m_ButtonRedo.setEnabled(this.getUndo().canRedo());
        this.m_ButtonUsePreviousReport.setEnabled(this.m_PreviousReport != null);
    }

    public void update() {
        this.updateButtons();
        this.updateStatus();
        this.m_PanelCanvas.update();
    }

    public void update(boolean doLayout) {
        this.m_PanelCanvas.update(doLayout);
    }

    public Point mouseToPixelLocation(Point mousePos) {
        return this.m_PanelCanvas.mouseToPixelLocation(mousePos);
    }

    public Point pixelToMouseLocation(Point pixelPos) {
        return this.m_PanelCanvas.pixelToMouseLocation(pixelPos);
    }

    public void setInteractionLoggingFilter(InteractionLoggingFilter value) {
        this.m_PanelCanvas.setInteractionLoggingFilter(value);
    }

    public InteractionLoggingFilter getInteractionLoggingFilter() {
        return this.m_PanelCanvas.getInteractionLoggingFilter();
    }

    public void clearInteractionLog() {
        this.m_InteractionLog = null;
    }

    public void addInteractionLog(InteractionEvent e) {
        if (this.m_InteractionLog == null) {
            this.m_InteractionLog = new ArrayList<InteractionEvent>();
        }
        this.m_InteractionLog.add(e);
    }

    public boolean hasInteractionLog() {
        return this.m_InteractionLog != null;
    }

    public List<InteractionEvent> getInteractionLog() {
        return this.m_InteractionLog;
    }

    public void cleanUp() {
        if (this.m_PanelAnnotations != null) {
            this.m_PanelAnnotations.cleanUp();
        }
        if (this.m_Overlay != null) {
            this.m_Overlay.cleanUp();
        }
    }

    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        ObjectAnnotationPanel panel = new ObjectAnnotationPanel();
        File img = new File(args[0]);
        panel.setImage((BufferedImage)BufferedImageHelper.read((File)img).getImage());
        panel.setBestFit(true);
        ButtonSelectorGenerator labelGen = new ButtonSelectorGenerator();
        labelGen.setLabels(new BaseString[]{new BaseString("Car"), new BaseString("Bike")});
        panel.setLabelSelectorPanel(labelGen.generate(panel));
        panel.setAnnotator(new BoundingBoxAnnotator());
        panel.setOverlay(new ObjectLocationsOverlayFromReport());
        MultiProcessor multiproc = new MultiProcessor();
        multiproc.addProcessor(new SetLabel());
        ViewObjects view = new ViewObjects();
        view.setShiftDown(true);
        multiproc.addProcessor(view);
        AddMetaData add = new AddMetaData();
        add.setShiftDown(true);
        add.setCtrlDown(true);
        multiproc.addProcessor(add);
        panel.setMouseClickProcessor(multiproc);
        DefaultSimpleReportReader reader = new DefaultSimpleReportReader();
        reader.setInput(new PlaceholderFile(args[1]));
        List reports = reader.read();
        panel.setReport((Report)reports.get(0));
        BaseFrame frame = new BaseFrame("Object annotations");
        frame.setDefaultCloseOperation(3);
        frame.setSize(GUIHelper.makeWider((Dimension)GUIHelper.getDefaultLargeDialogDimension()));
        frame.setLocationRelativeTo(null);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)panel), "Center");
        frame.setVisible(true);
        panel.setLeftDividerLocation(0.1);
        panel.setRightDividerLocation(0.75);
        panel.update();
    }

    public static class AnnotationsState
    implements Serializable {
        private static final long serialVersionUID = -578329279093068996L;
        public Report report;
    }
}

