/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.annotator;

import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.gui.visualization.image.SelectionRectangle;
import adams.gui.visualization.object.annotator.AbstractReportBasedAnnotator;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRectangleBasedAnnotator
extends AbstractReportBasedAnnotator {
    private static final long serialVersionUID = 3536654827455977474L;
    public static final String KEY_X = ".x";
    public static final String KEY_Y = ".y";
    public static final String KEY_WIDTH = ".width";
    public static final String KEY_HEIGHT = ".height";
    public static final String KEY_POLY_X = ".poly_x";
    public static final String KEY_POLY_Y = ".poly_y";
    protected int m_NumDigits;
    protected List<SelectionRectangle> m_Locations;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-digits", "numDigits", (Object)this.getDefaultNumDigits(), (Number)0, null);
    }

    protected void reset() {
        super.reset();
        this.m_Locations = null;
    }

    @Override
    protected String getDefaultPrefix() {
        return "Object.";
    }

    protected int getDefaultNumDigits() {
        return 4;
    }

    public void setNumDigits(int value) {
        this.m_NumDigits = value;
        this.reset();
    }

    public int getNumDigits() {
        return this.m_NumDigits;
    }

    public String numDigitsTipText() {
        return "The number of digits to use for left-padding the index with zeroes.";
    }

    @Override
    public void annotationsChanged() {
        super.annotationsChanged();
        this.m_Locations = null;
    }

    protected List<SelectionRectangle> getLocations(Report report) {
        ArrayList<SelectionRectangle> result = new ArrayList<SelectionRectangle>();
        List fields = report.getFields();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith(this.m_Prefix)) continue;
            String name = field.getName().substring(this.m_Prefix.length());
            if (name.indexOf(46) > -1) {
                name = name.substring(0, name.indexOf(46));
            }
            try {
                SelectionRectangle rect = new SelectionRectangle(report.getDoubleValue(this.m_Prefix + name + KEY_X).intValue(), report.getDoubleValue(this.m_Prefix + name + KEY_Y).intValue(), report.getDoubleValue(this.m_Prefix + name + KEY_WIDTH).intValue(), report.getDoubleValue(this.m_Prefix + name + KEY_HEIGHT).intValue(), Integer.parseInt(name));
                if (result.contains(rect)) continue;
                result.add(rect);
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

