/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.annotator;

import adams.core.base.BaseRegExp;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.gui.visualization.object.annotator.AbstractAnnotator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractReportBasedAnnotator
extends AbstractAnnotator {
    private static final long serialVersionUID = 3915632192147746710L;
    protected String m_Prefix;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)this.getDefaultPrefix());
    }

    protected abstract String getDefaultPrefix();

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the fields in the report.";
    }

    protected Map<String, Object> valuesForIndex(Report report, int index) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BaseRegExp regexp = new BaseRegExp(this.m_Prefix + "[0]*" + index + "\\..*");
        for (AbstractField field : report.getFields()) {
            if (!regexp.isMatch(field.getName())) continue;
            result.put(field.getName().replaceAll(regexp.getValue(), ""), report.getValue(field));
        }
        return result;
    }

    protected boolean removeIndex(Report report, int index) {
        boolean result = false;
        BaseRegExp regexp = new BaseRegExp(this.m_Prefix + "[0]*" + index + "\\..*");
        ArrayList<AbstractField> remove = new ArrayList<AbstractField>();
        for (AbstractField field : report.getFields()) {
            if (!regexp.isMatch(field.getName())) continue;
            remove.add(field);
        }
        if (remove.size() > 0) {
            result = true;
            for (AbstractField field : remove) {
                report.removeValue(field);
            }
        }
        return result;
    }

    protected int findLastIndex(Report report) {
        int result = 0;
        List fields = report.getFields();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith(this.m_Prefix)) continue;
            String name = field.getName().substring(this.m_Prefix.length());
            if (name.indexOf(46) > -1) {
                name = name.substring(0, name.indexOf(46));
            }
            try {
                int current = Integer.parseInt(name);
                if (current <= result) continue;
                result = current;
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

