/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.mouseclick;

import adams.core.option.AbstractOptionHandler;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.KeyUtils;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import java.awt.Point;
import java.awt.event.MouseEvent;

public abstract class AbstractMouseClickProcessor
extends AbstractOptionHandler {
    private static final long serialVersionUID = 3132566195997194745L;
    protected boolean m_Enabled;
    protected MouseButton m_Button;
    protected int m_ClickCount;
    protected boolean m_ShiftDown;
    protected boolean m_AltDown;
    protected boolean m_CtrlDown;
    protected boolean m_MetaDown;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("enabled", "enabled", (Object)true);
        this.m_OptionManager.add("button", "button", (Object)MouseButton.LEFT);
        this.m_OptionManager.add("click-count", "clickCount", (Object)1, (Number)0, null);
        this.m_OptionManager.add("shift-down", "shiftDown", (Object)false);
        this.m_OptionManager.add("alt-down", "altDown", (Object)false);
        this.m_OptionManager.add("ctrl-down", "ctrlDown", (Object)false);
        this.m_OptionManager.add("meta-down", "metaDown", (Object)false);
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
        this.reset();
    }

    public boolean getEnabled() {
        return this.m_Enabled;
    }

    public String prefixTipText() {
        return "Determines whether the click processor is enabled or not.";
    }

    public void setButton(MouseButton value) {
        this.m_Button = value;
        this.reset();
    }

    public MouseButton getButton() {
        return this.m_Button;
    }

    public String buttonTipText() {
        return "The mouse button to react to.";
    }

    public void setClickCount(int value) {
        this.m_ClickCount = value;
        this.reset();
    }

    public int getClickCount() {
        return this.m_ClickCount;
    }

    public String clickCountTipText() {
        return "The number of mouse clicks; use 0 for turning check off; use 2 for double click.";
    }

    public void setShiftDown(boolean value) {
        this.m_ShiftDown = value;
        this.reset();
    }

    public boolean getShiftDown() {
        return this.m_ShiftDown;
    }

    public String shiftDownTipText() {
        return "If enabled, the SHIFT key must be down to trigger.";
    }

    public void setAltDown(boolean value) {
        this.m_AltDown = value;
        this.reset();
    }

    public boolean getAltDown() {
        return this.m_AltDown;
    }

    public String altDownTipText() {
        return "If enabled, the ALT key must be down to trigger.";
    }

    public void setCtrlDown(boolean value) {
        this.m_CtrlDown = value;
        this.reset();
    }

    public boolean getCtrlDown() {
        return this.m_CtrlDown;
    }

    public String ctrlDownTipText() {
        return "If enabled, the CTRL key must be down to trigger.";
    }

    public void setMetaDown(boolean value) {
        this.m_MetaDown = value;
        this.reset();
    }

    public boolean getMetaDown() {
        return this.m_MetaDown;
    }

    public String metaDownTipText() {
        return "If enabled, the META key must be down to trigger.";
    }

    protected LocatedObjects determineHits(ObjectAnnotationPanel panel, MouseEvent e) {
        LocatedObjects objects = panel.getObjects();
        LocatedObjects result = new LocatedObjects();
        Point location = panel.mouseToPixelLocation(e.getPoint());
        for (LocatedObject object : objects) {
            boolean add = object.hasPolygon() ? object.getActualPolygon().contains(location) : object.getActualRectangle().contains(location);
            if (!add) continue;
            result.add(object.getClone());
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("hits: " + result);
        }
        return result;
    }

    protected abstract void doProcess(ObjectAnnotationPanel var1, MouseEvent var2);

    public void process(ObjectAnnotationPanel panel, MouseEvent e) {
        if (!this.getEnabled()) {
            return;
        }
        if (this.m_Button == MouseButton.LEFT && e.getButton() != 1) {
            return;
        }
        if (this.m_Button == MouseButton.MIDDLE && e.getButton() != 2) {
            return;
        }
        if (this.m_Button == MouseButton.RIGHT && e.getButton() != 3) {
            return;
        }
        if (this.m_ClickCount > 0 && e.getClickCount() != this.m_ClickCount) {
            return;
        }
        if (this.m_ShiftDown && !KeyUtils.isShiftDown((int)e.getModifiersEx()) || !this.m_ShiftDown && KeyUtils.isShiftDown((int)e.getModifiersEx())) {
            return;
        }
        if (this.m_AltDown && !KeyUtils.isAltDown((int)e.getModifiersEx()) || !this.m_AltDown && KeyUtils.isAltDown((int)e.getModifiersEx())) {
            return;
        }
        if (this.m_CtrlDown && !KeyUtils.isCtrlDown((int)e.getModifiersEx()) || !this.m_CtrlDown && KeyUtils.isCtrlDown((int)e.getModifiersEx())) {
            return;
        }
        if (this.m_MetaDown && !KeyUtils.isMetaDown((int)e.getModifiersEx()) || !this.m_MetaDown && KeyUtils.isMetaDown((int)e.getModifiersEx())) {
            return;
        }
        this.doProcess(panel, e);
    }

    public static enum MouseButton {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

