/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.mouseclick;

import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.mouseclick.AbstractMouseClickProcessor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.MouseEvent;

public class DeleteObjects
extends AbstractMouseClickProcessor {
    private static final long serialVersionUID = -5747047661002140048L;

    public String globalInfo() {
        return "Displays the objects at the click position and deletes the selected ones.";
    }

    @Override
    protected void doProcess(ObjectAnnotationPanel panel, MouseEvent e) {
        LocatedObjects objects = new LocatedObjects(panel.getObjects());
        LocatedObjects hits = this.determineHits(panel, e);
        if (hits.size() > 0) {
            SpreadSheet sheet = null;
            for (LocatedObject hit : hits) {
                SpreadSheet sheetHit = hit.toSpreadSheet();
                if (sheet == null) {
                    sheet = sheetHit;
                    continue;
                }
                sheet.addRow().assign((Row)sheetHit.getRow(0));
            }
            SpreadSheetDialog dialog = panel.getParentDialog() != null ? new SpreadSheetDialog(panel.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new SpreadSheetDialog(panel.getParentFrame(), true);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Select objects to remove");
            dialog.setSize(GUIHelper.getDefaultDialogDimension());
            dialog.setLocationRelativeTo((Component)((Object)panel));
            dialog.setSpreadSheet(sheet);
            dialog.setShowSearch(true);
            dialog.setVisible(true);
            if (dialog.getOption() != 0) {
                return;
            }
            int[] rows = dialog.getTable().getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            for (Object row : (Object)rows) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("deleting: " + hits.get((int)row));
                }
                objects.remove(hits.get((int)row));
            }
            panel.addUndoPoint("Deleting " + rows.length + " objects");
            panel.setObjects(objects);
            panel.annotationsChanged((Object)this);
        }
    }
}

