/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.mouseclick;

import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.annotator.LabelSuffixHandler;
import adams.gui.visualization.object.mouseclick.AbstractMouseClickProcessor;
import java.awt.event.MouseEvent;

public class SetLabel
extends AbstractMouseClickProcessor {
    private static final long serialVersionUID = 8422134104160247274L;
    public static final String DEFAULT_SUFFIX = "type";

    public String globalInfo() {
        return "Sets the current label.\nIf the current label string is empty or null, then it will unset the label.";
    }

    @Override
    protected void doProcess(ObjectAnnotationPanel panel, MouseEvent e) {
        LocatedObjects objects = new LocatedObjects(panel.getObjects());
        LocatedObjects hits = this.determineHits(panel, e);
        if (hits.size() == 0) {
            return;
        }
        boolean unset = panel.getCurrentLabel() == null || panel.getCurrentLabel().isEmpty();
        String suffix = panel.getAnnotator() instanceof LabelSuffixHandler ? ((LabelSuffixHandler)((Object)panel.getAnnotator())).getLabelSuffix() : DEFAULT_SUFFIX;
        if (suffix.startsWith(".")) {
            suffix = suffix.substring(1);
        }
        panel.addUndoPoint(unset ? "Removing label" : "Setting label '" + panel.getCurrentLabel() + "'");
        for (LocatedObject hit : hits) {
            objects.remove(hit);
            if (unset) {
                hit.getMetaData().remove(suffix);
            } else {
                hit.getMetaData().put(suffix, panel.getCurrentLabel());
            }
            objects.add(hit);
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info((unset ? "unset label: " : "set label: ") + hit);
        }
        panel.setObjects(objects);
        panel.annotationsChanged((Object)this);
    }
}

