/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.overlay;

import adams.data.report.DataType;
import adams.data.report.Field;
import adams.gui.core.Fonts;
import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.overlay.AbstractOverlay;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class ClassificationLabelTextOverlay
extends AbstractOverlay {
    private static final long serialVersionUID = -4472215867236513662L;
    protected Field m_Field;
    protected Color m_Color;
    protected Font m_LabelFont;
    protected int m_LabelOffsetX;
    protected int m_LabelOffsetY;

    public String globalInfo() {
        return "Displays the classification label retrieved from the field in the report and overlays it as text on the image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", (Object)new Field("Classification", DataType.STRING));
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
        this.m_OptionManager.add("label-offset-x", "labelOffsetX", (Object)10, (Number)0, null);
        this.m_OptionManager.add("label-offset-y", "labelOffsetY", (Object)20, (Number)0, null);
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field to store the label in.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the label.";
    }

    public void setLabelFont(Font value) {
        this.m_LabelFont = value;
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    public String labelFontTipText() {
        return "The font to use for the labels.";
    }

    public void setLabelOffsetX(int value) {
        if (this.getOptionManager().isValid("labelOffsetX", (Number)value)) {
            this.m_LabelOffsetX = value;
            this.reset();
        }
    }

    public int getLabelOffsetX() {
        return this.m_LabelOffsetX;
    }

    public String labelOffsetXTipText() {
        return "The X offset for the label.";
    }

    public void setLabelOffsetY(int value) {
        if (this.getOptionManager().isValid("labelOffsetY", (Number)value)) {
            this.m_LabelOffsetY = value;
            this.reset();
        }
    }

    public int getLabelOffsetY() {
        return this.m_LabelOffsetY;
    }

    public String labelOffsetYTipText() {
        return "The Y offset for the label.";
    }

    @Override
    protected void doPaint(ObjectAnnotationPanel panel, Graphics g) {
        String label = panel.getCurrentLabel();
        if (label != null) {
            g.setColor(this.m_Color);
            g.setFont(this.getLabelFont());
            g.drawString(label, this.getLabelOffsetX(), this.getLabelOffsetY());
        }
    }
}

