/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.overlay;

import adams.gui.visualization.object.ObjectAnnotationPanel;
import adams.gui.visualization.object.overlay.AbstractObjectOverlayFromReport;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;

public class ObjectCentersOverlayFromReport
extends AbstractObjectOverlayFromReport {
    private static final long serialVersionUID = 6356419097401574024L;
    protected int m_Diameter;

    public String globalInfo() {
        return "Displays the centers of objects in the image, using data from the attached report.\nSuffixes:\n.x\n.y\n.width\n.height\nOptionally, if type information is available per object, the locations can be displayed in distinct colors per type. The type itself can be displayed as well.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("diameter", "diameter", (Object)10, (Number)-1, null);
    }

    public void setDiameter(int value) {
        if (this.getOptionManager().isValid("diameter", (Number)value)) {
            this.m_Diameter = value;
            this.reset();
        }
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the circle that is drawn; < 1 to use the rectangle's dimensions to draw an ellipse.";
    }

    @Override
    protected void doPaintObjects(ObjectAnnotationPanel panel, Graphics g, List<Polygon> locations) {
        g.setColor(this.getColor());
        g.setFont(this.getLabelFont());
        for (Polygon poly : locations) {
            String label;
            if (poly == null) continue;
            if (this.getUseColorsPerType() && this.m_Overlays.hasColor(poly)) {
                g.setColor(this.m_Overlays.getColor(poly));
            }
            Rectangle rect = poly.getBounds();
            if (this.m_Diameter < 1) {
                g.fillOval((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            } else {
                g.fillOval((int)(rect.getCenterX() - (double)this.m_Diameter), (int)(rect.getCenterY() - (double)this.m_Diameter), this.m_Diameter * 2, this.m_Diameter * 2);
            }
            if (!this.m_Overlays.hasLabel(poly) || (label = this.m_Overlays.getLabel(poly)) == null || label.isEmpty()) continue;
            this.m_Overlays.drawString(g, rect, label);
        }
    }
}

