/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.layer;

import adams.data.image.BufferedImageHelper;
import adams.gui.core.Undo;
import adams.gui.core.UndoHandlerWithQuickAccess;
import adams.gui.event.UndoEvent;
import adams.gui.event.UndoListener;
import adams.gui.visualization.segmentation.CanvasPanel;
import adams.gui.visualization.segmentation.ImageUtils;
import adams.gui.visualization.segmentation.layer.AbstractLayer;
import adams.gui.visualization.segmentation.layer.BackgroundLayer;
import adams.gui.visualization.segmentation.layer.CombinedLayer;
import adams.gui.visualization.segmentation.layer.ImageLayer;
import adams.gui.visualization.segmentation.layer.OverlayLayer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LayerManager
implements Serializable,
UndoHandlerWithQuickAccess,
UndoListener {
    private static final long serialVersionUID = 4462920156618724031L;
    protected boolean m_SplitLayers = true;
    protected BackgroundLayer m_BackgroundLayer = new BackgroundLayer();
    protected ImageLayer m_ImageLayer;
    protected CombinedLayer m_CombinedLayer;
    protected List<OverlayLayer> m_Overlays;
    protected CanvasPanel m_CanvasPanel;
    protected Set<ChangeListener> m_ChangeListeners;
    protected double m_Zoom;
    protected Undo m_Undo;
    protected boolean m_RedoBestFit;
    protected Set<ChangeListener> m_BestFitRedone;

    public LayerManager(CanvasPanel canvasPanel) {
        this.m_BackgroundLayer.setManager(this);
        this.m_ImageLayer = new ImageLayer();
        this.m_ImageLayer.setManager(this);
        this.m_CombinedLayer = null;
        this.m_Overlays = new ArrayList<OverlayLayer>();
        this.m_CanvasPanel = canvasPanel;
        this.m_ChangeListeners = new HashSet<ChangeListener>();
        this.m_Zoom = 1.0;
        this.m_RedoBestFit = false;
        this.m_BestFitRedone = new HashSet<ChangeListener>();
        this.m_Undo = new Undo(List.class, true);
        this.m_Undo.addUndoListener((UndoListener)this);
        this.m_Undo.setMaxUndo(20);
    }

    public void setSplitLayers(boolean value) {
        this.m_SplitLayers = value;
        this.clear();
    }

    public boolean getSplitLayers() {
        return this.m_SplitLayers;
    }

    public void clear() {
        this.m_Overlays.clear();
        this.m_ImageLayer.clear();
        if (this.m_CombinedLayer != null) {
            this.m_CombinedLayer.clear();
        }
        this.m_Undo.clear();
        this.update();
    }

    public void setUndo(Undo value) {
        if (this.m_Undo != null) {
            this.m_Undo.removeUndoListener((UndoListener)this);
        }
        this.m_Undo = value;
        this.m_Undo.addUndoListener((UndoListener)this);
    }

    public Undo getUndo() {
        return this.m_Undo;
    }

    public boolean isUndoSupported() {
        return this.m_Undo != null;
    }

    public void undo() {
        if (!this.getUndo().canUndo()) {
            return;
        }
        this.getUndo().undo();
    }

    public void redo() {
        if (!this.getUndo().canRedo()) {
            return;
        }
        this.getUndo().redo();
    }

    public void addUndoPoint(String comment) {
        if (this.isUndoSupported() && this.getUndo().isEnabled()) {
            this.getUndo().addUndo(this.getState(), comment);
        }
    }

    public void undoOccurred(UndoEvent e) {
        switch (e.getType()) {
            case UNDO: {
                this.getUndo().addRedo(this.getState(), e.getUndoPoint().getComment());
                this.setState((List)e.getUndoPoint().getData());
                break;
            }
            case REDO: {
                this.getUndo().addUndo(this.getState(), e.getUndoPoint().getComment(), true);
                this.setState((List)e.getUndoPoint().getData());
            }
        }
    }

    public List<AbstractLayer.AbstractLayerState> getState() {
        ArrayList<AbstractLayer.AbstractLayerState> result = new ArrayList<AbstractLayer.AbstractLayerState>();
        for (AbstractLayer l : this.getLayers()) {
            result.add(l.getState());
        }
        return result;
    }

    public void setState(List<AbstractLayer.AbstractLayerState> states) {
        for (AbstractLayer.AbstractLayerState state : states) {
            if (state instanceof BackgroundLayer.BackgroundLayerState) {
                this.getBackgroundLayer().setState(state);
                continue;
            }
            if (state instanceof ImageLayer.ImageLayerState) {
                this.getImageLayer().setState(state);
                continue;
            }
            if (state instanceof CombinedLayer.CombinedLayerState) {
                this.getCombinedLayer().setState(state);
                continue;
            }
            if (!(state instanceof OverlayLayer.OverlayLayerState)) continue;
            OverlayLayer.OverlayLayerState ostate = (OverlayLayer.OverlayLayerState)state;
            if (this.hasOverlay(ostate.name)) {
                this.getOverlay(ostate.name).setState(ostate);
                continue;
            }
            this.addOverlay(ostate.name, ostate.color, ostate.alpha, ostate.image);
        }
        this.update();
    }

    public List<AbstractLayer.AbstractLayerState> getSettings() {
        ArrayList<AbstractLayer.AbstractLayerState> result = new ArrayList<AbstractLayer.AbstractLayerState>();
        for (AbstractLayer l : this.getLayers()) {
            result.add(l.getSettings());
        }
        return result;
    }

    public void setSettings(List<AbstractLayer.AbstractLayerState> settings) {
        for (AbstractLayer.AbstractLayerState state : settings) {
            if (state instanceof BackgroundLayer.BackgroundLayerState) {
                this.getBackgroundLayer().setSettings(state);
                continue;
            }
            if (state instanceof ImageLayer.ImageLayerState) {
                this.getImageLayer().setSettings(state);
                continue;
            }
            if (state instanceof CombinedLayer.CombinedLayerState) {
                this.getCombinedLayer().setSettings(state);
                continue;
            }
            if (!(state instanceof OverlayLayer.OverlayLayerState)) continue;
            OverlayLayer.OverlayLayerState ostate = (OverlayLayer.OverlayLayerState)state;
            if (this.hasOverlay(ostate.name)) {
                this.getOverlay(ostate.name).setSettings(ostate);
                continue;
            }
            this.addOverlay(ostate.name, ostate.color, ostate.alpha, ostate.image);
        }
        this.update();
    }

    public void addBestFitRedoneListener(ChangeListener l) {
        this.m_BestFitRedone.add(l);
    }

    public void removeBestFitRedoneListener(ChangeListener l) {
        this.m_BestFitRedone.remove(l);
    }

    protected void notifyBestFitRedoneListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_BestFitRedone.toArray(new ChangeListener[0])) {
            l.stateChanged(e);
        }
    }

    public void setZoom(double value) {
        this.m_Zoom = value;
        this.update();
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public void bestFitZoom() {
        if (this.getCanvasPanel().getOwner().getScrollPane().getWidth() == 0) {
            this.m_RedoBestFit = true;
            return;
        }
        int width = this.getCanvasPanel().getOwner().getScrollPane().getWidth() - 20;
        int height = this.getCanvasPanel().getOwner().getScrollPane().getHeight() - 20;
        double zoomW = (double)width / (double)this.getImageLayer().getImage().getWidth();
        double zoomH = (double)height / (double)this.getImageLayer().getImage().getHeight();
        this.setZoom(Math.min(zoomW, zoomH));
        if (this.m_RedoBestFit) {
            this.m_RedoBestFit = false;
            this.notifyBestFitRedoneListeners();
        }
    }

    public int getWidth() {
        if (this.getImageLayer().getImage() == null) {
            return 0;
        }
        return this.getImageLayer().getImage().getWidth();
    }

    public int getActualWidth() {
        return (int)((double)this.getWidth() * this.getZoom());
    }

    public int getHeight() {
        if (this.getImageLayer().getImage() == null) {
            return 0;
        }
        return this.getImageLayer().getImage().getHeight();
    }

    public int getActualHeight() {
        return (int)((double)this.getHeight() * this.getZoom());
    }

    public CanvasPanel getCanvasPanel() {
        return this.m_CanvasPanel;
    }

    public List<AbstractLayer> getLayers() {
        ArrayList<AbstractLayer> result = new ArrayList<AbstractLayer>();
        result.add(this.getBackgroundLayer());
        result.add(this.getImageLayer());
        if (this.m_CombinedLayer != null) {
            result.add(this.m_CombinedLayer);
        } else {
            result.addAll(this.getOverlays());
        }
        return result;
    }

    public boolean hasLayer(String name) {
        return this.getLayer(name) != null;
    }

    public AbstractLayer getLayer(String name) {
        OverlayLayer result = null;
        for (OverlayLayer l : this.m_Overlays) {
            if (!l.getName().equals(name)) continue;
            result = l;
            break;
        }
        return result;
    }

    public BackgroundLayer getBackgroundLayer() {
        return this.m_BackgroundLayer;
    }

    public void setImage(String name, BufferedImage image) {
        this.m_ImageLayer.setName(name);
        this.m_ImageLayer.setImage(image);
    }

    public ImageLayer getImageLayer() {
        return this.m_ImageLayer;
    }

    public OverlayLayer addOverlay(String name, Color color, float alpha) {
        return this.addOverlay(name, color, alpha, null);
    }

    public OverlayLayer addOverlay(String name, Color color, float alpha, BufferedImage image) {
        if (!this.m_SplitLayers) {
            throw new IllegalArgumentException("Cannot add overlay layers when not using split layers!");
        }
        if (image == null) {
            image = ImageUtils.newImage(this.m_ImageLayer.getImage().getWidth(), this.m_ImageLayer.getImage().getHeight());
        } else if (image.getType() != 2) {
            image = BufferedImageHelper.convert((BufferedImage)image, (int)2);
        }
        OverlayLayer result = new OverlayLayer();
        result.setManager(this);
        result.setImage(image);
        result.setName(name);
        result.setColor(color);
        result.setAlpha(alpha);
        this.m_Overlays.add(result);
        if (this.m_Overlays.size() == 1) {
            result.setActive(true);
        }
        result.update();
        return result;
    }

    public OverlayLayer removeOverlay(String name) {
        if (!this.m_SplitLayers) {
            throw new IllegalArgumentException("Cannot remove overlay layers when not using split layers!");
        }
        int index = -1;
        for (int i = 0; i < this.m_Overlays.size(); ++i) {
            if (!this.m_Overlays.get(i).getName().equals(name)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return null;
        }
        OverlayLayer result = this.m_Overlays.remove(index);
        if (!this.hasActiveOverlay() && this.m_Overlays.size() > 0) {
            this.m_Overlays.get(0).setActive(true);
        }
        return result;
    }

    public List<OverlayLayer> getOverlays() {
        return this.m_Overlays;
    }

    public boolean hasOverlay(String name) {
        return this.getOverlay(name) != null;
    }

    public OverlayLayer getOverlay(String name) {
        OverlayLayer result = null;
        for (OverlayLayer l : this.m_Overlays) {
            if (!l.getName().equals(name)) continue;
            result = l;
            break;
        }
        return result;
    }

    public void activate(OverlayLayer layer) {
        if (!this.m_SplitLayers) {
            throw new IllegalArgumentException("Cannot activate overlay layers when not using split layers!");
        }
        for (OverlayLayer l : this.m_Overlays) {
            l.setActive(l == layer);
        }
        this.update();
    }

    public CombinedLayer addCombined(String name, Color color, float alpha) {
        return this.addCombined(name, color, alpha, null);
    }

    public CombinedLayer addCombined(String name, Color color, float alpha, BufferedImage image) {
        if (this.m_SplitLayers) {
            throw new IllegalArgumentException("Cannot add combined layer when using split layers!");
        }
        if (this.m_CombinedLayer == null) {
            this.m_CombinedLayer = new CombinedLayer();
            this.m_CombinedLayer.setManager(this);
        }
        this.m_CombinedLayer.add(name, color, alpha, image);
        this.m_CombinedLayer.update();
        return this.m_CombinedLayer;
    }

    public CombinedLayer getCombinedLayer() {
        return this.m_CombinedLayer;
    }

    public boolean hasActiveOverlay() {
        return this.getActiveOverlay() != null;
    }

    public OverlayLayer getActiveOverlay() {
        for (OverlayLayer l : this.m_Overlays) {
            if (!l.isActive() || !l.isEnabled()) continue;
            return l;
        }
        return null;
    }

    public void repaint() {
        this.m_CanvasPanel.setSize(new Dimension(this.getActualWidth(), this.getActualHeight()));
        this.m_CanvasPanel.setPreferredSize(new Dimension(this.getActualWidth(), this.getActualHeight()));
        this.m_CanvasPanel.invalidate();
        this.m_CanvasPanel.doLayout();
        this.m_CanvasPanel.repaint();
    }

    public void draw(Graphics2D g2d) {
        if (this.m_RedoBestFit) {
            this.bestFitZoom();
            return;
        }
        g2d.scale(this.getZoom(), this.getZoom());
        this.getBackgroundLayer().draw(g2d);
        this.getImageLayer().draw(g2d);
        if (this.getSplitLayers()) {
            for (OverlayLayer l : this.getOverlays()) {
                l.draw(g2d);
            }
        } else {
            this.getCombinedLayer().draw(g2d);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners.toArray(new ChangeListener[0])) {
            l.stateChanged(e);
        }
    }

    public void update() {
        this.notifyChangeListeners();
        this.repaint();
    }

    public String suggestName(String name) {
        String result;
        int count = 0;
        while (this.hasLayer(result = name + ++count)) {
        }
        return result;
    }
}

