/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.tool;

import adams.gui.core.MouseUtils;
import adams.gui.visualization.segmentation.tool.AbstractTool;
import adams.gui.visualization.segmentation.tool.ToolMouseAdapter;
import adams.gui.visualization.segmentation.tool.ToolMouseMotionAdapter;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractShapeTool
extends AbstractTool {
    private static final long serialVersionUID = -4106386739843618810L;
    protected Point m_LastPoint;

    protected void doDrawShape(Point p) {
        this.doDrawShape(Arrays.asList(p));
    }

    protected abstract void doDrawShape(List<Point> var1);

    protected void drawShape(Point p) {
        if (!this.hasAnyActive()) {
            return;
        }
        this.doDrawShape(p);
        this.getCanvas().getOwner().getManager().update();
    }

    protected void drawShape(Point from, Point to) {
        if (!this.hasAnyActive()) {
            return;
        }
        double diffX = to.x - from.x;
        double diffY = to.y - from.y;
        int steps = (int)Math.max(Math.abs(diffX), Math.abs(diffY));
        Point curr = from;
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(from);
        for (int i = 1; i < steps - 1; ++i) {
            int y;
            Point prev = curr;
            int x = (int)Math.round((double)from.x + diffX / (double)steps * (double)i);
            curr = new Point(x, y = (int)Math.round((double)from.y + diffY / (double)steps * (double)i));
            if (curr.equals(prev)) continue;
            points.add(curr);
        }
        if (!((Point)points.get(points.size() - 1)).equals(to)) {
            points.add(to);
        }
        this.doDrawShape(points);
        this.getCanvas().getOwner().getManager().update();
    }

    @Override
    protected ToolMouseAdapter createMouseListener() {
        if (this.m_Listener == null) {
            this.m_Listener = new ToolMouseAdapter(this){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (MouseUtils.isLeftClick((MouseEvent)e)) {
                        if (AbstractShapeTool.this.isAutomaticUndoEnabled()) {
                            AbstractShapeTool.this.getCanvas().getOwner().addUndoPoint();
                        }
                        AbstractShapeTool.this.drawShape(e.getPoint());
                        AbstractShapeTool.this.m_LastPoint = e.getPoint();
                        e.consume();
                    } else {
                        super.mouseClicked(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    AbstractShapeTool.this.m_LastPoint = null;
                }
            };
        }
        return this.m_Listener;
    }

    @Override
    protected ToolMouseMotionAdapter createMouseMotionListener() {
        if (this.m_MotionListener == null) {
            this.m_MotionListener = new ToolMouseMotionAdapter(this){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (this.getOwner().getCanvas().isLeftMouseDown()) {
                        if (AbstractShapeTool.this.m_LastPoint == null) {
                            AbstractShapeTool.this.drawShape(e.getPoint());
                        } else {
                            AbstractShapeTool.this.drawShape(AbstractShapeTool.this.m_LastPoint, e.getPoint());
                        }
                        AbstractShapeTool.this.m_LastPoint = e.getPoint();
                        e.consume();
                    } else {
                        super.mouseDragged(e);
                    }
                }
            };
        }
        return this.m_MotionListener;
    }
}

