/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.tool;

import adams.core.GlobalInfoSupporter;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Cursors;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.segmentation.CanvasPanel;
import adams.gui.visualization.segmentation.layer.CombinedLayer;
import adams.gui.visualization.segmentation.layer.OverlayLayer;
import adams.gui.visualization.segmentation.tool.ToolMouseAdapter;
import adams.gui.visualization.segmentation.tool.ToolMouseMotionAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;

public abstract class AbstractTool
implements Serializable,
GlobalInfoSupporter {
    private static final long serialVersionUID = -6782161796343153566L;
    protected CanvasPanel m_PanelCanvas;
    protected ToolMouseAdapter m_Listener;
    protected ToolMouseMotionAdapter m_MotionListener;
    protected BasePanel m_PanelOptions;
    protected BasePanel m_PanelFullOptions;

    protected AbstractTool() {
        this.initialize();
    }

    public abstract String globalInfo();

    protected void initialize() {
        this.m_PanelCanvas = null;
        this.m_PanelOptions = null;
        this.m_Listener = null;
        this.m_MotionListener = null;
    }

    public void setCanvas(CanvasPanel value) {
        this.m_PanelCanvas = value;
    }

    public CanvasPanel getCanvas() {
        return this.m_PanelCanvas;
    }

    public boolean hasAnyActive() {
        return this.hasActiveOverlay() || this.hasActiveCombinedSubLayer();
    }

    public boolean hasActiveOverlay() {
        if (this.m_PanelCanvas == null) {
            return false;
        }
        if (this.m_PanelCanvas.getOwner() == null) {
            return false;
        }
        return this.m_PanelCanvas.getOwner().getManager().hasActiveOverlay();
    }

    public OverlayLayer getActiveOverlay() {
        if (this.m_PanelCanvas == null) {
            return null;
        }
        if (this.m_PanelCanvas.getOwner() == null) {
            return null;
        }
        return this.m_PanelCanvas.getOwner().getManager().getActiveOverlay();
    }

    public boolean hasActiveCombinedSubLayer() {
        if (this.m_PanelCanvas == null) {
            return false;
        }
        if (this.m_PanelCanvas.getOwner() == null) {
            return false;
        }
        if (this.m_PanelCanvas.getOwner().getManager().getCombinedLayer() == null) {
            return false;
        }
        return this.m_PanelCanvas.getOwner().getManager().getCombinedLayer().hasActiveSubLayer();
    }

    public CombinedLayer.CombinedSubLayer getActiveCombinedSubLayer() {
        if (this.m_PanelCanvas == null) {
            return null;
        }
        if (this.m_PanelCanvas.getOwner() == null) {
            return null;
        }
        if (this.m_PanelCanvas.getOwner().getManager().getCombinedLayer() == null) {
            return null;
        }
        return this.m_PanelCanvas.getOwner().getManager().getCombinedLayer().getActiveSubLayer();
    }

    public BufferedImage getActiveImage() {
        if (this.hasActiveOverlay()) {
            return this.getActiveOverlay().getImage();
        }
        if (this.hasActiveCombinedSubLayer()) {
            return this.getActiveCombinedSubLayer().getOwner().getImage();
        }
        return null;
    }

    public Color getActiveColor() {
        if (this.hasActiveOverlay()) {
            return this.getActiveOverlay().getColor();
        }
        if (this.hasActiveCombinedSubLayer()) {
            return this.getActiveCombinedSubLayer().getColor();
        }
        return null;
    }

    public double getZoom() {
        if (this.m_PanelCanvas == null) {
            return 1.0;
        }
        if (this.m_PanelCanvas.getOwner() == null) {
            return 1.0;
        }
        return this.m_PanelCanvas.getOwner().getManager().getZoom();
    }

    public boolean isAutomaticUndoEnabled() {
        if (this.getCanvas() == null) {
            return false;
        }
        if (this.getCanvas().getOwner() == null) {
            return false;
        }
        return this.getCanvas().getOwner().isAutomaticUndoEnabled();
    }

    public abstract String getName();

    public abstract Icon getIcon();

    protected abstract Cursor createCursor();

    public Cursor getCursor() {
        if (!this.hasAnyActive()) {
            return Cursors.disabled();
        }
        return this.createCursor();
    }

    protected abstract ToolMouseAdapter createMouseListener();

    public ToolMouseAdapter getMouseListener() {
        if (this.m_Listener == null) {
            this.m_Listener = this.createMouseListener();
        }
        return this.m_Listener;
    }

    protected abstract ToolMouseMotionAdapter createMouseMotionListener();

    public ToolMouseMotionAdapter getMouseMotionListener() {
        if (this.m_MotionListener == null) {
            this.m_MotionListener = this.createMouseMotionListener();
        }
        return this.m_MotionListener;
    }

    protected abstract void doApply();

    public void apply(BaseFlatButton button) {
        this.setApplyButtonState(button, false);
        this.doApply();
        this.getCanvas().setCursor(this.getCursor());
    }

    protected BaseFlatButton createApplyButton() {
        BaseFlatButton result = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"validate.png"));
        result.setToolTipText("Apply current values");
        result.addActionListener(e -> this.apply((BaseFlatButton)e.getSource()));
        return result;
    }

    protected void setApplyButtonState(BaseFlatButton button, boolean modified) {
        if (modified) {
            button.setIcon((Icon)GUIHelper.getIcon((String)"validate_blue.png"));
        } else {
            button.setIcon((Icon)GUIHelper.getIcon((String)"validate.png"));
        }
    }

    protected abstract BasePanel createOptionPanel();

    public BasePanel getOptionPanel() {
        if (this.m_PanelOptions == null) {
            this.m_PanelOptions = this.createOptionPanel();
            this.m_PanelFullOptions = new BasePanel((LayoutManager)new BorderLayout(5, 5));
            String info = this.globalInfo();
            if (info != null) {
                BaseTextArea textArea = new BaseTextArea();
                textArea.setEditable(false);
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                textArea.setColumns(20);
                textArea.setRows(4);
                textArea.setText(this.globalInfo());
                this.m_PanelFullOptions.add((Component)new BaseScrollPane((Component)textArea), (Object)"North");
                this.m_PanelFullOptions.setBorder((Border)BorderFactory.createTitledBorder("Description"));
            }
            this.m_PanelFullOptions.add((Component)this.m_PanelOptions, (Object)"Center");
        }
        return this.m_PanelFullOptions;
    }
}

