/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.tool;

import adams.gui.core.BaseFlatButton;
import adams.gui.core.BasePanel;
import adams.gui.core.CheckedTextField;
import adams.gui.core.Cursors;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.NumberTextField;
import adams.gui.visualization.segmentation.ImageUtils;
import adams.gui.visualization.segmentation.tool.AbstractTool;
import adams.gui.visualization.segmentation.tool.ToolMouseAdapter;
import adams.gui.visualization.segmentation.tool.ToolMouseMotionAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class BucketFill
extends AbstractTool {
    private static final long serialVersionUID = 2574859830274268039L;
    public static final int DEFAULT_SIZE = 15;
    protected JRadioButton m_RadioBackground;
    protected JRadioButton m_RadioForeground;
    protected NumberTextField m_TextZoom;
    protected BaseFlatButton m_ButtonApply;
    protected boolean m_Foreground;
    protected int m_Size;
    protected double m_Zoom;

    @Override
    public String globalInfo() {
        return "Fills in pixels using either the background (= black) or the foreground (color of the active layer).";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Foreground = true;
        this.m_Size = 15;
        this.m_Zoom = 100.0;
    }

    @Override
    public String getName() {
        return "Bucket fill";
    }

    @Override
    public Icon getIcon() {
        return GUIHelper.getIcon((String)"bucket.png");
    }

    @Override
    protected Cursor createCursor() {
        return Cursors.crosshair((int)this.m_Size, (double)(this.m_Zoom / 100.0));
    }

    protected void fill(Point p) {
        if (!this.hasAnyActive()) {
            return;
        }
        if (this.isAutomaticUndoEnabled()) {
            this.getCanvas().getOwner().addUndoPoint();
        }
        Color pColor = new Color(this.getActiveImage().getRGB(p.x, p.y), true);
        if (this.m_Foreground) {
            ImageUtils.fill(this.getActiveImage(), p, pColor, this.getActiveColor());
        } else {
            ImageUtils.fill(this.getActiveImage(), p, pColor, new Color(0, 0, 0, 0));
        }
        this.getCanvas().getOwner().getManager().update();
    }

    @Override
    protected ToolMouseAdapter createMouseListener() {
        ToolMouseAdapter result = new ToolMouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isLeftClick((MouseEvent)e)) {
                    Point scaled = new Point((int)((double)e.getX() / BucketFill.this.getZoom()), (int)((double)e.getY() / BucketFill.this.getZoom()));
                    BucketFill.this.fill(scaled);
                    e.consume();
                } else {
                    super.mouseClicked(e);
                }
            }
        };
        return result;
    }

    @Override
    protected ToolMouseMotionAdapter createMouseMotionListener() {
        return new ToolMouseMotionAdapter(this);
    }

    @Override
    protected void doApply() {
        this.m_Foreground = this.m_RadioForeground.isSelected();
        this.m_Zoom = this.m_TextZoom.getValue().doubleValue();
        this.m_Size = 15;
    }

    @Override
    protected BasePanel createOptionPanel() {
        BasePanel result = new BasePanel();
        result.setBorder((Border)BorderFactory.createTitledBorder(this.getName()));
        this.m_ButtonApply = this.createApplyButton();
        JPanel panel = new JPanel(new GridLayout(0, 1));
        result.add((Component)panel, (Object)"North");
        ButtonGroup group = new ButtonGroup();
        this.m_RadioBackground = new JRadioButton("Background");
        this.m_RadioBackground.setSelected(!this.m_Foreground);
        this.m_RadioBackground.addActionListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        group.add(this.m_RadioBackground);
        panel.add(Fonts.usePlain((Component)this.m_RadioBackground));
        this.m_RadioForeground = new JRadioButton("Foreground");
        this.m_RadioForeground.setSelected(this.m_Foreground);
        this.m_RadioForeground.addActionListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        group.add(this.m_RadioForeground);
        panel.add(Fonts.usePlain((Component)this.m_RadioForeground));
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel.add(panel2);
        panel2.add(Fonts.usePlain((Component)new JLabel("Cursor size (%)")));
        this.m_TextZoom = new NumberTextField(NumberTextField.Type.DOUBLE, "" + this.m_Zoom);
        this.m_TextZoom.setColumns(5);
        this.m_TextZoom.setToolTipText("100 = original cursor size");
        this.m_TextZoom.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.DOUBLE, (Number)1.0, null));
        this.m_TextZoom.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        panel2.add((Component)this.m_TextZoom);
        panel2 = new JPanel(new FlowLayout(0));
        panel.add(panel2);
        panel2.add((Component)this.m_ButtonApply);
        return result;
    }
}

