/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.tool;

import adams.gui.core.BaseFlatButton;
import adams.gui.core.BasePanel;
import adams.gui.core.CheckedTextField;
import adams.gui.core.Cursors;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.visualization.segmentation.ImageUtils;
import adams.gui.visualization.segmentation.tool.AbstractShapeTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class Eraser
extends AbstractShapeTool {
    public static final int DEFAULT_SIZE = 9;
    private static final long serialVersionUID = -3058489939334040466L;
    protected JRadioButton m_RadioRound;
    protected JRadioButton m_RadioSquare;
    protected NumberTextField m_TextSize;
    protected BaseFlatButton m_ButtonApply;
    protected boolean m_Round;
    protected int m_Size;

    @Override
    public String globalInfo() {
        return "Removes pixels using the background.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Round = false;
        this.m_Size = 9;
    }

    @Override
    public String getName() {
        return "Eraser";
    }

    @Override
    public Icon getIcon() {
        return GUIHelper.getIcon((String)"eraser.png");
    }

    @Override
    protected Cursor createCursor() {
        if (this.m_Round) {
            return Cursors.circleWithPointer((int)this.m_Size);
        }
        return Cursors.squareWithPointer((int)this.m_Size);
    }

    @Override
    protected void doDrawShape(List<Point> points) {
        double zoom = this.getZoom();
        BufferedImage img = this.getActiveImage();
        Graphics2D g2d = img.createGraphics();
        g2d.scale(1.0 / zoom, 1.0 / zoom);
        g2d.setColor(Color.BLACK);
        for (Point p : points) {
            int x = (int)(p.getX() - (double)(this.m_Size / 2));
            int y = (int)(p.getY() - (double)(this.m_Size / 2));
            if (this.m_RadioRound.isSelected()) {
                g2d.fillOval(x, y, this.m_Size - 1, this.m_Size - 1);
                continue;
            }
            g2d.fillRect(x, y, this.m_Size - 1, this.m_Size - 1);
        }
        g2d.dispose();
        ImageUtils.replaceColor(this.getActiveImage(), Color.BLACK, new Color(0, 0, 0, 0));
    }

    @Override
    protected void doApply() {
        this.m_Round = this.m_RadioRound.isSelected();
        this.m_Size = this.m_TextSize.getValue().intValue();
    }

    @Override
    protected BasePanel createOptionPanel() {
        BasePanel result = new BasePanel();
        result.setBorder((Border)BorderFactory.createTitledBorder(this.getName()));
        this.m_ButtonApply = this.createApplyButton();
        JPanel panel = new JPanel(new GridLayout(0, 1));
        result.add((Component)panel, (Object)"North");
        ButtonGroup group = new ButtonGroup();
        this.m_RadioSquare = new JRadioButton("Square");
        this.m_RadioSquare.setSelected(!this.m_Round);
        this.m_RadioSquare.addActionListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        group.add(this.m_RadioSquare);
        panel.add(Fonts.usePlain((Component)this.m_RadioSquare));
        this.m_RadioRound = new JRadioButton("Round");
        this.m_RadioRound.setSelected(this.m_Round);
        this.m_RadioRound.addActionListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        group.add(this.m_RadioRound);
        panel.add(Fonts.usePlain((Component)this.m_RadioRound));
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel.add(panel2);
        panel2.add(Fonts.usePlain((Component)new JLabel("Size")));
        this.m_TextSize = new NumberTextField(NumberTextField.Type.INTEGER, "" + this.m_Size);
        this.m_TextSize.setColumns(5);
        this.m_TextSize.setToolTipText("The size in on-screen pixels");
        this.m_TextSize.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.INTEGER, (Number)1, null));
        this.m_TextSize.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        panel2.add((Component)this.m_TextSize);
        panel2 = new JPanel(new FlowLayout(0));
        panel.add(panel2);
        panel2.add((Component)this.m_ButtonApply);
        return result;
    }
}

