/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.PlaceholderFile;
import adams.core.io.SimpleFixedFilenameGenerator;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.io.output.DefaultSimpleReportWriter;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.ChangeImageObjectPrefix;
import adams.flow.transformer.ReportFileReader;
import adams.flow.transformer.ReportFileWriter;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ChangeImageObjectPrefixTest
extends AbstractFlowTest {
    public ChangeImageObjectPrefixTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("annotated_objects.report");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("annotated_objects.report");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[]{0, 1};
    }

    public static Test suite() {
        return new TestSuite(ChangeImageObjectPrefixTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/annotated_objects.report"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            ReportFileReader reportfilereader = new ReportFileReader();
            DefaultSimpleReportReader defaultsimplereportreader = new DefaultSimpleReportReader();
            reportfilereader.setReader((AbstractReportReader)defaultsimplereportreader);
            actors.add(reportfilereader);
            ChangeImageObjectPrefix changeImageObjectPrefix = new ChangeImageObjectPrefix();
            changeImageObjectPrefix.setFinder((ObjectFinder)new AllFinder());
            changeImageObjectPrefix.setPrefixNew("Predicted.");
            actors.add(changeImageObjectPrefix);
            ReportFileWriter reportfilewriter = new ReportFileWriter();
            DefaultSimpleReportWriter defaultsimplereportwriter = new DefaultSimpleReportWriter();
            reportfilewriter.setWriter((AbstractReportWriter)defaultsimplereportwriter);
            SimpleFixedFilenameGenerator simplefixedfilenamegenerator = new SimpleFixedFilenameGenerator();
            argOption = (AbstractArgumentOption)simplefixedfilenamegenerator.getOptionManager().findByProperty("name");
            simplefixedfilenamegenerator.setName((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            reportfilewriter.setFilenameGenerator((AbstractFilenameGenerator)simplefixedfilenamegenerator);
            actors.add(reportfilewriter);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            ChangeImageObjectPrefixTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ChangeImageObjectPrefixTest.runTest((Test)ChangeImageObjectPrefixTest.suite());
    }
}

