/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jooq;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionHandler;
import adams.data.jooq.AbstractJOOQConfigurationGenerator;
import java.sql.DriverManager;
import org.jooq.SQLDialect;

public class BasicConfigurationGenerator
extends AbstractJOOQConfigurationGenerator {
    private static final long serialVersionUID = -3726686726236010246L;
    protected SQLDialect m_Dialect;
    protected String m_Schema;
    protected BaseRegExp[] m_Includes;
    protected BaseRegExp[] m_Excludes;
    protected String m_PackageName;
    protected PlaceholderDirectory m_OutputDir;

    public String globalInfo() {
        return "Basic generator.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dialect", "dialect", (Object)SQLDialect.MYSQL);
        this.m_OptionManager.add("schema", "schema", (Object)"somedatabase");
        this.m_OptionManager.add("include", "includes", (Object)new BaseRegExp[]{new BaseRegExp(".*")});
        this.m_OptionManager.add("exclude", "excludes", (Object)new BaseRegExp[0]);
        this.m_OptionManager.add("package-name", "packageName", (Object)"adams.db.database");
        this.m_OptionManager.add("output-dir", "outputDir", (Object)new PlaceholderDirectory("${TMP}"));
    }

    public void setDialect(SQLDialect value) {
        this.m_Dialect = value;
        this.reset();
    }

    public SQLDialect getDialect() {
        return this.m_Dialect;
    }

    public String dialectTipText() {
        return "The SQL dialect to use.";
    }

    public void setSchema(String value) {
        this.m_Schema = value;
        this.reset();
    }

    public String getSchema() {
        return this.m_Schema;
    }

    public String schemaTipText() {
        return "The database schema to use.";
    }

    public void setIncludes(BaseRegExp[] value) {
        this.m_Includes = value;
        this.reset();
    }

    public BaseRegExp[] getIncludes() {
        return this.m_Includes;
    }

    public String includesTipText() {
        return "The regular expressions to use for including tables of the schema.";
    }

    public void setExcludes(BaseRegExp[] value) {
        this.m_Excludes = value;
        this.reset();
    }

    public BaseRegExp[] getExcludes() {
        return this.m_Excludes;
    }

    public String excludesTipText() {
        return "The regular expressions to use for excluding tables of the schema.";
    }

    public void setPackageName(String value) {
        this.m_PackageName = value;
        this.reset();
    }

    public String getPackageName() {
        return this.m_PackageName;
    }

    public String packageNameTipText() {
        return "The Java package name to use.";
    }

    public void setOutputDir(PlaceholderDirectory value) {
        this.m_OutputDir = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDir() {
        return this.m_OutputDir;
    }

    public String outputDirTipText() {
        return "The directory to store the generated code in.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"schema", (Object)this.m_Schema, (String)", schema: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dialect", (Object)this.m_Dialect, (String)", dialect: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputDir", (Object)this.m_OutputDir, (String)", output-dir: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"packageName", (Object)this.m_PackageName, (String)", package: ");
        return result;
    }

    @Override
    protected String doGenerate() throws Exception {
        StringBuilder result = new StringBuilder();
        result.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        result.append("<configuration xmlns=\"http://www.jooq.org/xsd/jooq-codegen-3.2.0.xsd\">\n");
        result.append("  <jdbc>\n");
        result.append("    <driver>" + DriverManager.getDriver(this.m_DatabaseConnection.getURL()).getClass().getName() + "</driver>\n");
        result.append("    <url>" + this.m_DatabaseConnection.getURL() + "</url>\n");
        result.append("    <user>" + this.m_DatabaseConnection.getUser() + "</user>\n");
        result.append("    <password>" + this.m_DatabaseConnection.getPassword().getValue() + "</password>\n");
        result.append("  </jdbc>\n");
        result.append("  <generator>\n");
        result.append("    <name>" + this.m_Provider.generate().getClass().getName() + "</name>\n");
        result.append("    <database>\n");
        result.append("      <name>org.jooq.util." + this.m_Dialect.getNameLC() + "." + this.m_Dialect.getName() + "Database</name>\n");
        result.append("      <inputSchema>" + this.m_Schema + "</inputSchema>\n");
        result.append("      <includes>" + Utils.flatten((Object[])this.m_Includes, (String)"|") + "</includes>\n");
        result.append("      <excludes>" + Utils.flatten((Object[])this.m_Excludes, (String)"|") + "</excludes>\n");
        result.append("    </database>\n");
        result.append("    <target>\n");
        result.append("      <packageName>" + this.m_PackageName + "</packageName>\n");
        result.append("      <directory>" + this.m_OutputDir.getAbsolutePath() + "</directory>\n");
        result.append("    </target>\n");
        result.append("  </generator>\n");
        result.append("</configuration>\n");
        return result.toString();
    }
}

