/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DataRowTypeHandler;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.data.spreadsheet.sql.Reader;
import java.sql.ResultSet;
import org.jooq.Result;

public class JOOQResultToSpreadSheet
extends AbstractConversion
implements DataRowTypeHandler {
    private static final long serialVersionUID = -1978448247862661404L;
    protected AbstractTypeMapper m_TypeMapper;
    protected DataRow m_DataRowType;
    protected Reader m_Reader;

    public String globalInfo() {
        return "Converts a jOOQ query Result to a SpreadSheet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type-mapper", "typeMapper", (Object)new DefaultTypeMapper());
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)new DenseDataRow());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"dataRowType", (Object)this.m_DataRowType, (String)"row type: ");
    }

    public void setTypeMapper(AbstractTypeMapper value) {
        this.m_TypeMapper = value;
        this.reset();
    }

    public AbstractTypeMapper getTypeMapper() {
        return this.m_TypeMapper;
    }

    public String typeMapperTipText() {
        return "The type mapper to use for mapping spreadsheet and SQL types.";
    }

    public void setDataRowType(DataRow value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRow getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public Class accepts() {
        return Result.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        Result jooq = (Result)this.m_Input;
        ResultSet rs = jooq.intoResultSet();
        this.m_Reader = new Reader(this.m_TypeMapper, this.m_DataRowType.getClass());
        SpreadSheet result = this.m_Reader.read(rs);
        this.m_Reader = null;
        return result;
    }

    public void stopExecution() {
        if (this.m_Reader != null) {
            this.m_Reader.stopExecution();
        }
        super.stopExecution();
    }
}

