/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jooq;

import adams.core.io.PlaceholderFile;
import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.data.jooq.AbstractJOOQConfigurationGenerator;
import adams.data.jooq.AbstractScriptedJOOQConfigurationGenerator;

public class ScriptedConfigurationGenerator
extends AbstractScriptedJOOQConfigurationGenerator {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient AbstractJOOQConfigurationGenerator m_GeneratorObject;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "A configuration generator that uses any scripting handler for generating the configuration with a script located in the specified file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(AbstractJOOQConfigurationGenerator.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected void check() {
        super.check();
        this.m_GeneratorObject = (AbstractJOOQConfigurationGenerator)((Object)this.m_ScriptObject);
        if (this.m_GeneratorObject == null) {
            throw new IllegalStateException("Failed to load script?");
        }
        this.m_GeneratorObject.setDatabaseConnection(this.getDatabaseConnection());
        this.m_GeneratorObject.setOutput(this.getOutput());
    }

    @Override
    protected String doGenerate() throws Exception {
        return null;
    }

    @Override
    public PlaceholderFile generate() {
        this.check();
        return this.m_GeneratorObject.generate();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_GeneratorObject = null;
    }
}

