/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.jooq.AbstractJOOQConfigurationGenerator;
import adams.data.jooq.BasicConfigurationGenerator;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionUser;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import adams.flow.standalone.DatabaseConnectionProvider;

public class JOOQGenerateConfiguration
extends AbstractSimpleSource
implements DatabaseConnectionUser {
    private static final long serialVersionUID = -5614004831683875187L;
    protected AbstractJOOQConfigurationGenerator m_Generator;

    public String globalInfo() {
        return "Generates an XML configuration file for the jOOQ code generator.\nForwards the name of the generated file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new BasicConfigurationGenerator());
    }

    public void setGenerator(AbstractJOOQConfigurationGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractJOOQConfigurationGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator for creating the jOOQ XML configuration file.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator));
    }

    public Class[] generates() {
        return new Class[]{PlaceholderFile.class};
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((Actor)this, DatabaseConnectionProvider.class, (AbstractDatabaseConnection)DatabaseConnection.getSingleton());
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Generator.setDatabaseConnection(this.getDatabaseConnection());
            PlaceholderFile file = this.m_Generator.generate();
            if (file == null) {
                result = "Failed to generate XML configuration file!";
            } else {
                this.m_OutputToken = new Token((Object)file);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate XML configuration file!", e);
        }
        return result;
    }
}

