/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.HelpProvider;
import adams.core.base.AbstractBaseString;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;

public class JsonPathExpression
extends AbstractBaseString
implements HelpProvider {
    private static final long serialVersionUID = -6084976027405972444L;

    public JsonPathExpression() {
    }

    public JsonPathExpression(String s) {
        super(s);
    }

    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0 || !value.startsWith("$")) {
            return true;
        }
        try {
            JsonPath.compile((String)value, (Predicate[])new Predicate[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSimpleKey() {
        return !this.getValue().startsWith("$");
    }

    public boolean isIndefinite() {
        return this.getValue().matches(".*(\\.\\.|\\?\\(|\\[[0-9]+,[0-9]+).*");
    }

    public JsonPath toJsonPath() {
        try {
            return JsonPath.compile((String)this.getValue(), (Predicate[])new Predicate[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTipText() {
        return "JSON Path expression (interpreted as path if starts with '$', otherwise simple key)";
    }

    public String getHelpURL() {
        return "https://github.com/json-path/JsonPath";
    }

    public String getHelpDescription() {
        return "More information on JSON Path";
    }

    public String getHelpTitle() {
        return null;
    }

    public String getHelpIcon() {
        return "help.gif";
    }
}

