/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import java.lang.reflect.Array;
import net.minidev.json.JSONArray;

public class ArrayToJsonArray
extends AbstractConversion {
    private static final long serialVersionUID = -7259688335769678668L;

    public String globalInfo() {
        return "Turns an object array into a JSON array.";
    }

    public Class accepts() {
        return Object[].class;
    }

    public Class generates() {
        return JSONArray.class;
    }

    protected Object doConvert() throws Exception {
        if (!this.m_Input.getClass().isArray()) {
            throw new IllegalArgumentException("Input is not an array: " + this.m_Input.getClass().getName());
        }
        JSONArray result = new JSONArray();
        for (int i = 0; i < Array.getLength(this.m_Input); ++i) {
            result.add(Array.get(this.m_Input, i));
        }
        return result;
    }
}

