/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.io.PrettyPrintingSupporter;
import adams.data.conversion.AbstractConversionToString;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import net.minidev.json.JSONAware;

public class JsonToString
extends AbstractConversionToString
implements PrettyPrintingSupporter {
    private static final long serialVersionUID = -468714756281370533L;
    protected boolean m_PrettyPrinting;

    public String globalInfo() {
        return "Turns a JSON object/array into a string.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the output is printed in a 'pretty' format.";
    }

    public Class accepts() {
        return JSONAware.class;
    }

    protected Object doConvert() throws Exception {
        String result = ((JSONAware)this.m_Input).toJSONString();
        if (this.m_PrettyPrinting) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(result);
            result = gson.toJson(je);
        }
        return result;
    }
}

