/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionFromString;
import adams.flow.transformer.JsonFileReader;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class StringToJson
extends AbstractConversionFromString {
    private static final long serialVersionUID = 1484255065339335859L;
    protected JsonFileReader.OutputType m_Type;

    public String globalInfo() {
        return "Turns a string into a JSON object or array.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)JsonFileReader.OutputType.ANY);
    }

    public void setType(JsonFileReader.OutputType value) {
        this.m_Type = value;
        this.reset();
    }

    public JsonFileReader.OutputType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of object to forward.";
    }

    public Class generates() {
        switch (this.m_Type) {
            case ANY: {
                return JSONAware.class;
            }
            case ARRAY: {
                return JSONArray.class;
            }
            case OBJECT: {
                return JSONObject.class;
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
    }

    protected Object doConvert() throws Exception {
        try {
            Object result = new JSONParser(1984).parse((String)this.m_Input);
            switch (this.m_Type) {
                case ANY: {
                    return result;
                }
                case ARRAY: {
                    return (JSONArray)result;
                }
                case OBJECT: {
                    return (JSONObject)result;
                }
            }
            throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
        }
        catch (Exception e) {
            throw new Exception("Failed to parse: " + this.m_Input, e);
        }
    }
}

